/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;

public class JdbcLeakPrevention {
    protected static Logger log = Logger.getLogger(JdbcLeakPrevention.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");

    public void clearJdbcDriverRegistrations() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sqle) {
                log.warn((Object)sm.getString("jdbcLeakPrevention.jdbcRemoveFailed", driver.toString()), (Throwable)sqle);
            }
        }
    }
}

