/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.JarRepository;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;

public class ServerJarRepository
implements JarRepository,
Contained,
Lifecycle {
    private static Logger log = Logger.getLogger(ServerJarRepository.class);
    protected static HashSet<String> skipJars = new HashSet();
    protected Container container = null;
    protected String info = "org.apache.catalina.core.ServerJarRepository/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm;
    protected boolean started = false;

    public ServerJarRepository() {
        this(null);
    }

    public ServerJarRepository(Container container) {
        this.setContainer(container);
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextJarRepository.alreadyStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextJarRepository.notStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public Map<String, JarFile> getJars() {
        return null;
    }

    @Override
    public JarFile findJar(String path) {
        return null;
    }

    @Override
    public JarFile[] findJars() {
        return null;
    }

    @Override
    public Map<String, File> getExplodedJars() {
        return null;
    }

    @Override
    public File[] findExplodedJars() {
        return null;
    }

    static {
        skipJars.add("bootstrap.jar");
        skipJars.add("commons-daemon.jar");
        skipJars.add("tomcat-juli.jar");
        skipJars.add("annotations-api.jar");
        skipJars.add("catalina.jar");
        skipJars.add("catalina-ant.jar");
        skipJars.add("el-api.jar");
        skipJars.add("jasper.jar");
        skipJars.add("jasper-el.jar");
        skipJars.add("jasper-jdt.jar");
        skipJars.add("jsp-api.jar");
        skipJars.add("servlet-api.jar");
        skipJars.add("tomcat-coyote.jar");
        skipJars.add("tomcat-dbcp.jar");
        skipJars.add("tomcat-i18n-en.jar");
        skipJars.add("tomcat-i18n-es.jar");
        skipJars.add("tomcat-i18n-fr.jar");
        skipJars.add("tomcat-i18n-ja.jar");
        skipJars.add("ant.jar");
        skipJars.add("commons-dbcp.jar");
        skipJars.add("commons-beanutils.jar");
        skipJars.add("commons-fileupload-1.0.jar");
        skipJars.add("commons-pool.jar");
        skipJars.add("commons-digester.jar");
        skipJars.add("commons-logging.jar");
        skipJars.add("commons-collections.jar");
        skipJars.add("jmx.jar");
        skipJars.add("jmx-tools.jar");
        skipJars.add("xercesImpl.jar");
        skipJars.add("xmlParserAPIs.jar");
        skipJars.add("xml-apis.jar");
        skipJars.add("sunjce_provider.jar");
        skipJars.add("ldapsec.jar");
        skipJars.add("localedata.jar");
        skipJars.add("dnsns.jar");
        skipJars.add("tools.jar");
        skipJars.add("sunpkcs11.jar");
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

