/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class AprEndpoint {
    protected static Logger log = Logger.getLogger(AprEndpoint.class);
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected Executor executor = null;
    protected int maxThreads = 200;
    protected int threadPriority = 5;
    protected int pollerSize = 8192;
    protected int sendfileSize = 1024;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected boolean deferAccept = true;
    protected int keepAliveTimeout = -1;
    protected int pollTime = 2000;
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useSendfile = Library.APR_HAS_SENDFILE;
    protected Poller poller = null;
    protected Poller eventPoller = null;
    protected Sendfile sendfile = null;
    protected long serverAddress = 0L;
    protected int serverAddressFamily = 0;
    protected boolean reverseConnection = false;
    protected ListSock[] listsock = null;
    protected boolean SSLEnabled = false;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setPollerSize(int pollerSize) {
        this.pollerSize = pollerSize;
    }

    public int getPollerSize() {
        return this.pollerSize;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public Poller getEventPoller() {
        return this.eventPoller;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    public boolean isReverseConnection() {
        return this.reverseConnection;
    }

    public void setReverseConnection(boolean reverseConnection) {
        this.reverseConnection = reverseConnection;
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getConnectionCount();
    }

    public int getSendfileCount() {
        if (this.sendfile == null) {
            return 0;
        }
        return this.sendfile.getSendfileCount();
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.curThreadsBusy;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.rootPool = Pool.create(0L);
        this.serverSockPool = Pool.create(this.rootPool);
        String addressStr = null;
        addressStr = this.address == null ? null : this.address.getHostAddress();
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                if (!(OS.IS_BSD || OS.IS_WIN32 || OS.IS_WIN64)) {
                    family = 0;
                }
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            this.useSendfile = false;
        }
        long inetAddress = Address.info(addressStr, family, this.port, 0, this.rootPool);
        if (!this.reverseConnection) {
            this.serverSock = Socket.create(Address.getInfo((long)inetAddress).family, 0, 6, this.rootPool);
            if (OS.IS_UNIX) {
                Socket.optSet(this.serverSock, 16, 1);
            }
            Socket.optSet(this.serverSock, 2, 1);
            int ret = Socket.bind(this.serverSock, inetAddress);
            if (ret != 0) {
                throw new Exception(sm.getString("endpoint.init.bind", "" + ret, Error.strerror(ret)));
            }
            ret = Socket.listen(this.serverSock, this.backlog);
            if (ret != 0) {
                throw new Exception(sm.getString("endpoint.init.listen", "" + ret, Error.strerror(ret)));
            }
            if (OS.IS_WIN32 || OS.IS_WIN64) {
                Socket.optSet(this.serverSock, 16, 1);
            }
            if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
                this.deferAccept = false;
            }
        } else {
            this.listsock = new ListSock[10];
            for (int i = 0; i < this.listsock.length; ++i) {
                this.listsock[i] = new ListSock();
                this.listsock[i].port = this.port + i;
                this.listsock[i].count = 0;
            }
            this.serverAddress = inetAddress;
            this.serverAddressFamily = family;
            this.deferAccept = false;
        }
        if (this.SSLEnabled) {
            int value = 7;
            if ("SSLv2".equalsIgnoreCase(this.SSLProtocol)) {
                value = 1;
            } else if ("SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 2;
            } else if ("TLSv1".equalsIgnoreCase(this.SSLProtocol)) {
                value = 4;
            } else if ("SSLv2+SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 3;
            }
            this.sslContext = SSLContext.make(this.rootPool, value, this.reverseConnection ? 0 : 1);
            SSLContext.setCipherSuite(this.sslContext, this.SSLCipherSuite);
            SSLContext.setCertificate(this.sslContext, this.SSLCertificateFile, this.SSLCertificateKeyFile, this.SSLPassword, 0);
            SSLContext.setCertificateChainFile(this.sslContext, this.SSLCertificateChainFile, false);
            SSLContext.setCACertificate(this.sslContext, this.SSLCACertificateFile, this.SSLCACertificatePath);
            SSLContext.setCARevocation(this.sslContext, this.SSLCARevocationFile, this.SSLCARevocationPath);
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify(this.sslContext, value, this.SSLVerifyDepth);
            this.useSendfile = false;
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.executor == null) {
                this.workers = new WorkerStack(this.maxThreads);
            }
            this.poller = new Poller(false);
            this.poller.init();
            Thread pollerThread = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            pollerThread.setPriority(this.threadPriority);
            pollerThread.setDaemon(true);
            pollerThread.start();
            this.eventPoller = new Poller(true);
            this.eventPoller.init();
            Thread eventPollerThread = new Thread((Runnable)this.eventPoller, this.getName() + "-EventPoller");
            eventPollerThread.setPriority(this.threadPriority);
            eventPollerThread.setDaemon(true);
            eventPollerThread.start();
            if (this.useSendfile) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                Thread sendfileThread = new Thread((Runnable)this.sendfile, this.getName() + "-Sendfile");
                sendfileThread.setPriority(this.threadPriority);
                sendfileThread.setDaemon(true);
                sendfileThread.start();
            }
            Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor");
            acceptorThread.setPriority(this.threadPriority);
            acceptorThread.setDaemon(this.daemon);
            acceptorThread.start();
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            this.poller.destroy();
            this.poller = null;
            this.eventPoller.destroy();
            this.eventPoller = null;
            if (this.useSendfile) {
                this.sendfile.destroy();
                this.sendfile = null;
            }
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        Pool.destroy(this.serverSockPool);
        this.serverSockPool = 0L;
        Socket.close(this.serverSock);
        this.serverSock = 0L;
        this.sslContext = 0L;
        Pool.destroy(this.rootPool);
        this.rootPool = 0L;
        this.initialized = false;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        java.net.Socket s = null;
        try {
            if (this.address == null) {
                s = new java.net.Socket("localhost", this.port);
            } else {
                s = new java.net.Socket(this.address, this.port);
                s.setSoLinger(true, 0);
            }
            if (this.deferAccept) {
                s.getOutputStream().write(" ".getBytes());
            }
        }
        catch (Exception e) {
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                Socket.optSet(socket, 1, this.soLinger);
            }
            if (this.tcpNoDelay) {
                Socket.optSet(socket, 512, this.tcpNoDelay ? 1 : 0);
            }
            if (this.soTimeout > 0) {
                Socket.timeoutSet(socket, this.soTimeout * 1000);
            }
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach(this.sslContext, socket);
                if (SSLSocket.handshake(socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                if (this.curThreadsBusy == this.maxThreads) {
                    log.info((Object)sm.getString("endpoint.info.maxThreads", Integer.toString(this.maxThreads), this.address, Integer.toString(this.port)));
                }
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        while (workerThread == null) {
            try {
                WorkerStack workerStack = this.workers;
                synchronized (workerStack) {
                    this.workers.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workerThread = this.createWorkerThread();
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create(size, pool, 0, timeout > 0 ? (long)(timeout * 1000) : -1L);
        }
        catch (Error e) {
            if (Status.APR_STATUS_IS_EINVAL(e.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", "" + size));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long socket) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assignWithOptions(socket);
            } else {
                this.executor.execute(new SocketWithOptionsProcessor(socket));
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assign(socket);
            } else {
                this.executor.execute(new SocketProcessor(socket));
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket, SocketStatus status) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assign(socket, status);
            } else {
                this.executor.execute(new SocketEventProcessor(socket, status));
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected class SocketEventProcessor
    implements Runnable {
        protected long socket = 0L;
        protected SocketStatus status = null;

        public SocketEventProcessor(long socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        @Override
        public void run() {
            if (AprEndpoint.this.handler.event(this.socket, this.status) == Handler.SocketState.CLOSED) {
                Socket.destroy(this.socket);
            }
            this.socket = 0L;
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected long socket = 0L;

        public SocketProcessor(long socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            if (AprEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                Socket.destroy(this.socket);
            }
            this.socket = 0L;
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected long socket = 0L;

        public SocketWithOptionsProcessor(long socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            if (!AprEndpoint.this.deferAccept) {
                if (AprEndpoint.this.setSocketOptions(this.socket)) {
                    AprEndpoint.this.getPoller().add(this.socket);
                } else {
                    Socket.destroy(this.socket);
                }
            } else if (!AprEndpoint.this.setSocketOptions(this.socket) || AprEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                Socket.destroy(this.socket);
            }
            this.socket = 0L;
        }
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            this.workers[this.end++] = worker;
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }
    }

    public static interface Handler {
        public SocketState process(long var1);

        public SocketState event(long var1, SocketStatus var3);

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG;

        }
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected int sendfileCount;
        protected ArrayList<SendfileData> addS;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.sendfileSize;
            this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            if (this.sendfilePollset == 0L && size > 1024) {
                size = 1024;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            if (this.sendfilePollset == 0L) {
                size = 62;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                Sendfile sendfile = this;
                synchronized (sendfile) {
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = this.addS.get(i);
                Socket.destroy(data.socket);
            }
            int rv = Poll.pollset(this.sendfilePollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    Socket.destroy(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool(data.socket);
                    data.fd = File.open(data.fileName, 4129, 0, data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet(data.socket, 0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen(data.socket, data.fd, data.pos, data.end - data.pos, 0)) < 0L) {
                            if (-nw != 120002L) {
                                Socket.destroy(data.socket);
                                data.socket = 0L;
                                return false;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy(data.fdpool);
                    Socket.timeoutSet(data.socket, AprEndpoint.this.soTimeout * 1000);
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("endpoint.sendfile.error"), (Throwable)e);
                    return false;
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                this.notify();
            }
            return false;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove(this.sendfilePollset, data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(new Long(data.socket));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Sendfile e3;
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                while (this.sendfileCount < 1 && this.addS.size() < 1) {
                    maintainTime = 0L;
                    try {
                        e3 = this;
                        synchronized (e3) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e3) {
                    }
                }
                try {
                    int errn;
                    Object state;
                    int n;
                    if (this.addS.size() > 0) {
                        e3 = this;
                        synchronized (e3) {
                            for (int i = this.addS.size() - 1; i >= 0; --i) {
                                SendfileData data = this.addS.get(i);
                                int rv = Poll.add(this.sendfilePollset, data.socket, 4);
                                if (rv == 0) {
                                    this.sendfileData.put(new Long(data.socket), data);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                log.warn((Object)sm.getString("endpoint.sendfile.addfail", "" + rv, Error.strerror(rv)));
                                Socket.destroy(data.socket);
                            }
                            this.addS.clear();
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.sendfilePollset, AprEndpoint.this.pollTime, this.desc, false);
                    if (rv > 0) {
                        for (n = 0; n < rv; ++n) {
                            state = this.sendfileData.get(new Long(this.desc[n * 2 + 1]));
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove((SendfileData)state);
                                Socket.destroy(((SendfileData)state).socket);
                                continue;
                            }
                            long nw = Socket.sendfilen(((SendfileData)state).socket, ((SendfileData)state).fd, ((SendfileData)state).pos, ((SendfileData)state).end - ((SendfileData)state).pos, 0);
                            if (nw < 0L) {
                                this.remove((SendfileData)state);
                                Socket.destroy(((SendfileData)state).socket);
                                continue;
                            }
                            ((SendfileData)state).pos += nw;
                            if (((SendfileData)state).pos < ((SendfileData)state).end) continue;
                            this.remove((SendfileData)state);
                            if (((SendfileData)state).keepAlive) {
                                Pool.destroy(((SendfileData)state).fdpool);
                                Socket.timeoutSet(((SendfileData)state).socket, AprEndpoint.this.soTimeout * 1000);
                                AprEndpoint.this.getPoller().add(((SendfileData)state).socket);
                                continue;
                            }
                            Socket.destroy(((SendfileData)state).socket);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error((Object)sm.getString("endpoint.poll.fail", "" + errn, Error.strerror(errn)));
                        state = this;
                        synchronized (state) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.soTimeout <= 0 || maintainTime <= 1000000L || !AprEndpoint.this.running) continue;
                    rv = Poll.maintain(this.sendfilePollset, this.desc, false);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    for (n = 0; n < rv; ++n) {
                        state = this.sendfileData.get(new Long(this.desc[n]));
                        this.remove((SendfileData)state);
                        Socket.destroy(((SendfileData)state).socket);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.poll.error"), t);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public boolean keepAlive;
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected long socket = 0L;
        protected SocketStatus status = null;
        protected boolean options = false;

        protected Worker() {
        }

        protected synchronized void assignWithOptions(long socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.options = true;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(long socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.options = false;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(long socket, SocketStatus status) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.socket = socket;
            this.status = status;
            this.options = false;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized long await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            long socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        @Override
        public void run() {
            while (AprEndpoint.this.running) {
                long socket = this.await();
                if (socket == 0L) continue;
                if (!AprEndpoint.this.deferAccept && this.options) {
                    if (AprEndpoint.this.setSocketOptions(socket)) {
                        AprEndpoint.this.getPoller().add(socket);
                    } else if (AprEndpoint.this.serverSockPool != 0L) {
                        Socket.destroy(socket);
                    }
                } else if (this.status != null && AprEndpoint.this.handler.event(socket, this.status) == Handler.SocketState.CLOSED) {
                    if (AprEndpoint.this.serverSockPool != 0L) {
                        Socket.destroy(socket);
                    }
                } else if (this.status == null && (this.options && !AprEndpoint.this.setSocketOptions(socket) || AprEndpoint.this.handler.process(socket) == Handler.SocketState.CLOSED) && AprEndpoint.this.serverSockPool != 0L) {
                    Socket.destroy(socket);
                }
                AprEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(AprEndpoint.this.getName() + "-" + ++AprEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public class Poller
    implements Runnable {
        protected long[] pollers = null;
        protected int actualPollerSize = 0;
        protected int[] pollerSpace = null;
        protected int pollerCount;
        protected int pollerTime;
        protected long pool = 0L;
        protected long[] desc;
        protected SocketList addList = null;
        protected SocketList localAddList = null;
        protected boolean event = true;
        protected SocketTimeouts timeouts = null;
        protected long lastMaintain = System.currentTimeMillis();
        protected int connectionCount = 0;

        public int getConnectionCount() {
            return this.connectionCount;
        }

        public Poller(boolean event) {
            this.event = event;
        }

        protected void init() {
            int i;
            long pollset;
            this.timeouts = new SocketTimeouts(AprEndpoint.this.pollerSize);
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            this.actualPollerSize = AprEndpoint.this.pollerSize;
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.actualPollerSize > 1024) {
                this.actualPollerSize = 1024;
            }
            if ((pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1)) == 0L && this.actualPollerSize > 1024) {
                this.actualPollerSize = 1024;
                pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            if (pollset == 0L) {
                this.actualPollerSize = 62;
                pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            this.pollerCount = AprEndpoint.this.pollerSize / this.actualPollerSize;
            this.pollerTime = AprEndpoint.this.pollTime / this.pollerCount;
            this.pollers = new long[this.pollerCount];
            this.pollers[0] = pollset;
            for (i = 1; i < this.pollerCount; ++i) {
                this.pollers[i] = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            this.pollerSpace = new int[this.pollerCount];
            for (i = 0; i < this.pollerCount; ++i) {
                this.pollerSpace[i] = this.actualPollerSize;
            }
            this.desc = new long[this.actualPollerSize * 2];
            this.connectionCount = 0;
            this.addList = new SocketList(AprEndpoint.this.pollerSize);
            this.localAddList = new SocketList(AprEndpoint.this.pollerSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                Poller poller = this;
                synchronized (poller) {
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SocketInfo info = this.addList.get();
            while (info != null) {
                if (!this.event || this.event && !AprEndpoint.this.processSocket(info.socket, SocketStatus.STOP)) {
                    Socket.destroy(info.socket);
                }
                info = this.addList.get();
            }
            this.addList.clear();
            for (int i = 0; i < this.pollerCount; ++i) {
                int rv = Poll.pollset(this.pollers[i], this.desc);
                if (rv <= 0) continue;
                for (int n = 0; n < rv; ++n) {
                    if (this.event && (!this.event || AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.STOP))) continue;
                    Socket.destroy(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.connectionCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket) {
            int timeout = AprEndpoint.this.keepAliveTimeout;
            if (timeout < 0) {
                timeout = AprEndpoint.this.soTimeout;
            }
            if (timeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            boolean ok = false;
            Poller poller = this;
            synchronized (poller) {
                if (this.addList.add(socket, timeout, 1)) {
                    ok = true;
                    this.notify();
                }
            }
            if (!ok && (!this.event || this.event && !AprEndpoint.this.processSocket(socket, SocketStatus.ERROR))) {
                Socket.destroy(socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket, int timeout, boolean read, boolean write, boolean resume, boolean wakeup) {
            if (timeout < 0) {
                timeout = AprEndpoint.this.soTimeout;
            }
            if (timeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            boolean ok = false;
            Poller poller = this;
            synchronized (poller) {
                if (this.addList.add(socket, timeout, (read ? 1 : 0) | (write ? 2 : 0) | (resume ? 4 : 0) | (wakeup ? 8 : 0))) {
                    ok = true;
                    this.notify();
                }
            }
            if (!ok && (!this.event || this.event && !AprEndpoint.this.processSocket(socket, SocketStatus.ERROR))) {
                Socket.destroy(socket);
            }
        }

        protected boolean addToPoller(long socket, int events) {
            int rv = -1;
            for (int i = 0; i < this.pollers.length; ++i) {
                if (this.pollerSpace[i] <= 0 || (rv = Poll.add(this.pollers[i], socket, events)) != 0) continue;
                int n = i;
                this.pollerSpace[n] = this.pollerSpace[n] - 1;
                ++this.connectionCount;
                return true;
            }
            return false;
        }

        protected boolean removeFromPoller(long socket) {
            int rv = -1;
            for (int i = 0; i < this.pollers.length; ++i) {
                if (this.pollerSpace[i] >= this.actualPollerSize || (rv = Poll.remove(this.pollers[i], socket)) == 70015) continue;
                int n = i;
                this.pollerSpace[n] = this.pollerSpace[n] + 1;
                --this.connectionCount;
                break;
            }
            return rv == 0;
        }

        protected void maintain() {
            long date = System.currentTimeMillis();
            if (date - this.lastMaintain < 5000L) {
                return;
            }
            this.lastMaintain = date;
            long socket = this.timeouts.check(date);
            while (socket != 0L) {
                this.removeFromPoller(socket);
                if (!this.event || this.event && !AprEndpoint.this.processSocket(socket, SocketStatus.TIMEOUT)) {
                    Socket.destroy(socket);
                }
                socket = this.timeouts.check(date);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Poller event=[").append(this.event).append("]");
            long[] res = new long[this.actualPollerSize * 2];
            for (int i = 0; i < this.pollers.length; ++i) {
                int count = Poll.pollset(this.pollers[i], res);
                buf.append(" [ ");
                for (int j = 0; j < count; ++j) {
                    buf.append(this.desc[2 * j + 1]).append(" ");
                }
                buf.append("]");
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int maintain = 0;
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (this.connectionCount < 1 && this.addList.size() < 1) {
                    try {
                        if (AprEndpoint.this.soTimeout > 0 && AprEndpoint.this.running) {
                            this.maintain();
                        }
                        Poller e = this;
                        synchronized (e) {
                            this.wait(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        log.error((Object)sm.getString("endpoint.maintain.error"), t);
                    }
                }
                try {
                    if (this.addList.size() > 0) {
                        Poller t = this;
                        synchronized (t) {
                            this.addList.duplicate(this.localAddList);
                            this.addList.clear();
                        }
                        SocketInfo info = this.localAddList.get();
                        while (info != null) {
                            int events;
                            if (info.wakeup()) {
                                if (this.timeouts.remove(info.socket)) {
                                    this.removeFromPoller(info.socket);
                                    if (info.resume()) {
                                        if (!AprEndpoint.this.processSocket(info.socket, SocketStatus.OPEN_CALLBACK)) {
                                            Socket.destroy(info.socket);
                                        }
                                    } else {
                                        events = (info.read() ? 1 : 0) | (info.write() ? 4 : 0);
                                        if (!this.addToPoller(info.socket, events)) {
                                            if (!this.event || this.event && !AprEndpoint.this.processSocket(info.socket, SocketStatus.ERROR)) {
                                                Socket.destroy(info.socket);
                                            }
                                        } else {
                                            this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                                        }
                                    }
                                }
                            } else if (info.read() || info.write()) {
                                if (info.resume()) {
                                    this.timeouts.remove(info.socket);
                                    this.removeFromPoller(info.socket);
                                    if (!AprEndpoint.this.processSocket(info.socket, SocketStatus.OPEN_CALLBACK)) {
                                        Socket.destroy(info.socket);
                                    }
                                } else {
                                    if (this.event) {
                                        this.removeFromPoller(info.socket);
                                    }
                                    if (!this.addToPoller(info.socket, events = (info.read() ? 1 : 0) | (info.write() ? 4 : 0))) {
                                        if (!this.event || this.event && !AprEndpoint.this.processSocket(info.socket, SocketStatus.ERROR)) {
                                            Socket.destroy(info.socket);
                                        }
                                    } else {
                                        this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                                    }
                                }
                            } else if (this.event) {
                                if (info.resume()) {
                                    this.timeouts.remove(info.socket);
                                    this.removeFromPoller(info.socket);
                                    if (!AprEndpoint.this.processSocket(info.socket, SocketStatus.OPEN_CALLBACK)) {
                                        Socket.destroy(info.socket);
                                    }
                                } else {
                                    this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                                }
                            } else {
                                this.timeouts.remove(info.socket);
                                Socket.destroy(info.socket);
                                log.error((Object)sm.getString("endpoint.poll.error"));
                            }
                            info = this.localAddList.get();
                        }
                    }
                    for (int i = 0; i < this.pollers.length; ++i) {
                        int errn;
                        boolean reset = false;
                        int rv = 0;
                        if (this.pollerSpace[i] < this.actualPollerSize) {
                            rv = Poll.poll(this.pollers[i], this.pollerTime, this.desc, true);
                        }
                        if (rv > 0) {
                            int n = i;
                            this.pollerSpace[n] = this.pollerSpace[n] + rv;
                            this.connectionCount -= rv;
                            for (int n2 = 0; n2 < rv; ++n2) {
                                this.timeouts.remove(this.desc[n2 * 2 + 1]);
                                if (this.event) {
                                    if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L || (this.desc[n2 * 2] & 0x40L) == 64L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.ERROR)) continue;
                                        Socket.destroy(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    if ((this.desc[n2 * 2] & 1L) == 1L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                        Socket.destroy(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    if ((this.desc[n2 * 2] & 4L) == 4L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                        Socket.destroy(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    log.warn((Object)sm.getString("endpoint.poll.flags", "" + this.desc[n2 * 2]));
                                    if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.ERROR)) continue;
                                    Socket.destroy(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L || (this.desc[n2 * 2] & 0x40L) == 64L) {
                                    Socket.destroy(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n2 * 2] & 1L) == 1L) {
                                    if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1])) continue;
                                    Socket.destroy(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                log.warn((Object)sm.getString("endpoint.poll.flags", "" + this.desc[n2 * 2]));
                                Socket.destroy(this.desc[n2 * 2 + 1]);
                            }
                        } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                            if (errn > 120000) {
                                errn -= 120000;
                            }
                            log.error((Object)sm.getString("endpoint.poll.fail", "" + errn, Error.strerror(errn)));
                            reset = true;
                        }
                        if (!reset) continue;
                        int count = Poll.pollset(this.pollers[i], this.desc);
                        long newPoller = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
                        this.pollerSpace[i] = this.actualPollerSize;
                        this.connectionCount -= count;
                        Poll.destroy(this.pollers[i]);
                        this.pollers[i] = newPoller;
                    }
                    if (AprEndpoint.this.soTimeout <= 0 || maintain++ <= 1000 || !AprEndpoint.this.running) continue;
                    maintain = 0;
                    this.maintain();
                }
                catch (Throwable t) {
                    if (maintain == 0) {
                        log.error((Object)sm.getString("endpoint.maintain.error"), t);
                        continue;
                    }
                    log.error((Object)sm.getString("endpoint.poll.error"), t);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }
    }

    public class SocketList {
        protected int size = 0;
        protected int pos = 0;
        protected long[] sockets;
        protected int[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int size) {
            this.sockets = new long[size];
            this.timeouts = new int[size];
            this.flags = new int[size];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(long socket, int timeout, int flag) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.flags[i] = SocketInfo.merge(this.flags[i], flag);
                return true;
            }
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            this.flags[this.size] = flag;
            ++this.size;
            return true;
        }

        public void duplicate(SocketList copy) {
            copy.size = this.size;
            copy.pos = this.pos;
            System.arraycopy(this.sockets, 0, copy.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, copy.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, copy.flags, 0, this.size);
        }
    }

    public class SocketTimeouts {
        protected int size = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int size) {
            this.sockets = new long[size];
            this.timeouts = new long[size];
        }

        public void add(long socket, long timeout) {
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            ++this.size;
        }

        public boolean remove(long socket) {
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public long check(long date) {
            while (this.pos < this.size) {
                if (date >= this.timeouts[this.pos]) {
                    long result = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return result;
                }
                ++this.pos;
            }
            this.pos = 0;
            return 0L;
        }
    }

    public static class SocketInfo {
        public static final int READ = 1;
        public static final int WRITE = 2;
        public static final int RESUME = 4;
        public static final int WAKEUP = 8;
        public long socket;
        public int timeout;
        public int flags;

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public boolean write() {
            return (this.flags & 2) == 2;
        }

        public boolean resume() {
            return (this.flags & 4) == 4;
        }

        public boolean wakeup() {
            return (this.flags & 8) == 8;
        }

        public static int merge(int flag1, int flag2) {
            return flag1 & 1 | flag2 & 1 | (flag1 & 2 | flag2 & 2) | (flag1 & 4 | flag2 & 4) | flag1 & 8 & (flag2 & 8);
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (AprEndpoint.this.reverseConnection) {
                    if (AprEndpoint.this.poller.getConnectionCount() < AprEndpoint.this.maxThreads / 5) {
                        boolean go = true;
                        while (go) {
                            go = false;
                            for (int i = 0; i < AprEndpoint.this.listsock.length - 1; ++i) {
                                if (AprEndpoint.this.listsock[i + 1].count >= AprEndpoint.this.listsock[i].count) continue;
                                go = false;
                                ListSock current = AprEndpoint.this.listsock[i + 1];
                                AprEndpoint.this.listsock[i + 1] = AprEndpoint.this.listsock[i];
                                AprEndpoint.this.listsock[i] = current;
                            }
                        }
                        int nsock = AprEndpoint.this.maxThreads / 5;
                        if (nsock > AprEndpoint.this.listsock.length) {
                            nsock = AprEndpoint.this.listsock.length;
                        }
                        String addressStr = AprEndpoint.this.address.getHostAddress();
                        for (int i = 0; i < nsock; ++i) {
                            try {
                                long socket = Socket.create(AprEndpoint.this.serverAddressFamily, 0, 6, AprEndpoint.this.rootPool);
                                long inetAddress = Address.info(addressStr, AprEndpoint.this.serverAddressFamily, AprEndpoint.this.listsock[i].port, 0, AprEndpoint.this.rootPool);
                                if (Socket.connect(socket, inetAddress) != 0) {
                                    Socket.destroy(socket);
                                    continue;
                                }
                                if (!AprEndpoint.this.processSocketWithOptions(socket)) {
                                    Socket.destroy(socket);
                                } else {
                                    ++AprEndpoint.this.listsock[i].count;
                                }
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            catch (Throwable t) {
                                log.error((Object)sm.getString("endpoint.accept.fail"), t);
                            }
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    long socket = Socket.accept(AprEndpoint.this.serverSock);
                    if (AprEndpoint.this.processSocketWithOptions(socket)) continue;
                    Socket.destroy(socket);
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }

    class ListSock {
        int count;
        int port;

        ListSock() {
        }
    }
}

