/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.catalina.Context;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;

public class StandardWrapperFacade
implements ServletRegistration,
ServletConfig {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private StandardWrapper wrapper = null;
    private ServletContext context = null;

    public StandardWrapperFacade(StandardWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public String getServletName() {
        return this.wrapper.getServletName();
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = this.wrapper.getServletContext();
            if (this.context != null && this.context instanceof ApplicationContext) {
                this.context = ((ApplicationContext)this.context).getFacade();
            }
        }
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.wrapper.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.wrapper.getInitParameterNames();
    }

    public Set<String> addMapping(String ... urlPatterns) {
        HashSet<String> conflicts = new HashSet<String>();
        if (((Context)this.wrapper.getParent()).isInitialized()) {
            throw new IllegalStateException(sm.getString("servletRegistration.addServletMapping.ise", ((Context)this.wrapper.getParent()).getPath()));
        }
        if (urlPatterns != null) {
            for (int i = 0; i < urlPatterns.length; ++i) {
                if (((Context)this.wrapper.getParent()).findServletMapping(urlPatterns[i]) != null) {
                    conflicts.add(urlPatterns[i]);
                    continue;
                }
                ((Context)this.wrapper.getParent()).addServletMapping(urlPatterns[i], this.wrapper.getName());
            }
        }
        return conflicts;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.wrapper.setAsyncSupported(asyncSupported);
    }

    public void setDescription(String description) {
        this.wrapper.setDescription(description);
    }

    public boolean setInitParameter(String name, String value) {
        this.wrapper.addInitParameter(name, value);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> conflicts = new HashSet<String>();
        for (String parameterName : initParameters.keySet()) {
            if (this.wrapper.findInitParameter(parameterName) != null) {
                conflicts.add(parameterName);
                continue;
            }
            this.wrapper.addInitParameter(parameterName, initParameters.get(parameterName));
        }
        return conflicts;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    public Collection<String> getMappings() {
        HashSet<String> result = new HashSet<String>();
        String[] mappings = this.wrapper.findMappings();
        for (int i = 0; i < mappings.length; ++i) {
            result.add(mappings[i]);
        }
        return Collections.unmodifiableSet(result);
    }

    public String getClassName() {
        return this.wrapper.getServletClass();
    }

    public Map<String, String> getInitParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] names = this.wrapper.findInitParameters();
        for (int i = 0; i < names.length; ++i) {
            result.put(names[i], this.wrapper.getInitParameter(names[i]));
        }
        return Collections.unmodifiableMap(result);
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public static class Dynamic
    extends StandardWrapperFacade
    implements ServletRegistration.Dynamic {
        public Dynamic(StandardWrapper wrapper) {
            super(wrapper);
        }
    }
}

