/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public final class StandardServer
implements Lifecycle,
Server,
MBeanRegistration {
    private static Logger log = Logger.getLogger(StandardServer.class);
    private javax.naming.Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private String address = "localhost";
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean stopAwait = false;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public StandardServer() {
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    log.error((Object)e);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
    }

    @Override
    public void await() {
        if (this.port == -2) {
            return;
        }
        if (this.port == -1) {
            do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            } while (!this.stopAwait);
            return;
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName(this.address));
        }
        catch (IOException e) {
            log.error((Object)("StandardServer.await: create[" + this.address + ":" + this.port + "]: "), (Throwable)e);
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                log.warn((Object)("StandardServer.accept security exception: " + ace.getMessage()), (Throwable)ace);
                continue;
            }
            catch (IOException e) {
                log.error((Object)"StandardServer.await: accept: ", (Throwable)e);
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt() % 1024) {
                if (this.random != null) continue;
                this.random = new Random();
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    log.warn((Object)"StandardServer.await: read: ", (Throwable)e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            log.warn((Object)("StandardServer.await: Invalid command '" + command.toString() + "' received"));
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.services[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void storeConfig() throws Exception {
        ObjectName sname = null;
        try {
            sname = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "storeConfig", null, null);
            } else {
                log.error((Object)("StoreConfig mbean not registered" + sname));
            }
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    public synchronized void storeContext(Context context) throws Exception {
        ObjectName sname = null;
        try {
            sname = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error((Object)("StoreConfig mbean not registered" + sname));
            }
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            log.debug((Object)sm.getString("standardServer.start.started"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!(this.services[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.services[i])).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.lifecycle.fireLifecycleEvent("after_start", null);
            return;
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (!(this.services[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.services[i])).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        if (this.port == -1) {
            this.stopAwait();
        }
    }

    public void init() throws Exception {
        this.initialize();
    }

    @Override
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.info((Object)sm.getString("standardServer.initialize.initialized"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("init", null);
        this.initialized = true;
        if (this.oname == null) {
            try {
                this.oname = new ObjectName("Catalina:type=Server");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        try {
            ObjectName oname2 = new ObjectName(this.oname.getDomain() + ":type=StringCache");
            Registry.getRegistry(null, null).registerComponent((Object)new StringCache(), oname2, null);
        }
        catch (Exception e) {
            log.error((Object)"Error registering ", (Throwable)e);
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].initialize();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

