/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEFactory;
import org.jboss.logging.Logger;

public class JSSEImplementation
extends SSLImplementation {
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    static Logger logger = Logger.getLogger(JSSEImplementation.class);
    private JSSEFactory factory = null;

    public JSSEImplementation() throws ClassNotFoundException {
        Class.forName(SSLSocketClass);
        this.factory = new JSSEFactory();
    }

    @Override
    public String getImplementationName() {
        return "JSSE";
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        ServerSocketFactory ssf = this.factory.getSocketFactory();
        return ssf;
    }

    @Override
    public SSLSupport getSSLSupport(Socket s) {
        SSLSupport ssls = this.factory.getSSLSupport(s);
        return ssls;
    }

    @Override
    public SSLSupport getSSLSupport(SSLSession session) {
        SSLSupport ssls = this.factory.getSSLSupport(session);
        return ssls;
    }
}

