/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.MbeansSource;
import org.jboss.logging.Logger;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static Logger log = Logger.getLogger(StandardEngine.class);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String mbeansFile = null;
    private List mbeans;
    private String jvmRouteId;
    private boolean initialized = false;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase();
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    @Override
    public void setName(String name) {
        if (this.domain != null) {
            super.setName(this.domain);
            return;
        }
        this.domain = name;
        super.setName(name);
    }

    @Override
    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getMbeansFile() {
        return this.mbeansFile;
    }

    public void setMbeansFile(String mbeansFile) {
        this.mbeansFile = mbeansFile;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    @Override
    public void init() {
        String defaultMBeansFile;
        File f;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                if (this.domain == null) {
                    this.domain = this.getName();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register " + this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Engine");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.info((Object)"Error registering ", t);
            }
        }
        if (this.mbeansFile == null && (f = new File(defaultMBeansFile = this.getBaseDir() + "/conf/tomcat5-mbeans.xml")).exists()) {
            this.mbeansFile = f.getAbsolutePath();
        }
        if (this.mbeansFile != null) {
            this.readEngineMbeans();
        }
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "init", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in init() for " + this.mbeansFile), (Throwable)e);
            }
        }
        if (this.service == null) {
            try {
                this.service = new StandardService();
                this.service.setContainer(this);
                this.service.initialize();
            }
            catch (Throwable t) {
                log.error((Object)t);
            }
        }
    }

    @Override
    public void destroy() throws LifecycleException {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        ((StandardService)this.service).destroy();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "destroy", false);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardEngine.unregister.mbeans.failed", this.mbeansFile), (Throwable)e);
            }
        }
        if (this.mbeans != null) {
            try {
                for (int i = 0; i < this.mbeans.size(); ++i) {
                    Registry.getRegistry(null, null).unregisterComponent((ObjectName)this.mbeans.get(i));
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardEngine.unregister.mbeans.failed", this.mbeansFile), (Throwable)e);
            }
        }
        Registry.getRegistry(null, null).resetMetadata();
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm");
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("No realm for this engine " + realmName));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Servlet Engine: " + ServerInfo.getServerInfo()));
        }
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "start", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in start() for " + this.mbeansFile), (Throwable)e);
            }
        }
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "stop", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in stop() for " + this.mbeansFile), (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        this.setName(name.getDomain());
        return name;
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        if (this.getService() == null) {
            return null;
        }
        String name = this.getService().getName();
        ObjectName serviceName = new ObjectName(this.domain + ":type=Service,serviceName=" + name);
        return serviceName;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create ObjectName " + domain + " " + parent));
        }
        return new ObjectName(domain + ":type=Engine");
    }

    private void readEngineMbeans() {
        try {
            MbeansSource mbeansMB = new MbeansSource();
            File mbeansF = new File(this.mbeansFile);
            mbeansMB.setSource(mbeansF);
            Registry.getRegistry(null, null).registerComponent((Object)mbeansMB, this.domain + ":type=MbeansFile", null);
            mbeansMB.load();
            mbeansMB.init();
            mbeansMB.setRegistry(Registry.getRegistry(null, null));
            this.mbeans = mbeansMB.getMBeans();
        }
        catch (Throwable t) {
            log.error((Object)("Error loading " + this.mbeansFile), t);
        }
    }

    @Override
    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        return this.getName();
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }
}

