/*
 * Decompiled with CFR 0.152.
 */
package je.dvs.echo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Sorts;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import je.dvs.echo.Config.MongoConfiguration;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class registerUpdate {
    @Autowired
    MongoConfiguration configuration;
    final String PARENTIDNAME = "_parentid";
    final String ID = "_id";
    final String DOCUMENT_UUID = "docUUID";
    final String TIMESTAMP = "timestamp";

    public void environment(String database, String user, String password, Integer port) throws Exception {
        this.configuration.setDatabase(database);
        this.configuration.setUser(user);
        this.configuration.setPassword(password);
        this.configuration.setPort(port);
        this.configuration.connect();
    }

    public void setConfiguration(MongoConfiguration configuration) {
        this.configuration = configuration;
    }

    public Document updateRegister(String jsonString, String id, String collectionName) throws Exception {
        assert (id != null && id != "") : "Document ID is missing.";
        Document doc = Document.parse((String)jsonString);
        boolean isValidValueUpdate = false;
        for (Map.Entry entry : doc.entrySet()) {
            Object value = entry.getValue();
            if (value == null || value.toString().equalsIgnoreCase("null")) continue;
            isValidValueUpdate = true;
            break;
        }
        assert (isValidValueUpdate) : "There are no values to update!";
        MongoCollection collection = this.configuration.getDatabase().getCollection(collectionName);
        BasicDBObject whereQuery = new BasicDBObject();
        whereQuery.put((Object)"docUUID", (Object)UUID.fromString(id));
        whereQuery.put((Object)"_parentid", null);
        List documents = (List)collection.find((Bson)whereQuery).into(new ArrayList());
        if (documents.isEmpty()) {
            this.addDocument(collection, "docUUID", doc, id);
        } else {
            assert (documents.size() == 1) : "Multiple documents have been found with id " + id;
            Document parent = (Document)documents.get(0);
            this.addToRegister(collection, this.updateRegisterDocument(collection, "docUUID", doc, parent));
        }
        return doc;
    }

    public Document addDocument(MongoCollection collection, String UUIDName, Document newdoc, String uuid) {
        ZonedDateTime dt = ZonedDateTime.now(ZoneOffset.UTC);
        newdoc.put(UUIDName, (Object)UUID.fromString(uuid));
        newdoc.put("timestamp", (Object)dt.toInstant().toEpochMilli());
        assert (this.addToRegister(collection, newdoc)) : "Unable to add to the register. Collection or document are null";
        return newdoc;
    }

    public boolean isObjectEmpty(JSONObject obj) {
        Set s = obj.keySet();
        Iterator i = s.iterator();
        do {
            String k;
            if (obj.get((Object)(k = i.next().toString())) == null) continue;
            return false;
        } while (i.hasNext());
        return true;
    }

    public Document updateRegisterDocument(MongoCollection collection, String UUIDName, Document update, Document parentdoc) {
        ObjectId parentid = (ObjectId)parentdoc.get((Object)"_id");
        BasicDBObject whereQuery = new BasicDBObject();
        whereQuery.put((Object)"_parentid", (Object)parentid);
        List documents = (List)collection.find((Bson)whereQuery).sort(Sorts.descending((String[])new String[]{"timestamp"})).into(new ArrayList());
        ZonedDateTime dt = ZonedDateTime.now(ZoneOffset.UTC);
        Document newdoc = null;
        if (documents.size() == 0) {
            newdoc = this.createDifferenceDoc(parentdoc, update, true);
        } else {
            Document lastChild = (Document)documents.get(0);
            lastChild.remove((Object)"_id");
            newdoc = this.createDifferenceDoc(lastChild, update, false);
        }
        newdoc.put("docUUID", parentdoc.get((Object)UUIDName));
        newdoc.put("timestamp", (Object)dt.toInstant().toEpochMilli());
        newdoc.put("_parentid", (Object)parentid);
        return newdoc;
    }

    private Document createDifferenceDoc(Document merge, Document updatedoc, boolean differenceOnly) {
        String s = merge.toJson().toString();
        Document newdoc = differenceOnly ? new Document() : Document.parse((String)merge.toJson());
        for (Map.Entry entry : updatedoc.entrySet()) {
            Object key = entry.getKey();
            Object value = updatedoc.get(key);
            if (value == null || value.toString().equalsIgnoreCase("null") || merge.get(key) == value) continue;
            if (merge.containsKey(key)) {
                newdoc.put((String)key, updatedoc.get(key));
                continue;
            }
            newdoc.append((String)key, updatedoc.get(key));
        }
        return newdoc;
    }

    public boolean addToRegister(MongoCollection collection, Document doc) {
        if (collection == null || doc == null) {
            return false;
        }
        collection.insertOne((Object)doc);
        return true;
    }
}

