/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class TransactionEnlistingInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final TransactionContextManager transactionContextManager;

    public TransactionEnlistingInterceptor(ConnectionInterceptor next, TransactionContextManager transactionContextManager) {
        this.next = next;
        this.transactionContextManager = transactionContextManager;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            TransactionContext transactionContext = this.transactionContextManager.getContext();
            if (transactionContext != null && transactionContext.isInheritable() && transactionContext.isActive()) {
                XAResource xares = mci.getXAResource();
                transactionContext.enlistResource(xares);
            }
        }
        catch (SystemException e) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Could not get transaction", e);
        }
        catch (RollbackException e) {
            this.next.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
            throw new ResourceException("Could not enlist resource in rolled back transaction", e);
        }
        catch (Throwable t) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Unknown throwable when trying to enlist connection in tx", t);
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            TransactionContext transactionContext = this.transactionContextManager.getContext();
            if (transactionContext != null && transactionContext.isInheritable() && transactionContext.isActive()) {
                XAResource xares = mci.getXAResource();
                transactionContext.delistResource(xares, 0x2000000);
            }
        }
        catch (SystemException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        catch (IllegalStateException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }
}

