/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.security;

import java.util.HashMap;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.geronimo.connector.outbound.security.ManagedConnectionFactoryListener;
import org.apache.geronimo.connector.outbound.security.PasswordCredentialLoginModule;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.JaasLoginCoordinator;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.realm.SecurityRealm;

public class PasswordCredentialRealm
implements SecurityRealm,
ConfigurationEntryFactory,
ManagedConnectionFactoryListener {
    ManagedConnectionFactory managedConnectionFactory;
    private final Kernel kernel;
    private final String realmName;
    static final String REALM_INSTANCE = "org.apache.connector.outbound.security.PasswordCredentialRealm";

    public PasswordCredentialRealm(Kernel kernel, String realmName) {
        this.kernel = kernel;
        this.realmName = realmName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public boolean isRestrictPrincipalsToServer() {
        return true;
    }

    public String[] getLoginDomains() {
        return new String[]{this.realmName};
    }

    public JaasLoginModuleConfiguration[] getAppConfigurationEntries() {
        HashMap<String, PasswordCredentialRealm> options = new HashMap<String, PasswordCredentialRealm>();
        options.put(REALM_INSTANCE, this);
        JaasLoginModuleConfiguration config = new JaasLoginModuleConfiguration(PasswordCredentialLoginModule.class.getName(), LoginModuleControlFlag.REQUISITE, options, true, this.getRealmName());
        return new JaasLoginModuleConfiguration[]{config};
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = managedConnectionFactory;
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public String getConfigurationName() {
        return this.realmName;
    }

    public JaasLoginModuleConfiguration generateConfiguration() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("realm", this.realmName);
        options.put("kernel", this.kernel.getKernelName());
        return new JaasLoginModuleConfiguration(JaasLoginCoordinator.class.getName(), LoginModuleControlFlag.REQUIRED, options, true, this.realmName);
    }
}

