/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GOperationSignature;

public class DynamicGBeanDelegate
implements DynamicGBean {
    protected final Map getters = new HashMap();
    protected final Map setters = new HashMap();
    protected final Map operations = new HashMap();
    private Class targetClass;
    static /* synthetic */ Class class$org$apache$geronimo$gbean$DynamicGBeanDelegate;

    public void addAll(Object target) {
        this.targetClass = target.getClass();
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (this.isGetter(method)) {
                this.addGetter(target, method);
                continue;
            }
            if (this.isSetter(method)) {
                this.addSetter(target, method);
                continue;
            }
            this.addOperation(target, method);
        }
    }

    public void addGetter(Object target, Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            this.addGetter(name.substring(3), target, method);
        } else if (name.startsWith("is")) {
            this.addGetter(name.substring(2), target, method);
        } else {
            throw new IllegalArgumentException("Method name must start with 'get' or 'is' " + method);
        }
    }

    public void addGetter(String name, Object target, Method method) {
        if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Method must take no parameters and return a value " + method);
        }
        this.getters.put(name, new Operation(target, method));
        this.getters.put(Introspector.decapitalize(name), new Operation(target, method));
    }

    public void addSetter(Object target, Method method) {
        if (!method.getName().startsWith("set")) {
            throw new IllegalArgumentException("Method name must start with 'set' " + method);
        }
        this.addSetter(method.getName().substring(3), target, method);
    }

    public void addSetter(String name, Object target, Method method) {
        if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Method must take one parameter and not return anything " + method);
        }
        this.setters.put(name, new Operation(target, method));
        this.setters.put(Introspector.decapitalize(name), new Operation(target, method));
    }

    public void addOperation(Object target, Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        String[] types = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getName();
        }
        GOperationSignature key = new GOperationSignature(method.getName(), types);
        this.operations.put(key, new Operation(target, method));
    }

    private boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    public Object getAttribute(String name) throws Exception {
        Operation operation = (Operation)this.getters.get(name);
        if (operation == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no getter for " + name);
        }
        return operation.invoke(null);
    }

    public void setAttribute(String name, Object value) throws Exception {
        Operation operation = (Operation)this.setters.get(name);
        if (operation == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no setter for " + name);
        }
        operation.invoke(new Object[]{value});
    }

    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        GOperationSignature signature = new GOperationSignature(name, types);
        Operation operation = (Operation)this.operations.get(signature);
        if (operation == null) {
            throw new IllegalArgumentException(this.targetClass.getName() + ": no operation " + signature);
        }
        return operation.invoke(arguments);
    }

    protected static class Operation {
        private final Object target;
        private final FastMethod method;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Operation(Object target, Method method) {
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && method == null) {
                throw new AssertionError();
            }
            this.target = target;
            this.method = FastClass.create(target.getClass()).getMethod(method);
        }

        public Object invoke(Object[] arguments) throws Exception {
            try {
                return this.method.invoke(this.target, arguments);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                throw e;
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$gbean$DynamicGBeanDelegate == null ? (class$org$apache$geronimo$gbean$DynamicGBeanDelegate = DynamicGBeanDelegate.class$("org.apache.geronimo.gbean.DynamicGBeanDelegate")) : class$org$apache$geronimo$gbean$DynamicGBeanDelegate).desiredAssertionStatus();
        }
    }
}

