/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class GBeanName
implements Serializable {
    private static final long serialVersionUID = 8571821054715922993L;
    private final String name;
    private final transient String domain;
    private final transient HashMap props;
    private final transient int hashCode;

    public GBeanName(String domain, Map props) {
        if (domain == null) {
            throw new IllegalArgumentException("domain is null");
        }
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (props.isEmpty()) {
            throw new IllegalArgumentException("props is empty");
        }
        this.domain = domain;
        this.props = new HashMap(props);
        this.name = GBeanName.buildName(domain, props);
        this.hashCode = domain.hashCode() + 37 * ((Object)props).hashCode();
    }

    private static String buildName(String domain, Map props) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(domain).append(':');
        Iterator i = props.entrySet().iterator();
        Map.Entry entry = i.next();
        buf.append(entry.getKey()).append('=').append(entry.getValue());
        while (i.hasNext()) {
            entry = i.next();
            buf.append(',').append(entry.getKey()).append('=').append(entry.getValue());
        }
        return buf.toString();
    }

    public GBeanName(String name) {
        int idx = name.indexOf(58);
        if (idx == -1) {
            throw new IllegalArgumentException("Missing ':' for domain: " + name);
        }
        this.name = name;
        this.domain = name.substring(0, idx);
        this.props = GBeanName.parseName(name.substring(idx + 1));
        this.hashCode = this.domain.hashCode() + 37 * this.props.hashCode();
    }

    private static HashMap parseName(String name) {
        if (name.endsWith(",")) {
            throw new IllegalArgumentException("Missing last property pair");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        String[] pairs = name.split(",");
        for (int i = 0; i < pairs.length; ++i) {
            String value;
            String pair = pairs[i];
            int idx = pair.indexOf(61);
            if (idx == -1) {
                throw new IllegalArgumentException("Invalid property pair: " + pair);
            }
            String key = pair.substring(0, idx);
            if (props.put(key, value = pair.substring(idx + 1)) == null) continue;
            throw new IllegalArgumentException("Duplicate property: " + key);
        }
        return props;
    }

    public boolean matches(String domain, Map pattern) {
        if (domain != null && !this.domain.equals(domain)) {
            return false;
        }
        if (pattern != null && !pattern.isEmpty()) {
            Iterator i = pattern.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String ourValue = (String)this.props.get(key);
                if (ourValue != null && ourValue.equals(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GBeanName)) {
            return false;
        }
        GBeanName other = (GBeanName)obj;
        return this.domain.equals(other.domain) && this.props.equals(other.props);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    public String toString(Comparator keySorter) {
        String[] keyList = this.props.keySet().toArray(new String[this.props.keySet().size()]);
        Arrays.sort(keyList, keySorter);
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.domain).append(':');
        String key = keyList[0];
        buf.append(key).append('=').append(this.props.get(key));
        for (int i = 1; i < keyList.length; ++i) {
            key = keyList[i];
            buf.append(',').append(key).append('=').append(this.props.get(key));
        }
        return buf.toString();
    }

    private Object readResolve() {
        return new GBeanName(this.name);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(this.domain, new Hashtable<String, String>(this.props));
    }

    public GBeanName(ObjectName name) {
        this.name = name.toString();
        this.domain = name.getDomain();
        this.props = new HashMap<String, String>(name.getKeyPropertyList());
        this.hashCode = this.domain.hashCode() + 37 * this.props.hashCode();
    }
}

