/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;

public class GBeanAttribute {
    private final GBeanInstance gbeanInstance;
    private final String name;
    private final Class type;
    private final boolean readable;
    private final MethodInvoker getInvoker;
    private final boolean writable;
    private final MethodInvoker setInvoker;
    private final boolean isConstructorArg;
    private final boolean persistent;
    private Object persistentValue;
    private final boolean special;
    private final boolean framework;
    private final boolean dynamic;
    private final GAttributeInfo attributeInfo;
    static final /* synthetic */ boolean $assertionsDisabled;

    static GBeanAttribute createSpecialAttribute(GBeanAttribute attribute, GBeanInstance gbeanInstance, String name, Class type, Object value) {
        return new GBeanAttribute(attribute, gbeanInstance, name, type, value);
    }

    private GBeanAttribute(GBeanAttribute attribute, GBeanInstance gbeanInstance, String name, Class type, Object value) {
        this.special = true;
        this.framework = false;
        this.dynamic = false;
        if (gbeanInstance == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (attribute != null) {
            if (!$assertionsDisabled && gbeanInstance != attribute.gbeanInstance) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !name.equals(attribute.name)) {
                throw new AssertionError();
            }
            if (type != attribute.type) {
                throw new InvalidConfigurationException("Special attribute " + name + " must have the type " + type.getName() + ", but is " + attribute.type.getName() + ": targetClass=" + gbeanInstance.getType().getName());
            }
            if (attribute.isPersistent()) {
                throw new InvalidConfigurationException("Special attributes must not be persistent: name=" + name + ", targetClass=" + gbeanInstance.getType().getName());
            }
        }
        this.gbeanInstance = gbeanInstance;
        this.name = name;
        this.type = type;
        this.getInvoker = null;
        this.readable = true;
        if (attribute != null) {
            this.setInvoker = attribute.setInvoker;
            this.isConstructorArg = attribute.isConstructorArg;
        } else {
            this.setInvoker = null;
            this.isConstructorArg = false;
        }
        this.writable = false;
        this.persistent = false;
        this.initializePersistentValue(value);
        if (attribute != null) {
            GAttributeInfo attributeInfo = attribute.getAttributeInfo();
            this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.readable, this.writable, attributeInfo.getGetterName(), attributeInfo.getSetterName());
        } else {
            this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.readable, this.writable, null, null);
        }
    }

    static GBeanAttribute createFrameworkAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker) {
        return new GBeanAttribute(gbeanInstance, name, type, getInvoker, null, false, null);
    }

    static GBeanAttribute createFrameworkAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker, boolean persistent, Object persistentValue) {
        return new GBeanAttribute(gbeanInstance, name, type, getInvoker, setInvoker, persistent, persistentValue);
    }

    private GBeanAttribute(GBeanInstance gbeanInstance, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker, boolean persistent, Object persistentValue) {
        this.special = false;
        this.framework = true;
        this.dynamic = false;
        if (gbeanInstance == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        this.gbeanInstance = gbeanInstance;
        this.name = name;
        this.type = type;
        this.getInvoker = getInvoker;
        this.readable = this.getInvoker != null;
        this.setInvoker = setInvoker;
        this.isConstructorArg = false;
        this.writable = this.setInvoker != null;
        this.persistent = persistent;
        this.initializePersistentValue(persistentValue);
        this.attributeInfo = new GAttributeInfo(this.name, this.type.getName(), this.persistent, this.readable, this.writable, null, null);
    }

    public GBeanAttribute(GBeanInstance gbeanInstance, GAttributeInfo attributeInfo, boolean isConstructorArg) throws InvalidConfigurationException {
        this.special = false;
        this.framework = false;
        if (gbeanInstance == null || attributeInfo == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (!(attributeInfo.isReadable() || attributeInfo.isWritable() || attributeInfo.isPersistent() || isConstructorArg)) {
            throw new InvalidConfigurationException("An attribute must be readable, writable, persistent or a constructor arg:  name=" + attributeInfo.getName() + " targetClass=" + gbeanInstance.getType().getName());
        }
        this.gbeanInstance = gbeanInstance;
        this.attributeInfo = attributeInfo;
        this.name = attributeInfo.getName();
        this.isConstructorArg = isConstructorArg;
        try {
            this.type = ClassLoading.loadClass(attributeInfo.getType(), gbeanInstance.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load attribute class: " + attributeInfo.getType());
        }
        this.persistent = attributeInfo.isPersistent();
        this.readable = attributeInfo.isReadable();
        this.writable = attributeInfo.isWritable();
        if (attributeInfo instanceof DynamicGAttributeInfo) {
            this.dynamic = true;
            this.getInvoker = this.readable ? new DynamicGetterMethodInvoker(this.name) : null;
            this.setInvoker = this.writable ? new DynamicSetterMethodInvoker(this.name) : null;
        } else {
            this.dynamic = false;
            if (attributeInfo.getGetterName() != null) {
                try {
                    String getterName = attributeInfo.getGetterName();
                    Method getterMethod = gbeanInstance.getType().getMethod(getterName, null);
                    if (!getterMethod.getReturnType().equals(this.type)) {
                        throw new InvalidConfigurationException("Getter method of wrong type: " + getterMethod.getReturnType() + " expected " + this.getDescription());
                    }
                    this.getInvoker = new FastMethodInvoker(getterMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidConfigurationException("Getter method not found " + this.getDescription());
                }
            } else {
                this.getInvoker = null;
            }
            if (attributeInfo.getSetterName() != null) {
                try {
                    String setterName = attributeInfo.getSetterName();
                    Method setterMethod = gbeanInstance.getType().getMethod(setterName, this.type);
                    this.setInvoker = new FastMethodInvoker(setterMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidConfigurationException("Setter method not found " + this.getDescription());
                }
            } else {
                this.setInvoker = null;
            }
        }
        this.initializePersistentValue(null);
    }

    private void initializePersistentValue(Object value) {
        if (this.persistent || this.special) {
            if (value == null && this.type.isPrimitive()) {
                value = this.type == Boolean.TYPE ? Boolean.FALSE : (this.type == Byte.TYPE ? new Byte(0) : (this.type == Short.TYPE ? new Short(0) : (this.type == Integer.TYPE ? new Integer(0) : (this.type == Long.TYPE ? new Long(0L) : (this.type == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(this.type == Float.TYPE ? (Number)new Float(0.0f) : (Number)new Double(0.0)))))));
            }
            this.persistentValue = value;
        }
    }

    public String getName() {
        return this.name;
    }

    public GAttributeInfo getAttributeInfo() {
        return this.attributeInfo;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void inject(Object target) throws Exception {
        if ((this.persistent || this.special) && !this.isConstructorArg && this.writable) {
            this.setValue(target, this.persistentValue);
        }
    }

    public Object getPersistentValue() {
        if (!this.persistent && !this.special) {
            throw new IllegalStateException("Attribute is not persistent " + this.getDescription());
        }
        return this.persistentValue;
    }

    public void setPersistentValue(Object persistentValue) {
        if (!this.persistent && !this.special) {
            throw new IllegalStateException("Attribute is not persistent " + this.getDescription());
        }
        if (persistentValue == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
        }
        this.persistentValue = persistentValue;
    }

    public Object getValue(Object target) throws Exception {
        if (!this.readable) {
            if (this.persistent) {
                throw new IllegalStateException("This persistent attribute is not accessible while started. " + this.getDescription());
            }
            throw new IllegalStateException("This attribute is not readable. " + this.getDescription());
        }
        if (this.special) {
            return this.persistentValue;
        }
        if (target == null && !this.framework) {
            throw new IllegalStateException("GBean does not have a target instance to invoke. " + this.getDescription());
        }
        Object value = this.getInvoker.invoke(target, null);
        return value;
    }

    public void setValue(Object target, Object value) throws Exception {
        if (!this.writable) {
            if (this.persistent) {
                throw new IllegalStateException("This persistent attribute is not modifable while running. " + this.getDescription());
            }
            throw new IllegalStateException("This attribute is not writable. " + this.getDescription());
        }
        if (value == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
        }
        if (target == null && !this.framework) {
            throw new IllegalStateException("GBean does not have a target instance to invoke. " + this.getDescription());
        }
        this.setInvoker.invoke(target, new Object[]{value});
    }

    public String getDescription() {
        return "Attribute Name: " + this.getName() + ", Type: " + this.getType() + ", GBeanInstance: " + this.gbeanInstance.getName();
    }

    static {
        $assertionsDisabled = !GBeanAttribute.class.desiredAssertionStatus();
    }

    private static final class DynamicSetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicSetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            ((DynamicGBean)target).setAttribute(this.name, arguments[0]);
            return null;
        }
    }

    private static final class DynamicGetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicGetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            return ((DynamicGBean)target).getAttribute(this.name);
        }
    }
}

