/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import [Ljava.lang.String;;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.geronimo.EJBContainer;
import org.apache.geronimo.j2ee.management.geronimo.J2EEServer;
import org.apache.geronimo.j2ee.management.geronimo.WebContainer;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.pool.GeronimoExecutor;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class J2EEServerImpl
implements J2EEServer {
    private static final String SERVER_VENDOR = "The Apache Software Foundation";
    private final Kernel kernel;
    private final String baseName;
    private final ServerInfo serverInfo;
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEServerImpl(Kernel kernel, String objectName, ServerInfo serverInfo) {
        this.objectName = objectName;
        ObjectName myObjectName = JMXUtil.getObjectName(this.objectName);
        this.verifyObjectName(myObjectName);
        Hashtable<String, String> keyPropertyList = myObjectName.getKeyPropertyList();
        String name = keyPropertyList.get("name");
        this.baseName = myObjectName.getDomain() + ":J2EEServer=" + name + ",";
        this.kernel = kernel;
        this.serverInfo = serverInfo;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEServer".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEServer object name j2eeType property must be 'J2EEServer'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("J2EEServer object must contain a name property", objectName);
        }
        if (keyPropertyList.size() != 2) {
            throw new InvalidObjectNameException("J2EEServer object name can only have j2eeType, and name", objectName);
        }
    }

    public String[] getDeployedObjects() {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"J2EEApplication", "AppClientModule", "EJBModule", "WebModule", "ResourceAdapterModule"});
    }

    public String[] getResources() {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"JavaMailResource", "JCAConnectionFactory", "JDBCResource", "JDBCDriver", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URLResource"});
    }

    public String[] getJavaVMs() {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"JVM"});
    }

    public String getWebContainer() {
        GBeanQuery query = new GBeanQuery(null, WebContainer.class.getName());
        Set set = this.kernel.listGBeans(query);
        if (set.size() == 0) {
            return null;
        }
        return ((ObjectName)set.iterator().next()).getCanonicalName();
    }

    public String getEJBContainer() {
        GBeanQuery query = new GBeanQuery(null, EJBContainer.class.getName());
        Set set = this.kernel.listGBeans(query);
        if (set.size() == 0) {
            return null;
        }
        return ((ObjectName)set.iterator().next()).getCanonicalName();
    }

    public String[] getThreadPools() {
        GBeanQuery query = new GBeanQuery(null, GeronimoExecutor.class.getName());
        Set set = this.kernel.listGBeans(query);
        String[] names = new String[set.size()];
        int i = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            names[i++] = name.getCanonicalName();
        }
        return names;
    }

    public String getServerVendor() {
        return SERVER_VENDOR;
    }

    public String getServerVersion() {
        return this.serverInfo.getVersion();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(J2EEServerImpl.class, NameFactory.J2EE_SERVER);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("deployedObjects", String;.class, false);
        infoFactory.addAttribute("resources", String;.class, false);
        infoFactory.addAttribute("javaVMs", String;.class, false);
        infoFactory.addAttribute("serverVendor", String.class, false);
        infoFactory.addAttribute("serverVersion", String.class, false);
        infoFactory.addInterface(J2EEServer.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

