/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.geronimo.JVM;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class JVMImpl
implements JVM {
    private static final Log log;
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String NODE;
    private static final Runtime runtime;
    private final String objectName;
    private final Kernel kernel;
    private final String baseName;
    public static final GBeanInfo GBEAN_INFO;

    public JVMImpl(String objectName, Kernel kernel) {
        this.objectName = objectName;
        this.kernel = kernel;
        ObjectName myObjectName = JMXUtil.getObjectName(this.objectName);
        this.verifyObjectName(myObjectName);
        Hashtable<String, String> keyPropertyList = myObjectName.getKeyPropertyList();
        String serverName = keyPropertyList.get("J2EEServer");
        this.baseName = myObjectName.getDomain() + ":J2EEServer=" + serverName + ",";
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"JVM".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("JVM object name j2eeType property must be 'JVM'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("JVM object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("JVM object must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 3) {
            throw new InvalidObjectNameException("J2EEServer object name can only have J2EEServer, j2eeType, and name", objectName);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getJavaVersion() {
        return JAVA_VERSION;
    }

    public String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public String getNode() {
        return NODE;
    }

    public long getFreeMemory() {
        return runtime.freeMemory();
    }

    public long getMaxMemory() {
        return runtime.maxMemory();
    }

    public long getTotalMemory() {
        return runtime.totalMemory();
    }

    public int getAvailableProcessors() {
        return runtime.availableProcessors();
    }

    public Date getKernelBootTime() {
        return this.kernel.getBootTime();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public String getSystemLog() {
        String[] logs = Util.getObjectNames(this.kernel, this.baseName, new String[]{"SystemLog"});
        if (logs.length != 1) {
            log.error((Object)("Unable to resolve ObjectName for system log; got " + logs.length + " results!"));
            return null;
        }
        return logs[0];
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        String node;
        log = LogFactory.getLog((Class)JVMImpl.class);
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        runtime = Runtime.getRuntime();
        try {
            node = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            node = null;
        }
        NODE = node;
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JVMImpl.class, NameFactory.JVM);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(JVM.class);
        infoFactory.setConstructor(new String[]{"objectName", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

