/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanName;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelGBean;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.basic.BasicDependencyManager;
import org.apache.geronimo.kernel.basic.BasicLifecycleMonitor;
import org.apache.geronimo.kernel.basic.BasicProxyManager;
import org.apache.geronimo.kernel.basic.BasicRegistry;
import org.apache.geronimo.kernel.basic.LifecycleMonitorFlyweight;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class BasicKernel
implements Kernel {
    private static final String[] NO_TYPES;
    private static final Object[] NO_ARGS;
    private final String kernelName;
    private Log log;
    private boolean running;
    private Date bootTime;
    private final BasicRegistry registry;
    private LinkedList shutdownHooks = new LinkedList();
    private DependencyManager dependencyManager;
    private BasicLifecycleMonitor lifecycleMonitor;
    private LifecycleMonitor publicLifecycleMonitor;
    private ProxyManager proxyManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicKernel(String kernelName) {
        if (kernelName.indexOf(58) >= 0 || kernelName.indexOf(42) >= 0 || kernelName.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Kernel name may not contain a ':', '*' or '?' character");
        }
        this.kernelName = kernelName;
        this.registry = new BasicRegistry();
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public LifecycleMonitor getLifecycleMonitor() {
        return this.publicLifecycleMonitor;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(objectName));
        return gbeanInstance.getAttribute(attributeName);
    }

    public void setAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(objectName));
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    public Object invoke(ObjectName objectName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(objectName, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(objectName));
        return gbeanInstance.invoke(methodName, args, types);
    }

    public boolean isLoaded(ObjectName name) {
        return this.registry.isRegistered(this.createGBeanName(name));
    }

    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.getGBeanInfo();
    }

    public GBeanData getGBeanData(ObjectName name) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.getGBeanData();
    }

    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws GBeanAlreadyExistsException, InternalKernelException {
        ObjectName objectName = gbeanData.getName();
        GBeanInstance gbeanInstance = new GBeanInstance(gbeanData, this, this.dependencyManager, this.lifecycleMonitor.createLifecycleBroadcaster(objectName), classLoader);
        this.registry.register(gbeanInstance);
    }

    public void startGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        gbeanInstance.start();
    }

    public void startRecursiveGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        gbeanInstance.startRecursive();
    }

    public void stopGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        gbeanInstance.stop();
    }

    public void unloadGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanName gbeanName = this.createGBeanName(name);
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(gbeanName);
        gbeanInstance.die();
        this.registry.unregister(gbeanName);
    }

    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.getState();
    }

    public long getGBeanStartTime(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.getStartTime();
    }

    public boolean isGBeanEnabled(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.isEnabled();
    }

    public void setGBeanEnabled(ObjectName name, boolean enabled) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        gbeanInstance.setEnabled(enabled);
    }

    public Set listGBeans(ObjectName pattern) {
        String domain = pattern == null || pattern.isDomainPattern() ? null : pattern.getDomain();
        Hashtable<String, String> props = pattern == null ? null : pattern.getKeyPropertyList();
        Set gbeans = this.registry.listGBeans(domain, props);
        HashSet<ObjectName> result = new HashSet<ObjectName>(gbeans.size());
        Iterator i = gbeans.iterator();
        while (i.hasNext()) {
            GBeanInstance instance = (GBeanInstance)i.next();
            result.add(instance.getObjectNameObject());
        }
        return result;
    }

    public Set listGBeans(Set patterns) {
        HashSet gbeans = new HashSet();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            ObjectName pattern = (ObjectName)iterator.next();
            gbeans.addAll(this.listGBeans(pattern));
        }
        return gbeans;
    }

    public Set listGBeans(String[] patterns) {
        HashSet gbeans = new HashSet();
        for (int i = 0; i < patterns.length; ++i) {
            ObjectName pattern = null;
            try {
                pattern = ObjectName.getInstance(patterns[i]);
            }
            catch (MalformedObjectNameException e) {
                // empty catch block
            }
            gbeans.addAll(this.listGBeans(pattern));
        }
        return gbeans;
    }

    public Set listGBeansByInterface(String[] interfaces) {
        HashSet<ObjectName> gbeans = new HashSet<ObjectName>();
        Set all = null;
        try {
            all = this.listGBeans(ObjectName.getInstance("*:*"));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("How can *:* be an invalid pattern");
        }
        Iterator it = all.iterator();
        block4: while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            try {
                GBeanInfo info = this.getGBeanData(name).getGBeanInfo();
                Set intfs = info.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    String candidate = interfaces[i];
                    if (!intfs.contains(candidate)) continue;
                    gbeans.add(name);
                    continue block4;
                }
            }
            catch (GBeanNotFoundException e) {
            }
        }
        return gbeans;
    }

    public Set listGBeans(GBeanQuery query) {
        HashSet results = new HashSet();
        if (query.getGBeanNames() != null && query.getGBeanNames().length > 0) {
            results.addAll(this.listGBeans(query.getGBeanNames()));
        }
        if (query.getInterfaces() != null && query.getInterfaces().length > 0) {
            results.addAll(this.listGBeansByInterface(query.getInterfaces()));
        }
        return results;
    }

    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.bootTime = new Date();
        this.log = LogFactory.getLog((String)BasicKernel.class.getName());
        this.log.info((Object)"Starting boot");
        KernelRegistry.registerKernel(this);
        this.registry.start(this);
        this.lifecycleMonitor = new BasicLifecycleMonitor(this);
        this.publicLifecycleMonitor = new LifecycleMonitorFlyweight(this.lifecycleMonitor);
        this.dependencyManager = new BasicDependencyManager(this.publicLifecycleMonitor);
        this.proxyManager = new BasicProxyManager(this);
        GBeanData kernelGBeanData = new GBeanData(KERNEL, KernelGBean.GBEAN_INFO);
        this.loadGBean(kernelGBeanData, this.getClass().getClassLoader());
        this.startGBean(KERNEL);
        this.running = true;
        this.log.info((Object)"Booted");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook(Runnable hook) {
        if (!$assertionsDisabled && hook == null) {
            throw new AssertionError((Object)"Shutdown hook was null");
        }
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShutdownHook(Runnable hook) {
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.info((Object)"Starting kernel shutdown");
        this.notifyShutdownHooks();
        this.registry.stop();
        this.dependencyManager.close();
        this.dependencyManager = null;
        BasicKernel basicKernel = this;
        synchronized (basicKernel) {
            this.notify();
        }
        KernelRegistry.unregisterKernel(this);
        this.log.info((Object)"Kernel shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownHooks() {
        while (!this.shutdownHooks.isEmpty()) {
            Runnable hook;
            LinkedList linkedList = this.shutdownHooks;
            synchronized (linkedList) {
                hook = (Runnable)this.shutdownHooks.removeFirst();
            }
            try {
                hook.run();
            }
            catch (Throwable e) {
                this.log.warn((Object)"Error from kernel shutdown hook", e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(this.createGBeanName(name));
        return gbeanInstance.getClassLoader();
    }

    private GBeanName createGBeanName(ObjectName objectName) {
        if (objectName.getDomain().length() == 0) {
            return new GBeanName(this.kernelName, objectName.getKeyPropertyList());
        }
        return new GBeanName(objectName);
    }

    static {
        $assertionsDisabled = !BasicKernel.class.desiredAssertionStatus();
        NO_TYPES = new String[0];
        NO_ARGS = new Object[0];
    }
}

