/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.ProxyMethodInterceptor;
import org.apache.geronimo.kernel.proxy.ProxyFactory;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class BasicProxyManager
implements ProxyManager {
    private final String MANAGED_BEAN_NAME = "org.apache.geronimo.kernel.proxy.GeronimoManagedBean";
    private static final Log log;
    private final Kernel kernel;
    private final IdentityHashMap interceptors = new IdentityHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$proxy$MethodInterceptor;

    public BasicProxyManager(Kernel kernel) {
        this.kernel = kernel;
    }

    public synchronized ProxyFactory createProxyFactory(Class type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)"type is null");
        }
        if (type.getClassLoader() == null) {
            log.debug((Object)("Unable to add GeronimoManagedBean to proxy for " + type.getName() + " (no CL)"));
            return new ManagedProxyFactory(type);
        }
        try {
            Class<?> managedBean = type.getClassLoader().loadClass("org.apache.geronimo.kernel.proxy.GeronimoManagedBean");
            return new ManagedProxyFactory(new Class[]{type, managedBean});
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Unable to add GeronimoManagedBean to proxy for " + type.getName() + " (not in CL)"));
            return new ManagedProxyFactory(type);
        }
    }

    public synchronized ProxyFactory createProxyFactory(Class[] type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)"type is null");
        }
        if (!$assertionsDisabled && type.length <= 0) {
            throw new AssertionError((Object)"interface list is empty");
        }
        Class<?> managedBean = null;
        for (int i = 0; i < type.length; ++i) {
            if (type[i].getClassLoader() == null) continue;
            try {
                managedBean = type[i].getClassLoader().loadClass("org.apache.geronimo.kernel.proxy.GeronimoManagedBean");
                break;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (managedBean != null) {
            Class[] adjusted = new Class[type.length + 1];
            System.arraycopy(type, 0, adjusted, 0, type.length);
            adjusted[type.length] = managedBean;
            type = adjusted;
        } else {
            log.debug((Object)"Unable to add GeronimoManagedBean to proxy (no proxy classes have ClassLoaders)");
        }
        return new ManagedProxyFactory(type);
    }

    public synchronized Object createProxy(ObjectName target, Class type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)"type is null");
        }
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError((Object)"target is null");
        }
        return this.createProxyFactory(type).createProxy(target);
    }

    public Object createProxy(ObjectName target, ClassLoader loader) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError((Object)"target is null");
        }
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(target);
            if (info.getInterfaces().size() == 0) {
                log.warn((Object)("No interfaces found for " + target + " (" + info.getClassName() + ")"));
                return null;
            }
            String[] names = info.getInterfaces().toArray(new String[0]);
            Class[] intfs = new Class[names.length];
            for (int i = 0; i < intfs.length; ++i) {
                intfs[i] = loader.loadClass(names[i]);
            }
            return this.createProxyFactory(intfs).createProxy(target);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + target);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load interface in provided ClassLoader: " + e.getMessage());
        }
    }

    public Object createProxy(ObjectName target, Class required, Class[] optional) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError((Object)"target is null");
        }
        if (required == null && (optional == null || optional.length == 0)) {
            throw new IllegalArgumentException("Cannot create proxy for no interfaces");
        }
        ArrayList<Class> list = new ArrayList<Class>();
        if (required != null) {
            list.add(required);
        }
        if (optional != null) {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(target);
                Set set = info.getInterfaces();
                for (int i = 0; i < optional.length; ++i) {
                    if (!set.contains(optional[i].getName())) continue;
                    list.add(optional[i]);
                }
            }
            catch (GBeanNotFoundException e) {
                throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + target);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return this.createProxyFactory(list.toArray(new Class[list.size()])).createProxy(target);
    }

    public Object[] createProxies(String[] objectNameStrings, ClassLoader loader) throws MalformedObjectNameException {
        Object[] result = new Object[objectNameStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createProxy(ObjectName.getInstance(objectNameStrings[i]), loader);
        }
        return result;
    }

    public Object[] createProxies(String[] objectNameStrings, Class required, Class[] optional) throws MalformedObjectNameException {
        Object[] result = new Object[objectNameStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createProxy(ObjectName.getInstance(objectNameStrings[i]), required, optional);
        }
        return result;
    }

    public synchronized void destroyProxy(Object proxy) {
        if (proxy == null) {
            return;
        }
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.remove(proxy);
        if (methodInterceptor != null) {
            this.doDestroy(methodInterceptor);
        }
    }

    public boolean isProxy(Object proxy) {
        return this.interceptors.containsKey(proxy);
    }

    public synchronized ObjectName getProxyTarget(Object proxy) {
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.get(proxy);
        if (methodInterceptor == null) {
            return null;
        }
        return this.getObjectName(methodInterceptor);
    }

    protected Callback getMethodInterceptor(Class proxyType, Kernel kernel, ObjectName target) {
        return new ProxyMethodInterceptor(proxyType, kernel, target);
    }

    protected void doDestroy(MethodInterceptor methodInterceptor) {
        ((ProxyMethodInterceptor)methodInterceptor).destroy();
    }

    protected ObjectName getObjectName(MethodInterceptor methodInterceptor) {
        return ((ProxyMethodInterceptor)methodInterceptor).getObjectName();
    }

    static {
        $assertionsDisabled = !BasicProxyManager.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)BasicProxyManager.class);
    }

    private class ManagedProxyFactory
    implements ProxyFactory {
        private final Class proxyType;
        private final Enhancer enhancer = new Enhancer();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ManagedProxyFactory(Class type) {
            this(new Class[]{type});
        }

        public ManagedProxyFactory(Class[] type) {
            if (type.length > 1) {
                type = this.reduceInterfaces(type);
            }
            if (type.length == 0) {
                throw new IllegalArgumentException("Cannot generate proxy for 0 interfaces!");
            }
            if (type.length == 1) {
                this.enhancer.setSuperclass(type[0]);
            } else if (type[0].isInterface()) {
                this.enhancer.setSuperclass(class$java$lang$Object == null ? (class$java$lang$Object = BasicProxyManager.class$("java.lang.Object")) : class$java$lang$Object);
                this.enhancer.setInterfaces(type);
            } else {
                Class[] intfs = new Class[type.length - 1];
                System.arraycopy(type, 1, intfs, 0, intfs.length);
                this.enhancer.setSuperclass(type[0]);
                this.enhancer.setInterfaces(intfs);
            }
            this.enhancer.setCallbackType(class$net$sf$cglib$proxy$MethodInterceptor == null ? (class$net$sf$cglib$proxy$MethodInterceptor = BasicProxyManager.class$("net.sf.cglib.proxy.MethodInterceptor")) : class$net$sf$cglib$proxy$MethodInterceptor);
            this.enhancer.setUseFactory(false);
            this.proxyType = this.enhancer.createClass();
        }

        public synchronized Object createProxy(ObjectName target) {
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError((Object)"target is null");
            }
            Callback callback = BasicProxyManager.this.getMethodInterceptor(this.proxyType, BasicProxyManager.this.kernel, target);
            this.enhancer.setCallbacks(new Callback[]{callback});
            Object proxy = this.enhancer.create();
            BasicProxyManager.this.interceptors.put(proxy, callback);
            return proxy;
        }

        private Class[] reduceInterfaces(Class[] source) {
            int i;
            boolean changed = false;
            Class cls = null;
            block0: for (i = 0; i < source.length - 1; ++i) {
                Class original = source[i];
                if (original == null) continue;
                if (!original.isInterface()) {
                    if (cls != null) {
                        throw new IllegalArgumentException(original.getName() + " is not an interface (already have " + cls.getName() + "); can only have one non-interface class for proxy");
                    }
                    cls = original;
                }
                for (int j = i + 1; j < source.length; ++j) {
                    Class other = source[j];
                    if (other == null) continue;
                    if (!other.isInterface()) {
                        if (cls != null) {
                            throw new IllegalArgumentException(other.getName() + " is not an interface (already have " + cls.getName() + "); can only have one non-interface class for proxy");
                        }
                        cls = other;
                    }
                    if (other.isAssignableFrom(original)) {
                        source[j] = null;
                        changed = true;
                        continue;
                    }
                    if (!original.isAssignableFrom(other)) continue;
                    source[i] = null;
                    changed = true;
                    continue block0;
                }
            }
            if (cls != null && cls != source[0]) {
                for (i = 0; i < source.length; ++i) {
                    if (cls != source[i]) continue;
                    Class temp = source[0];
                    source[0] = source[i];
                    source[i] = temp;
                    break;
                }
                changed = true;
            }
            if (!changed) {
                return source;
            }
            ArrayList<Class> list = new ArrayList<Class>(source.length);
            for (int i2 = 0; i2 < source.length; ++i2) {
                if (source[i2] == null) continue;
                list.add(source[i2]);
            }
            return list.toArray(new Class[list.size()]);
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$kernel$basic$BasicProxyManager == null ? (class$org$apache$geronimo$kernel$basic$BasicProxyManager = BasicProxyManager.class$("org.apache.geronimo.kernel.basic.BasicProxyManager")) : class$org$apache$geronimo$kernel$basic$BasicProxyManager).desiredAssertionStatus();
        }
    }
}

