/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class ConfigurationManagerImpl
implements ConfigurationManager,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ConfigurationManagerImpl.class);
    private final Kernel kernel;
    private final Collection stores;
    private final ShutdownHook shutdownHook;
    private static final ObjectName CONFIG_QUERY = JMXUtil.getObjectName("geronimo.config:*");
    public static final GBeanInfo GBEAN_INFO;

    public ConfigurationManagerImpl(Kernel kernel, Collection stores) {
        this.kernel = kernel;
        this.stores = stores;
        this.shutdownHook = new ShutdownHook(kernel);
    }

    public List listStores() {
        List storeSnapshot = this.getStores();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(storeSnapshot.size());
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            result.add(JMXUtil.getObjectName(store.getObjectName()));
        }
        return result;
    }

    public List listConfigurations(ObjectName storeName) throws NoSuchStoreException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!storeName.equals(JMXUtil.getObjectName(store.getObjectName()))) continue;
            return store.listConfiguations();
        }
        throw new NoSuchStoreException("No such store: " + storeName);
    }

    public boolean isLoaded(URI configID) {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            return this.kernel.isLoaded(name);
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
    }

    public ObjectName load(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configID)) continue;
            return store.loadConfiguration(configID);
        }
        throw new NoSuchConfigException("No configuration with id: " + configID);
    }

    public List loadRecursive(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        try {
            LinkedList<ObjectName> ancestors = new LinkedList<ObjectName>();
            while (configID != null && !this.isLoaded(configID)) {
                ObjectName name = this.load(configID);
                ancestors.addFirst(name);
                configID = (URI)this.kernel.getAttribute(name, "parentId");
            }
            return ancestors;
        }
        catch (NoSuchConfigException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException(e);
        }
    }

    public void unload(URI configID) throws NoSuchConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException("Cannot convert ID to ObjectName: ", e);
        }
        try {
            this.kernel.unloadGBean(configName);
        }
        catch (GBeanNotFoundException e) {
            throw new NoSuchConfigException("No config registered: " + configName, e);
        }
        log.info((Object)("Unloaded Configuration " + configName));
    }

    private List getStores() {
        return new ArrayList(this.stores);
    }

    public void doStart() {
        this.kernel.registerShutdownHook(this.shutdownHook);
    }

    public void doStop() {
        this.kernel.unregisterShutdownHook(this.shutdownHook);
    }

    public void doFail() {
        log.error((Object)"Cofiguration manager failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ConfigurationManagerImpl.class, "ConfigurationManager");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("Stores", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addInterface(ConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ShutdownHook
    implements Runnable {
        private final Kernel kernel;

        public ShutdownHook(Kernel kernel) {
            this.kernel = kernel;
        }

        public void run() {
            Set configs;
            block5: while (!(configs = this.kernel.listGBeans(CONFIG_QUERY)).isEmpty()) {
                Iterator i = configs.iterator();
                while (true) {
                    if (!i.hasNext()) continue block5;
                    ObjectName configName = (ObjectName)i.next();
                    if (!this.kernel.isLoaded(configName)) continue;
                    try {
                        this.kernel.stopGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                    catch (InternalKernelException e) {
                        log.warn((Object)("Could not stop configuration: " + configName), (Throwable)e);
                    }
                    try {
                        this.kernel.unloadGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                }
                break;
            }
            return;
        }
    }
}

