/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.ObjectName;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.KernelGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.KernelOperationInvoker;
import org.apache.geronimo.kernel.basic.KernelSetAttributeInvoker;
import org.apache.geronimo.kernel.basic.ProxyInvoker;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.proxy.DeadProxyException;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class JMXProxyMethodInterceptor
implements MethodInterceptor {
    private final Class proxyType;
    private final ObjectName objectName;
    private ProxyInvoker[] gbeanInvokers;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public JMXProxyMethodInterceptor(Class proxyType, Kernel kernel, ObjectName objectName) {
        if (!$assertionsDisabled && proxyType == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && kernel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && objectName == null) {
            throw new AssertionError();
        }
        this.proxyType = proxyType;
        this.objectName = objectName;
        this.gbeanInvokers = this.createGBeanInvokers(kernel);
    }

    public synchronized void destroy() {
        this.gbeanInvokers = null;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        ProxyInvoker gbeanInvoker;
        int interfaceIndex = proxy.getSuperIndex();
        JMXProxyMethodInterceptor jMXProxyMethodInterceptor = this;
        synchronized (jMXProxyMethodInterceptor) {
            if (this.gbeanInvokers == null) {
                throw new DeadProxyException("Proxy is no longer valid");
            }
            gbeanInvoker = this.gbeanInvokers[interfaceIndex];
        }
        if (gbeanInvoker == null) {
            throw new UnsupportedOperationException("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.objectName, args);
    }

    private ProxyInvoker[] createGBeanInvokers(Kernel kernel) {
        FastClass fastClass = FastClass.create((Class)this.proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = this.proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = JMXProxyMethodInterceptor.getSuperIndex(this.proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createProxyInvoker(kernel, method);
        }
        try {
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"equals", new Class[]{JMXProxyMethodInterceptor.class$java$lang$Object == null ? (JMXProxyMethodInterceptor.class$java$lang$Object = JMXProxyMethodInterceptor.class$((String)"java.lang.Object")) : JMXProxyMethodInterceptor.class$java$lang$Object}))] = new EqualsInvoke(kernel.getProxyManager());
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"hashCode", null))] = new HashCodeInvoke();
            invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"toString", null))] = new ToStringInvoke(this.proxyType.getName());
            if (GeronimoManagedBean.class.isAssignableFrom(this.proxyType)) {
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getState", null))] = new GetStateInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStateInstance", null))] = new GetStateInstanceInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"start", null))] = new StartInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"startRecursive", null))] = new StartRecursiveInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"stop", null))] = new StopInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStartTime", null))] = new GetStartTimeInvoke(kernel);
                invokers[JMXProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getObjectName", null))] = new GetObjectNameInvoke();
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return invokers;
    }

    private ProxyInvoker createProxyInvoker(Kernel kernel, Method method) {
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
            if (methodName.length() > 3 && methodName.startsWith("get") && !methodName.equals("getClass")) {
                String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(3));
                return new KernelGetAttributeInvoker(kernel, propertyName);
            }
            if (methodName.length() > 2 && methodName.startsWith("is")) {
                String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(2));
                return new KernelGetAttributeInvoker(kernel, propertyName);
            }
        }
        if (method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && methodName.length() > 3 && methodName.startsWith("set")) {
            String propertyName = JMXProxyMethodInterceptor.decapitalizePropertyName(methodName.substring(3));
            return new KernelSetAttributeInvoker(kernel, propertyName);
        }
        return new KernelOperationInvoker(kernel, method);
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType((Method)method), Type.getArgumentTypes((Method)method));
        MethodProxy methodProxy = MethodProxy.find((Class)proxyType, (Signature)signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    private static String decapitalizePropertyName(String propertyName) {
        if (Character.isUpperCase(propertyName.charAt(0))) {
            return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
        return propertyName;
    }

    static {
        $assertionsDisabled = !JMXProxyMethodInterceptor.class.desiredAssertionStatus();
    }

    static final class GetObjectNameInvoke
    implements ProxyInvoker {
        GetObjectNameInvoke() {
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return objectName.getCanonicalName();
        }
    }

    static final class StopInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StopInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            this.kernel.stopGBean(objectName);
            return null;
        }
    }

    static final class GetStartTimeInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStartTimeInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return new Long(this.kernel.getGBeanStartTime(objectName));
        }
    }

    static final class StartRecursiveInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartRecursiveInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            this.kernel.startRecursiveGBean(objectName);
            return null;
        }
    }

    static final class StartInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            this.kernel.startRecursiveGBean(objectName);
            return null;
        }
    }

    static final class GetStateInstanceInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInstanceInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return State.fromInt(this.kernel.getGBeanState(objectName));
        }
    }

    static final class GetStateInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return new Integer(this.kernel.getGBeanState(objectName));
        }
    }

    static final class ToStringInvoke
    implements ProxyInvoker {
        private final String interfaceName;

        public ToStringInvoke(String interfaceName) {
            this.interfaceName = "[" + interfaceName + ": ";
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return this.interfaceName + objectName + "]";
        }
    }

    static final class EqualsInvoke
    implements ProxyInvoker {
        private final ProxyManager proxyManager;

        public EqualsInvoke(ProxyManager proxyManager) {
            this.proxyManager = proxyManager;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            ObjectName proxyTarget = this.proxyManager.getProxyTarget(arguments[0]);
            return objectName.equals(proxyTarget);
        }
    }

    static final class HashCodeInvoke
    implements ProxyInvoker {
        HashCodeInvoke() {
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return new Integer(objectName.hashCode());
        }
    }
}

