/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import java.util.Date;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXProxyManager;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class KernelDelegate
implements Kernel {
    private final MBeanServerConnection mbeanServer;
    private final ProxyManager proxyManager;

    public KernelDelegate(MBeanServerConnection mbeanServer) {
        this.mbeanServer = mbeanServer;
        this.proxyManager = new JMXProxyManager(this);
    }

    public Date getBootTime() {
        return (Date)this.getKernelAttribute("bootTime");
    }

    public String getKernelName() {
        return (String)this.getKernelAttribute("kernelName");
    }

    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws GBeanAlreadyExistsException {
        try {
            this.invokeKernel("loadGBean", new Object[]{gbeanData, classLoader}, new String[]{GBeanData.class.getName(), ClassLoader.class.getName()});
        }
        catch (GBeanAlreadyExistsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void startGBean(ObjectName name) throws GBeanNotFoundException {
        try {
            this.invokeKernel("startGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void startRecursiveGBean(ObjectName name) throws GBeanNotFoundException {
        try {
            this.invokeKernel("startRecursiveGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void stopGBean(ObjectName name) throws GBeanNotFoundException {
        try {
            this.invokeKernel("stopGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void unloadGBean(ObjectName name) throws GBeanNotFoundException {
        try {
            this.invokeKernel("unloadGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public long getGBeanStartTime(ObjectName name) throws GBeanNotFoundException {
        try {
            return (Long)this.invokeKernel("getGBeanStartTime", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public boolean isGBeanEnabled(ObjectName name) throws GBeanNotFoundException {
        try {
            return (Boolean)this.invokeKernel("isGBeanEnabled", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void setGBeanEnabled(ObjectName name, boolean enabled) throws GBeanNotFoundException {
        try {
            this.invokeKernel("setGBeanEnabled", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws Exception {
        return this.invokeKernel("getAttribute", new Object[]{objectName, attributeName}, new String[]{ObjectName.class.getName(), String.class.getName()});
    }

    public void setAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws Exception {
        this.invokeKernel("setAttribute", new Object[]{objectName, attributeName, attributeValue}, new String[]{ObjectName.class.getName(), String.class.getName(), Object.class.getName()});
    }

    public Object invoke(ObjectName objectName, String methodName) throws Exception {
        return this.invokeKernel("invoke", new Object[]{objectName, methodName}, new String[]{ObjectName.class.getName(), String.class.getName()});
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws Exception {
        return this.invokeKernel("invoke", new Object[]{objectName, methodName, args, types}, new String[]{ObjectName.class.getName(), String.class.getName(), Object;.class.getName(), String;.class.getName()});
    }

    public boolean isLoaded(ObjectName name) {
        try {
            return (Boolean)this.invokeKernel("isLoaded", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public Set listGBeans(ObjectName pattern) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{pattern}, new String[]{ObjectName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public Set listGBeans(Set patterns) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{patterns}, new String[]{Set.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public Set listGBeans(GBeanQuery query) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{query}, new String[]{GBeanQuery.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void registerShutdownHook(Runnable hook) {
        try {
            this.invokeKernel("registerShutdownHook", new Object[]{hook}, new String[]{Runnable.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void unregisterShutdownHook(Runnable hook) {
        try {
            this.invokeKernel("unregisterShutdownHook", new Object[]{hook}, new String[]{Runnable.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public void shutdown() {
        try {
            this.invokeKernel("shutdown", new Object[0], new String[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws GBeanNotFoundException {
        try {
            return (ClassLoader)this.invokeKernel("getClassLoaderFor", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public GBeanData getGBeanData(ObjectName name) throws GBeanNotFoundException {
        try {
            return (GBeanData)this.invokeKernel("getGBeanData", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    public boolean isRunning() {
        return (Boolean)this.getKernelAttribute("running");
    }

    public DependencyManager getDependencyManager() {
        throw new UnsupportedOperationException("Dependency manager is not accessable by way of a remote connection");
    }

    public LifecycleMonitor getLifecycleMonitor() {
        throw new UnsupportedOperationException("Lifecycle monitor is not accessable by way of a remote connection");
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public void boot() throws Exception {
        throw new UnsupportedOperationException("A remote kernel can not be booted");
    }

    private Object getKernelAttribute(String attributeName) {
        try {
            return this.mbeanServer.getAttribute(Kernel.KERNEL, attributeName);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof InstanceNotFoundException) {
                throw new InternalKernelException("Kernel is not loaded");
            }
            if (cause instanceof AttributeNotFoundException) {
                throw new InternalKernelException("KernelDelegate is out of synch with Kernel");
            }
            throw new InternalKernelException(cause);
        }
    }

    private Object invokeKernel(String methodName, Object[] args, String[] types) throws Exception {
        try {
            return this.mbeanServer.invoke(Kernel.KERNEL, methodName, args, types);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof InstanceNotFoundException) {
                throw new InternalKernelException("Kernel is not loaded");
            }
            if (cause instanceof NoSuchMethodException) {
                throw new InternalKernelException("KernelDelegate is out of synch with Kernel");
            }
            if (cause instanceof JMException) {
                throw new InternalKernelException(cause);
            }
            if (cause instanceof JMRuntimeException) {
                throw new InternalKernelException(cause);
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new InternalKernelException("Unknown throwable", cause);
        }
    }

    private Throwable unwrapJMException(Throwable cause) {
        while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

