/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.Serializable;

public class JaasClientId
implements Serializable {
    private final long clientId;
    private final byte[] hash;
    private transient int hashCode;
    private transient String name;
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public JaasClientId(long clientId, byte[] hash) {
        this.clientId = clientId;
        this.hash = hash;
    }

    public long getClientId() {
        return this.clientId;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JaasClientId)) {
            return false;
        }
        JaasClientId another = (JaasClientId)obj;
        if (another.clientId != this.clientId) {
            return false;
        }
        for (int i = 0; i < this.hash.length; ++i) {
            if (another.hash[i] == this.hash[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            buffer.append(this.clientId);
            buffer.append(":0x");
            for (int i = 0; i < this.hash.length; ++i) {
                buffer.append(HEXCHAR[this.hash[i] >>> 4 & 0xF]);
                buffer.append(HEXCHAR[this.hash[i] & 0xF]);
            }
            buffer.append(']');
            this.name = buffer.toString();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (int i = 0; i < this.hash.length; ++i) {
                this.hashCode ^= this.hash[i];
            }
            this.hashCode ^= (int)(this.clientId ^ this.clientId >>> 32);
        }
        return this.hashCode;
    }
}

