/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.security.jaas.JaasClientId;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.JaasLoginService;
import org.apache.geronimo.security.jaas.JaasLoginServiceMBean;
import org.apache.geronimo.security.jaas.LoginModuleConfiguration;
import org.apache.geronimo.security.jaas.LoginUtils;
import org.apache.geronimo.security.remoting.jmx.JaasLoginServiceRemotingClient;

public class JaasLoginCoordinator
implements LoginModule {
    public static final String OPTION_HOST = "host";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_KERNEL = "kernel";
    public static final String OPTION_REALM = "realm";
    private String serverHost;
    private int serverPort;
    private String realmName;
    private String kernelName;
    private JaasLoginServiceMBean service;
    private CallbackHandler handler;
    private Subject subject;
    private Set processedPrincipals = new HashSet();
    private JaasLoginModuleConfiguration[] config;
    private JaasClientId client;
    LoginModuleConfiguration[] workers;
    static /* synthetic */ Class class$org$apache$geronimo$security$jaas$JaasLoginCoordinator;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.serverHost = (String)options.get(OPTION_HOST);
        Object port = options.get(OPTION_PORT);
        if (port != null) {
            this.serverPort = Integer.parseInt((String)port);
        }
        this.realmName = (String)options.get(OPTION_REALM);
        this.kernelName = (String)options.get(OPTION_KERNEL);
        this.service = this.connect();
        this.handler = callbackHandler;
        this.subject = subject == null ? new Subject() : subject;
    }

    public boolean login() throws LoginException {
        this.client = this.service.connectToRealm(this.realmName);
        this.config = this.service.getLoginConfiguration(this.client);
        this.workers = new LoginModuleConfiguration[this.config.length];
        for (int i = 0; i < this.workers.length; ++i) {
            LoginModule wrapper;
            if (this.config[i].isServerSide()) {
                wrapper = new ServerLoginModule(i);
            } else {
                LoginModule source = this.config[i].getLoginModule((class$org$apache$geronimo$security$jaas$JaasLoginCoordinator == null ? JaasLoginCoordinator.class$("org.apache.geronimo.security.jaas.JaasLoginCoordinator") : class$org$apache$geronimo$security$jaas$JaasLoginCoordinator).getClassLoader());
                wrapper = new ClientLoginModule(source, i);
            }
            this.workers[i] = new LoginModuleConfiguration(wrapper, this.config[i].getFlag());
            this.workers[i].getModule().initialize(this.subject, this.handler, new HashMap(), this.config[i].getOptions());
        }
        return LoginUtils.computeLogin(this.workers);
    }

    public boolean commit() throws LoginException {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].getModule().commit();
        }
        Principal[] principals = this.service.loginSucceeded(this.client);
        for (int i = 0; i < principals.length; ++i) {
            Principal principal = principals[i];
            this.subject.getPrincipals().add(principal);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort() throws LoginException {
        try {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].getModule().abort();
            }
        }
        finally {
            this.service.loginFailed(this.client);
        }
        this.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout() throws LoginException {
        try {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].getModule().logout();
            }
        }
        finally {
            this.service.logout(this.client);
        }
        this.clear();
        return true;
    }

    private void clear() {
        Kernel kernel = KernelRegistry.getKernel(this.kernelName);
        if (kernel != null) {
            kernel.getProxyManager().destroyProxy(this.service);
        }
        this.serverHost = null;
        this.serverPort = 0;
        this.realmName = null;
        this.kernelName = null;
        this.service = null;
        this.handler = null;
        this.subject = null;
        this.processedPrincipals.clear();
        this.config = null;
        this.client = null;
        this.workers = null;
    }

    private JaasLoginServiceMBean connect() {
        if (this.serverHost != null && this.serverPort > 0) {
            return JaasLoginServiceRemotingClient.create(this.serverHost, this.serverPort);
        }
        Kernel kernel = KernelRegistry.getKernel(this.kernelName);
        return (JaasLoginServiceMBean)kernel.getProxyManager().createProxy(JaasLoginService.OBJECT_NAME, JaasLoginServiceMBean.class);
    }

    private class ServerLoginModule
    implements LoginModule {
        int index;
        CallbackHandler handler;
        Callback[] callbacks;

        public ServerLoginModule(int index) {
            this.index = index;
        }

        public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
            this.handler = handler;
        }

        public boolean login() throws LoginException {
            try {
                this.callbacks = JaasLoginCoordinator.this.service.getServerLoginCallbacks(JaasLoginCoordinator.this.client, this.index);
                if (this.handler != null) {
                    this.handler.handle(this.callbacks);
                } else if (this.callbacks != null && this.callbacks.length > 0) {
                    System.err.println("No callback handler available for " + this.callbacks.length + " callbacks!");
                }
                return JaasLoginCoordinator.this.service.performServerLogin(JaasLoginCoordinator.this.client, this.index, this.callbacks);
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LoginException("Unable to log in: " + e.getMessage());
            }
        }

        public boolean commit() throws LoginException {
            return JaasLoginCoordinator.this.service.serverLoginModuleCommit(JaasLoginCoordinator.this.client, this.index);
        }

        public boolean abort() throws LoginException {
            return false;
        }

        public boolean logout() throws LoginException {
            return false;
        }
    }

    private class ClientLoginModule
    implements LoginModule {
        private LoginModule source;
        int index;

        public ClientLoginModule(LoginModule source, int index) {
            this.source = source;
            this.index = index;
        }

        public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
            this.source.initialize(subject, callbackHandler, sharedState, options);
        }

        public boolean login() throws LoginException {
            return this.source.login();
        }

        public boolean commit() throws LoginException {
            boolean result = this.source.commit();
            ArrayList<Principal> list = new ArrayList<Principal>();
            Iterator<Principal> it = JaasLoginCoordinator.this.subject.getPrincipals().iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                if (JaasLoginCoordinator.this.processedPrincipals.contains(p)) continue;
                list.add(p);
                JaasLoginCoordinator.this.processedPrincipals.add(p);
            }
            JaasLoginCoordinator.this.service.clientLoginModuleCommit(JaasLoginCoordinator.this.client, this.index, list.toArray(new Principal[list.size()]));
            return result;
        }

        public boolean abort() throws LoginException {
            return this.source.abort();
        }

        public boolean logout() throws LoginException {
            return this.source.logout();
        }
    }
}

