/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfigurationFactory;
import org.apache.geronimo.security.jacc.RoleDesignateSource;

public class ApplicationPolicyConfigurationManager
implements GBeanLifecycle,
RoleDesignateSource {
    private final Map contextIdToPolicyConfigurationMap = new HashMap();
    private final Map roleDesignates;
    public static final GBeanInfo GBEAN_INFO;

    public ApplicationPolicyConfigurationManager(Map contextIdToPermissionsMap, Map principalRoleMap, Map roleDesignates) throws PolicyContextException, ClassNotFoundException {
        PolicyConfiguration policyConfiguration;
        PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        Iterator iterator = contextIdToPermissionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextID = (String)entry.getKey();
            ComponentPermissions componentPermissions = (ComponentPermissions)entry.getValue();
            PolicyConfiguration policyConfiguration2 = policyConfigurationFactory.getPolicyConfiguration(contextID, false);
            this.contextIdToPolicyConfigurationMap.put(contextID, policyConfiguration2);
            policyConfiguration2.addToExcludedPolicy(componentPermissions.getExcludedPermissions());
            policyConfiguration2.addToUncheckedPolicy(componentPermissions.getUncheckedPermissions());
            Iterator roleIterator = componentPermissions.getRolePermissions().entrySet().iterator();
            while (roleIterator.hasNext()) {
                Map.Entry roleEntry = roleIterator.next();
                String roleName = (String)roleEntry.getKey();
                PermissionCollection rolePermissions = (PermissionCollection)roleEntry.getValue();
                Enumeration<Permission> permissions = rolePermissions.elements();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    policyConfiguration2.addToRole(roleName, permission);
                }
            }
            GeronimoPolicyConfigurationFactory roleMapperFactory = GeronimoPolicyConfigurationFactory.getSingleton();
            if (roleMapperFactory == null) {
                throw new IllegalStateException("Inconsistent security setup.  GeronimoPolicyConfigurationFactory is not being used");
            }
            GeronimoPolicyConfiguration geronimoPolicyConfiguration = roleMapperFactory.getGeronimoPolicyConfiguration(contextID);
            geronimoPolicyConfiguration.setPrincipalRoleMapping(principalRoleMap);
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            policyConfiguration = (PolicyConfiguration)iterator.next();
            Iterator iterator2 = this.contextIdToPolicyConfigurationMap.values().iterator();
            while (iterator2.hasNext()) {
                PolicyConfiguration policyConfiguration2 = (PolicyConfiguration)iterator2.next();
                if (policyConfiguration == policyConfiguration2) continue;
                policyConfiguration.linkConfiguration(policyConfiguration2);
            }
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            policyConfiguration = (PolicyConfiguration)iterator.next();
            policyConfiguration.commit();
        }
        Policy policy = Policy.getPolicy();
        policy.refresh();
        Iterator iterator2 = roleDesignates.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            Subject roleDesignate = (Subject)entry.getValue();
            ContextManager.registerSubject(roleDesignate);
            SubjectId id = ContextManager.getSubjectId(roleDesignate);
            roleDesignate.getPrincipals().add(new IdentificationPrincipal(id));
        }
        this.roleDesignates = roleDesignates;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        Iterator iterator = this.roleDesignates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Subject roleDesignate = (Subject)entry.getValue();
            ContextManager.unregisterSubject(roleDesignate);
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            PolicyConfiguration policyConfiguration = (PolicyConfiguration)iterator.next();
            policyConfiguration.delete();
        }
    }

    public void doFail() {
    }

    public Map getRoleDesignateMap() {
        return this.roleDesignates;
    }

    public GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(ApplicationPolicyConfigurationManager.class, "JACCManager");
        infoBuilder.addAttribute("contextIdToPermissionsMap", Map.class, true);
        infoBuilder.addAttribute("principalRoleMap", Map.class, true);
        infoBuilder.addAttribute("roleDesignates", Map.class, true);
        infoBuilder.addInterface(RoleDesignateSource.class);
        infoBuilder.setConstructor(new String[]{"contextIdToPermissionsMap", "principalRoleMap", "roleDesignates"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

