/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.network.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import org.activeio.AsynchChannel;
import org.activeio.FilterAsynchChannel;
import org.activeio.Packet;
import org.activeio.adapter.PacketInputStream;
import org.activeio.adapter.PacketOutputStream;
import org.activeio.packet.AppendedPacket;
import org.activeio.packet.ByteArrayPacket;
import org.activeio.packet.FilterPacket;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.network.protocol.SubjectContext;

public class SubjectCarryingChannel
extends FilterAsynchChannel {
    static final byte PASSTHROUGH = 0;
    static final byte SET_SUBJECT = 1;
    static final byte CLEAR_SUBJECT = 2;
    private final ByteArrayPacket header = new ByteArrayPacket(new byte[13]);
    private Subject remoteSubject;
    private Subject localSubject;
    private final boolean enableLocalSubjectPublishing;
    private final boolean enableRemoteSubjectConsumption;
    static /* synthetic */ Class class$org$apache$geronimo$security$network$protocol$SubjectContext;

    public SubjectCarryingChannel(AsynchChannel next) {
        this(next, true, true);
    }

    public SubjectCarryingChannel(AsynchChannel next, boolean enableLocalSubjectPublishing, boolean enableRemoteSubjectConsumption) {
        super(next);
        this.enableLocalSubjectPublishing = enableLocalSubjectPublishing;
        this.enableRemoteSubjectConsumption = enableRemoteSubjectConsumption;
    }

    public void write(Packet packet) throws IOException {
        if (!this.enableLocalSubjectPublishing) {
            super.write(packet);
            return;
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (this.remoteSubject != subject) {
            this.remoteSubject = subject;
            Set principals = this.remoteSubject.getPrincipals(IdentificationPrincipal.class);
            if (principals.isEmpty()) {
                super.write(this.createClearSubjectPackt());
            } else {
                IdentificationPrincipal principal = (IdentificationPrincipal)principals.iterator().next();
                SubjectId subjectId = principal.getId();
                super.write(this.createSubjectPacket(subjectId.getSubjectId(), subjectId.getHash()));
            }
        }
        super.write(this.createPassthroughPacket(packet));
    }

    public void onPacket(Packet packet) {
        if (!this.enableRemoteSubjectConsumption) {
            super.onPacket(packet);
            return;
        }
        try {
            switch (packet.read()) {
                case 2: {
                    this.localSubject = null;
                    return;
                }
                case 1: {
                    SubjectId subjectId = this.extractSubjectId(packet);
                    this.localSubject = ContextManager.getRegisteredSubject(subjectId);
                    return;
                }
                case 0: {
                    super.onPacket((Packet)new SubjectPacketFilter(packet));
                }
            }
        }
        catch (IOException e) {
            super.onPacketError(e);
        }
        super.onPacket(packet);
    }

    private SubjectId extractSubjectId(Packet packet) throws IOException {
        DataInputStream is = new DataInputStream((InputStream)new PacketInputStream(packet));
        Long id = new Long(is.readLong());
        byte[] hash = new byte[is.readInt()];
        return new SubjectId(id, hash);
    }

    private Packet createClearSubjectPackt() {
        this.header.clear();
        this.header.write(2);
        this.header.flip();
        return this.header;
    }

    private Packet createSubjectPacket(Long subjectId, byte[] hash) throws IOException {
        this.header.clear();
        DataOutputStream os = new DataOutputStream((OutputStream)new PacketOutputStream((Packet)this.header));
        os.writeByte(1);
        os.writeLong(subjectId);
        os.writeInt(hash.length);
        os.close();
        this.header.flip();
        return AppendedPacket.join((Packet)this.header, (Packet)new ByteArrayPacket(hash));
    }

    private Packet createPassthroughPacket(Packet packet) {
        this.header.clear();
        this.header.write(0);
        this.header.flip();
        return AppendedPacket.join((Packet)this.header, (Packet)packet);
    }

    public Subject getLocalSubject() {
        return this.localSubject;
    }

    public Subject getRemoteSubject() {
        return this.remoteSubject;
    }

    static /* synthetic */ Subject access$100(SubjectCarryingChannel x0) {
        return x0.remoteSubject;
    }

    public class SubjectPacketFilter
    extends FilterPacket {
        SubjectPacketFilter(Packet packet) {
            super(packet);
        }

        public Object narrow(Class target) {
            if (target == (class$org$apache$geronimo$security$network$protocol$SubjectContext == null ? (class$org$apache$geronimo$security$network$protocol$SubjectContext = SubjectCarryingChannel.class$("org.apache.geronimo.security.network.protocol.SubjectContext")) : class$org$apache$geronimo$security$network$protocol$SubjectContext)) {
                return new SubjectContext(this){
                    private final /* synthetic */ SubjectPacketFilter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Subject getSubject() {
                        return SubjectCarryingChannel.access$100(SubjectPacketFilter.access$000(this.this$1));
                    }
                };
            }
            return super.narrow(target);
        }

        public Packet filter(Packet packet) {
            return new SubjectPacketFilter(packet);
        }

        static /* synthetic */ SubjectCarryingChannel access$000(SubjectPacketFilter x0) {
            return x0.SubjectCarryingChannel.this;
        }
    }
}

