/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.deploy.Principal;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.JaasLoginCoordinator;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.realm.SecurityRealm;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class GenericSecurityRealm
implements SecurityRealm,
ConfigurationEntryFactory {
    private final String realmName;
    private JaasLoginModuleConfiguration[] config;
    private final Kernel kernel;
    private final Principal defaultPrincipal;
    private String[] domains;
    private boolean restrictPrincipalsToServer;
    public static final GBeanInfo GBEAN_INFO;

    public GenericSecurityRealm(String realmName, JaasLoginModuleUse loginModuleUse, boolean restrictPrincipalsToServer, Principal defaultPrincipal, ServerInfo serverInfo, ClassLoader classLoader, Kernel kernel) {
        this.realmName = realmName;
        this.kernel = kernel;
        this.restrictPrincipalsToServer = restrictPrincipalsToServer;
        this.defaultPrincipal = defaultPrincipal;
        HashSet domainNames = new HashSet();
        ArrayList loginModuleConfigurations = new ArrayList();
        if (loginModuleUse != null) {
            loginModuleUse.configure(domainNames, loginModuleConfigurations, kernel, serverInfo, classLoader);
        }
        this.domains = domainNames.toArray(new String[domainNames.size()]);
        this.config = loginModuleConfigurations.toArray(new JaasLoginModuleConfiguration[loginModuleConfigurations.size()]);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public JaasLoginModuleConfiguration[] getAppConfigurationEntries() {
        return this.config;
    }

    public String[] getLoginDomains() {
        return this.domains;
    }

    public Principal getDefaultPrincipal() {
        return this.defaultPrincipal;
    }

    public boolean isRestrictPrincipalsToServer() {
        return this.restrictPrincipalsToServer;
    }

    public String getConfigurationName() {
        return this.realmName;
    }

    public JaasLoginModuleConfiguration generateConfiguration() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("realm", this.realmName);
        options.put("kernel", this.kernel.getKernelName());
        return new JaasLoginModuleConfiguration(JaasLoginCoordinator.class.getName(), LoginModuleControlFlag.REQUIRED, options, true, this.realmName);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(GenericSecurityRealm.class, "SecurityRealm");
        infoFactory.addInterface(SecurityRealm.class);
        infoFactory.addInterface(ConfigurationEntryFactory.class);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("defaultPrincipal", Principal.class, true);
        infoFactory.addAttribute("deploymentSupport", Properties.class, true);
        infoFactory.addAttribute("restrictPrincipalsToServer", Boolean.TYPE, true);
        infoFactory.addReference("LoginModuleConfiguration", JaasLoginModuleUse.class, "LoginModuleUse");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addOperation("getAppConfigurationEntries", new Class[0]);
        infoFactory.setConstructor(new String[]{"realmName", "LoginModuleConfiguration", "restrictPrincipalsToServer", "defaultPrincipal", "ServerInfo", "classLoader", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

