/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class PropertiesFileLoginModule
implements LoginModule {
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    private static Log log;
    final Properties users = new Properties();
    final Map groups = new HashMap();
    Subject subject;
    CallbackHandler handler;
    String username;
    String password;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        try {
            Kernel kernel = KernelRegistry.getKernel((String)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL"));
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            URI usersURI = new URI((String)options.get(USERS_URI));
            URI groupsURI = new URI((String)options.get(GROUPS_URI));
            this.loadProperties(kernel, serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e);
        }
    }

    public void loadProperties(Kernel kernel, ServerInfo serverInfo, URI userURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolve(userURI);
            URI groupFile = serverInfo.resolve(groupURI);
            InputStream stream = userFile.toURL().openStream();
            this.users.load(stream);
            stream.close();
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    userset.add(userList[i]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 2) {
            throw new AssertionError();
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.equals("")) {
            return false;
        }
        String realPassword = this.users.getProperty(this.username);
        char[] entered = ((PasswordCallback)callbacks[1]).getPassword();
        this.password = entered == null ? null : new String(entered);
        return realPassword == null && this.password == null || realPassword != null && this.password != null && realPassword.equals(this.password);
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new GeronimoUserPrincipal(this.username));
        Iterator e = this.groups.keySet().iterator();
        block0: while (e.hasNext()) {
            String groupName = (String)e.next();
            Set users = (Set)this.groups.get(groupName);
            Iterator iter = users.iterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                if (!this.username.equals(user)) continue;
                principals.add(new GeronimoGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public String[] getPrincipalClassNames() {
        return new String[]{GeronimoUserPrincipal.class.getName(), GeronimoGroupPrincipal.class.getName()};
    }

    /*
     * WARNING - void declaration
     */
    public String[] getPrincipalsOfClass(String className) {
        void var2_2;
        Set<Object> s;
        if (className.equals(GeronimoGroupPrincipal.class.getName())) {
            s = this.groups.keySet();
        } else if (className.equals(GeronimoUserPrincipal.class.getName())) {
            s = this.users.keySet();
        } else {
            throw new IllegalArgumentException("No such principal class " + className);
        }
        return var2_2.toArray(new String[var2_2.size()]);
    }

    static {
        $assertionsDisabled = !PropertiesFileLoginModule.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)PropertiesFileLoginModule.class);
    }
}

