/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class SQLLoginModule
implements LoginModule {
    public static final String USER_SELECT = "userSelect";
    public static final String GROUP_SELECT = "groupSelect";
    public static final String CONNECTION_URL = "jdbcURL";
    public static final String USER = "jdbcUser";
    public static final String PASSWORD = "jdbcPassword";
    public static final String DRIVER = "jdbcDriver";
    private String connectionURL;
    private Properties properties;
    private Driver driver;
    private String userSelect;
    private String groupSelect;
    private Subject subject;
    private CallbackHandler handler;
    private String cbUsername;
    private String cbPassword;
    private final Set groups = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.connectionURL = (String)options.get(CONNECTION_URL);
        this.properties = new Properties();
        this.properties.put("user", options.get(USER));
        this.properties.put("password", options.get(PASSWORD));
        this.userSelect = (String)options.get(USER_SELECT);
        this.groupSelect = (String)options.get(GROUP_SELECT);
        ClassLoader cl = (ClassLoader)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER");
        try {
            this.driver = (Driver)cl.loadClass((String)options.get(DRIVER)).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Driver class " + this.driver + " is not available.  Perhaps you need to add it as a dependency in your deployment plan?");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load, instantiate, register driver " + this.driver + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 2) {
            throw new AssertionError();
        }
        this.cbUsername = ((NameCallback)callbacks[0]).getName();
        if (this.cbUsername == null) return false;
        if (this.cbUsername.equals("")) {
            return false;
        }
        char[] provided = ((PasswordCallback)callbacks[1]).getPassword();
        this.cbPassword = provided == null ? null : new String(provided);
        boolean found = false;
        try {
            Connection conn = this.driver.connect(this.connectionURL, this.properties);
            try {
                PreparedStatement statement = conn.prepareStatement(this.userSelect);
                try {
                    ResultSet result2 = statement.executeQuery();
                    try {
                        while (result2.next()) {
                            String userName = result2.getString(1);
                            String userPassword = result2.getString(2);
                            if (!this.cbUsername.equals(userName) || (this.cbPassword != null || userPassword != null) && (this.cbPassword == null || userPassword == null || !this.cbPassword.equals(userPassword))) continue;
                            found = true;
                            break;
                        }
                    }
                    finally {
                        result2.close();
                    }
                }
                finally {
                    statement.close();
                }
                if (!found) {
                    boolean result2 = false;
                    return result2;
                }
                statement = conn.prepareStatement(this.groupSelect);
                try {
                    ResultSet result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            String groupName = result.getString(1);
                            String userName = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            this.groups.add(new GeronimoGroupPrincipal(groupName));
                        }
                        return true;
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            throw (LoginException)new LoginException("SQL error").initCause(sqle);
        }
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new GeronimoUserPrincipal(this.cbUsername));
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            principals.add((Principal)iter.next());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }

    static {
        $assertionsDisabled = !SQLLoginModule.class.desiredAssertionStatus();
    }
}

