/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.context.BeanTransactionContext;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;

public final class OnlineUserTransaction
implements UserTransaction,
Serializable {
    private transient TransactionContextManager transactionContextManager;
    private transient TrackedConnectionAssociator trackedConnectionAssociator;

    boolean isActive() {
        return this.transactionContextManager != null;
    }

    public void setUp(TransactionContextManager transactionContextManager, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.transactionContextManager = transactionContextManager;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public int getStatus() throws SystemException {
        return this.transactionContextManager.getStatus();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionContextManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0, not " + seconds);
        }
        this.transactionContextManager.setTransactionTimeout(seconds);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transactionContextManager.newBeanTransactionContext(0L);
        if (this.trackedConnectionAssociator != null) {
            try {
                this.trackedConnectionAssociator.newTransaction();
            }
            catch (ResourceException e) {
                throw (SystemException)new SystemException().initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        UnspecifiedTransactionContext oldContext2;
        TransactionContext ctx = this.transactionContextManager.getContext();
        if (!(ctx instanceof BeanTransactionContext)) {
            throw new IllegalStateException("Transaction has not been started");
        }
        BeanTransactionContext beanContext = (BeanTransactionContext)ctx;
        try {
            if (!beanContext.commit()) {
                throw new RollbackException();
            }
            Object var4_3 = null;
            oldContext2 = beanContext.getOldContext();
            this.transactionContextManager.setContext(oldContext2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            UnspecifiedTransactionContext oldContext2 = beanContext.getOldContext();
            this.transactionContextManager.setContext(oldContext2);
            try {
                oldContext2.resume();
            }
            catch (InvalidTransactionException e) {
                throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
            }
            throw throwable;
        }
        try {
            oldContext2.resume();
        }
        catch (InvalidTransactionException e) {
            throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        UnspecifiedTransactionContext oldContext2;
        TransactionContext ctx = this.transactionContextManager.getContext();
        if (!(ctx instanceof BeanTransactionContext)) {
            throw new IllegalStateException("Transaction has not been started");
        }
        BeanTransactionContext beanContext = (BeanTransactionContext)ctx;
        try {
            beanContext.rollback();
            Object var4_3 = null;
            oldContext2 = beanContext.getOldContext();
            this.transactionContextManager.setContext(oldContext2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            UnspecifiedTransactionContext oldContext2 = beanContext.getOldContext();
            this.transactionContextManager.setContext(oldContext2);
            try {
                oldContext2.resume();
            }
            catch (InvalidTransactionException e) {
                throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
            }
            throw throwable;
        }
        try {
            oldContext2.resume();
        }
        catch (InvalidTransactionException e) {
            throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
        }
    }
}

