/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jencks.JCAConnector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class JCAContainer
implements InitializingBean,
DisposableBean,
BeanFactoryAware {
    private static final transient Log log = LogFactory.getLog((Class)JCAContainer.class);
    private BootstrapContext bootstrapContext;
    private ResourceAdapter resourceAdapter;
    private BeanFactory beanFactory;
    private boolean lazyLoad = false;

    public JCAConnector addConnector() {
        return new JCAConnector(this.getBootstrapContext(), this.getResourceAdapter());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("resourceAdapter must be set");
        }
        if (this.bootstrapContext == null && this.bootstrapContext == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        this.resourceAdapter.start(this.bootstrapContext);
        if (this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory should have been set by Spring");
        }
        if (!this.lazyLoad && this.beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
            String[] names = registry.getBeanDefinitionNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                BeanDefinition definition = registry.getBeanDefinition(name);
                if (definition.isAbstract()) continue;
                this.beanFactory.getBean(name);
            }
        }
        String version = null;
        Package aPackage = Package.getPackage("org.jencks");
        if (aPackage != null) {
            version = aPackage.getImplementationVersion();
        }
        log.info((Object)("Jencks JCA Container (http://jencks.org/) has started running version: " + version));
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }
}

