/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class TransactionManagerFactoryBean
implements FactoryBean,
InitializingBean {
    private int defaultTransactionTimeoutSeconds = 600;
    private TransactionLog transactionLog;
    private ReferenceCollection resourceManagers;
    private TransactionManagerImpl transactionManagerImpl;

    public Object getObject() throws Exception {
        return this.transactionManagerImpl;
    }

    public Class getObjectType() {
        return TransactionManagerImpl.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultTransactionTimeoutSeconds(int timeout) {
        this.defaultTransactionTimeoutSeconds = timeout;
    }

    public void setTransactionLog(TransactionLog log) {
        this.transactionLog = log;
    }

    public ReferenceCollection getResourceManagers() {
        return this.resourceManagers;
    }

    public void setResourceManagers(ReferenceCollection resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionLog == null) {
            this.transactionLog = new UnrecoverableLog();
        }
        this.transactionManagerImpl = new TransactionManagerImpl(this.defaultTransactionTimeoutSeconds, this.transactionLog, this.resourceManagers);
    }
}

