/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.XidImporter;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class WorkManagerFactoryBean
implements FactoryBean,
InitializingBean {
    private GeronimoWorkManager workManager;
    private TransactionContextManager transactionContextManager;
    private int threadPoolSize = 30;
    private ExtendedTransactionManager transactionManager;
    private XidImporter xidImporter;
    private int defaultTransactionTimeoutSeconds = 600;
    private TransactionLog transactionLog;
    private ReferenceCollection resourceManagers;

    public Object getObject() throws Exception {
        return this.workManager;
    }

    public Class getObjectType() {
        return WorkManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.workManager = this.createWorkManager();
        this.workManager.doStart();
    }

    public GeronimoWorkManager getWorkManager() throws Exception {
        if (this.workManager == null) {
            this.afterPropertiesSet();
        }
        return this.workManager;
    }

    public TransactionContextManager getTransactionContextManager() throws XAException {
        if (this.transactionContextManager == null) {
            this.transactionContextManager = this.createTransactionContextManager();
        }
        return this.transactionContextManager;
    }

    public void setTransactionContextManager(TransactionContextManager transactionContextManager) {
        this.transactionContextManager = transactionContextManager;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public ExtendedTransactionManager getTransactionManager() throws XAException {
        if (this.transactionManager == null) {
            this.transactionManager = new TransactionManagerImpl(this.getDefaultTransactionTimeoutSeconds(), this.getTransactionLog(), this.getResourceManagers());
        }
        return this.transactionManager;
    }

    public void setTransactionManager(ExtendedTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public XidImporter getXidImporter() {
        if (this.xidImporter == null && this.transactionManager instanceof XidImporter) {
            this.xidImporter = (XidImporter)((Object)this.transactionManager);
        }
        return this.xidImporter;
    }

    public void setXidImporter(XidImporter xidImporter) {
        this.xidImporter = xidImporter;
    }

    public int getDefaultTransactionTimeoutSeconds() {
        return this.defaultTransactionTimeoutSeconds;
    }

    public void setDefaultTransactionTimeoutSeconds(int defaultTransactionTimeoutSeconds) {
        this.defaultTransactionTimeoutSeconds = defaultTransactionTimeoutSeconds;
    }

    public TransactionLog getTransactionLog() {
        if (this.transactionLog == null) {
            this.transactionLog = new UnrecoverableLog();
        }
        return this.transactionLog;
    }

    public void setTransactionLog(TransactionLog transactionLog) {
        this.transactionLog = transactionLog;
    }

    public ReferenceCollection getResourceManagers() {
        return this.resourceManagers;
    }

    public void setResourceManagers(ReferenceCollection resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    protected TransactionContextManager createTransactionContextManager() throws XAException {
        return new TransactionContextManager(this.getTransactionManager(), this.getXidImporter());
    }

    protected GeronimoWorkManager createWorkManager() throws XAException {
        return new GeronimoWorkManager(this.getThreadPoolSize(), this.getTransactionContextManager());
    }
}

