/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class SinglePoolConnectionInterceptor
extends AbstractSinglePoolConnectionInterceptor {
    private boolean selectOneAssumeMatch;
    private PoolDeque pool;

    public SinglePoolConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes, boolean selectOneAssumeMatch) {
        super(next, maxSize, minSize, blockingTimeoutMilliseconds, idleTimeoutMinutes);
        this.pool = new PoolDeque(maxSize);
        this.selectOneAssumeMatch = selectOneAssumeMatch;
    }

    protected void internalGetConnection(ConnectionInfo connectionInfo) throws ResourceException {
        PoolDeque poolDeque = this.pool;
        synchronized (poolDeque) {
            if (this.destroyed) {
                throw new ResourceException("ManagedConnection pool has been destroyed");
            }
            ManagedConnectionInfo newMCI = null;
            if (this.pool.isEmpty()) {
                this.next.getConnection(connectionInfo);
                ++this.connectionCount;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Returning new connection " + connectionInfo.getManagedConnectionInfo()));
                }
                return;
            }
            newMCI = this.pool.removeLast();
            if (this.connectionCount < this.minSize) {
                this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
            }
            if (this.selectOneAssumeMatch) {
                connectionInfo.setManagedConnectionInfo(newMCI);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Returning pooled connection without checking matching " + connectionInfo.getManagedConnectionInfo()));
                }
                return;
            }
            try {
                ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
                ManagedConnection matchedMC = newMCI.getManagedConnectionFactory().matchManagedConnections(Collections.singleton(newMCI.getManagedConnection()), mci.getSubject(), mci.getConnectionRequestInfo());
                if (matchedMC != null) {
                    connectionInfo.setManagedConnectionInfo(newMCI);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Returning pooled connection " + connectionInfo.getManagedConnectionInfo()));
                    }
                    return;
                }
                ConnectionInfo returnCI = new ConnectionInfo();
                returnCI.setManagedConnectionInfo(newMCI);
                this.returnConnection(returnCI, ConnectionReturnAction.RETURN_HANDLE);
                throw new ResourceException("The pooling strategy does not match the MatchManagedConnections implementation.  Please investigate and reconfigure this pool");
            }
            catch (ResourceException e) {
                ConnectionInfo returnCI = new ConnectionInfo();
                returnCI.setManagedConnectionInfo(newMCI);
                this.returnConnection(returnCI, ConnectionReturnAction.DESTROY);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalDestroy() {
        PoolDeque poolDeque = this.pool;
        synchronized (poolDeque) {
            while (!this.pool.isEmpty()) {
                ManagedConnection mc = this.pool.removeLast().getManagedConnection();
                if (mc == null) continue;
                try {
                    mc.destroy();
                }
                catch (ResourceException resourceException) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ManagedConnection mc = mci.getManagedConnection();
        try {
            mc.cleanup();
        }
        catch (ResourceException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        boolean wasInPool = false;
        PoolDeque poolDeque = this.pool;
        synchronized (poolDeque) {
            if (this.destroyed) {
                try {
                    mc.destroy();
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                return this.pool.remove(mci);
            }
            if (this.shrinkLater > 0) {
                connectionReturnAction = ConnectionReturnAction.DESTROY;
                --this.shrinkLater;
            } else {
                if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE) {
                    mci.setLastUsed(System.currentTimeMillis());
                    this.pool.add(mci);
                    return wasInPool;
                }
                wasInPool = this.pool.remove(mci);
            }
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        --this.connectionCount;
        return wasInPool;
    }

    public int getPartitionMaxSize() {
        return this.pool.capacity();
    }

    protected void transferConnections(int maxSize, int shrinkNow) {
        int i;
        PoolDeque oldPool = this.pool;
        this.pool = new PoolDeque(maxSize);
        for (i = 0; i < shrinkNow; ++i) {
            ConnectionInfo killInfo = new ConnectionInfo(oldPool.peek(i));
            this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
        }
        for (i = shrinkNow; i < this.connectionCount; ++i) {
            this.pool.add(oldPool.peek(i));
        }
    }

    public int getIdleConnectionCount() {
        return this.pool.currentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getExpiredManagedConnectionInfos(long threshold, ArrayList killList) {
        PoolDeque poolDeque = this.pool;
        synchronized (poolDeque) {
            for (int i = 0; i < this.pool.currentSize(); ++i) {
                ManagedConnectionInfo mci = this.pool.peek(i);
                if (mci.getLastUsed() >= threshold) continue;
                killList.add(mci);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addToPool(ManagedConnectionInfo mci) {
        boolean added;
        PoolDeque poolDeque = this.pool;
        synchronized (poolDeque) {
            ++this.connectionCount;
            boolean bl = added = this.getPartitionMaxSize() > this.getIdleConnectionCount();
            if (added) {
                this.pool.add(mci);
            }
        }
        return added;
    }

    static class PoolDeque {
        private final ManagedConnectionInfo[] deque;
        private final int first = 0;
        private int last = -1;

        public PoolDeque(int size) {
            this.deque = new ManagedConnectionInfo[size];
        }

        public boolean isEmpty() {
            return 0 > this.last;
        }

        public void add(ManagedConnectionInfo mci) {
            if (this.last == this.deque.length - 1) {
                throw new IllegalStateException("deque is full: contents: " + Arrays.asList(this.deque));
            }
            this.deque[++this.last] = mci;
        }

        public ManagedConnectionInfo peek(int i) {
            if (i < 0 || i > this.last) {
                throw new IllegalStateException("index is out of current range");
            }
            return this.deque[i];
        }

        public ManagedConnectionInfo removeLast() {
            if (this.isEmpty()) {
                throw new IllegalStateException("deque is empty");
            }
            return this.deque[this.last--];
        }

        public boolean remove(ManagedConnectionInfo mci) {
            for (int i = 0; i <= this.last; ++i) {
                if (this.deque[i] != mci) continue;
                for (int j = i + 1; j <= this.last; ++j) {
                    this.deque[j - 1] = this.deque[j];
                }
                --this.last;
                return true;
            }
            return false;
        }

        public int capacity() {
            return this.deque.length;
        }

        public int currentSize() {
            return this.last - 0 + 1;
        }
    }
}

