/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.transaction.ConnectionReleaser;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class TransactionCachingInterceptor
implements ConnectionInterceptor,
ConnectionReleaser {
    private final ConnectionInterceptor next;
    private final TransactionContextManager transactionContextManager;

    public TransactionCachingInterceptor(ConnectionInterceptor next, TransactionContextManager transactionContextManager) {
        this.next = next;
        this.transactionContextManager = transactionContextManager;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        TransactionContext transactionContext = this.transactionContextManager.getContext();
        if (transactionContext != null && transactionContext.isInheritable() && transactionContext.isActive()) {
            ManagedConnectionInfos managedConnectionInfos = (ManagedConnectionInfos)transactionContext.getManagedConnectionInfo(this);
            if (managedConnectionInfos == null) {
                managedConnectionInfos = new ManagedConnectionInfos();
                transactionContext.setManagedConnectionInfo(this, managedConnectionInfos);
            }
            if (connectionInfo.isUnshareable()) {
                if (!managedConnectionInfos.containsUnshared(connectionInfo.getManagedConnectionInfo())) {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.addUnshared(connectionInfo.getManagedConnectionInfo());
                }
            } else {
                ManagedConnectionInfo managedConnectionInfo = managedConnectionInfos.getShared();
                if (managedConnectionInfo != null) {
                    connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                    return;
                }
                this.next.getConnection(connectionInfo);
                managedConnectionInfos.setShared(connectionInfo.getManagedConnectionInfo());
            }
        } else {
            this.next.getConnection(connectionInfo);
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionReturnAction == ConnectionReturnAction.DESTROY) {
            this.next.returnConnection(connectionInfo, connectionReturnAction);
            return;
        }
        TransactionContext transactionContext = this.transactionContextManager.getContext();
        if (transactionContext != null && transactionContext.isInheritable() && transactionContext.isActive()) {
            return;
        }
        this.internalReturn(connectionInfo, connectionReturnAction);
    }

    private void internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionInfo.getManagedConnectionInfo().hasConnectionHandles()) {
            return;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void destroy() {
        this.next.destroy();
    }

    public void afterCompletion(Object stuff) {
        ManagedConnectionInfos managedConnectionInfos = (ManagedConnectionInfos)stuff;
        ManagedConnectionInfo sharedMCI = managedConnectionInfos.getShared();
        if (sharedMCI != null) {
            this.returnHandle(sharedMCI);
        }
        Iterator iterator = managedConnectionInfos.getUnshared().iterator();
        while (iterator.hasNext()) {
            ManagedConnectionInfo managedConnectionInfo = (ManagedConnectionInfo)iterator.next();
            this.returnHandle(managedConnectionInfo);
        }
    }

    private void returnHandle(ManagedConnectionInfo managedConnectionInfo) {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
        this.internalReturn(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
    }

    static class ManagedConnectionInfos {
        private ManagedConnectionInfo shared;
        private Set unshared = Collections.EMPTY_SET;

        ManagedConnectionInfos() {
        }

        public ManagedConnectionInfo getShared() {
            return this.shared;
        }

        public void setShared(ManagedConnectionInfo shared) {
            this.shared = shared;
        }

        public Set getUnshared() {
            return this.unshared;
        }

        public void addUnshared(ManagedConnectionInfo unsharedMCI) {
            if (this.unshared == Collections.EMPTY_SET) {
                this.unshared = new HashSet();
            }
            this.unshared.add(unsharedMCI);
        }

        public boolean containsUnshared(ManagedConnectionInfo unsharedMCI) {
            return this.unshared.contains(unsharedMCI);
        }
    }
}

