/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.ConnectionReleaser;
import org.apache.geronimo.transaction.DoubleKeyedHashMap;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.context.Flushable;
import org.apache.geronimo.transaction.context.TransactionContext;

abstract class AbstractTransactionContext
implements TransactionContext {
    protected static final Log log = LogFactory.getLog((Class)AbstractTransactionContext.class);
    protected Map managedConnections;
    private InstanceContext currentContext;
    private final DoubleKeyedHashMap associatedContexts = new DoubleKeyedHashMap();
    private final DoubleKeyedHashMap dirtyContexts = new DoubleKeyedHashMap();
    private Flushable inTxCache;

    AbstractTransactionContext() {
    }

    public final void associate(InstanceContext context) throws Throwable {
        if (this.associatedContexts.put(context.getContainerId(), context.getId(), context) == null) {
            context.associate();
        }
    }

    public final void unassociate(InstanceContext context) throws Throwable {
        this.associatedContexts.remove(context.getContainerId(), context.getId());
        context.unassociate();
    }

    public final void unassociate(Object containerId, Object id) throws Throwable {
        InstanceContext context = (InstanceContext)this.associatedContexts.remove(containerId, id);
        if (context != null) {
            context.unassociate();
        }
    }

    public final InstanceContext getContext(Object containerId, Object id) {
        return (InstanceContext)this.associatedContexts.get(containerId, id);
    }

    protected final ArrayList getAssociatedContexts() {
        return new ArrayList(this.associatedContexts.values());
    }

    protected final void unassociateAll() {
        ArrayList toFlush = this.getAssociatedContexts();
        Iterator i = toFlush.iterator();
        while (i.hasNext()) {
            InstanceContext context = (InstanceContext)i.next();
            try {
                context.unassociate();
            }
            catch (Throwable throwable) {
                log.warn((Object)("Error while unassociating instance from transaction context: " + context), throwable);
            }
        }
    }

    public final InstanceContext beginInvocation(InstanceContext context) throws Throwable {
        if (context.getId() != null) {
            this.associate(context);
            this.dirtyContexts.put(context.getContainerId(), context.getId(), context);
        }
        context.enter();
        InstanceContext caller = this.currentContext;
        this.currentContext = context;
        return caller;
    }

    public final void endInvocation(InstanceContext caller) {
        if (this.currentContext != null) {
            this.currentContext.exit();
        }
        this.currentContext = caller;
    }

    public final void flushState() throws Throwable {
        while (!this.dirtyContexts.isEmpty()) {
            ArrayList toFlush = new ArrayList(this.dirtyContexts.values());
            this.dirtyContexts.clear();
            Iterator i = toFlush.iterator();
            while (i.hasNext()) {
                InstanceContext context = (InstanceContext)i.next();
                if (context.isDead()) continue;
                context.flush();
            }
        }
        if (this.currentContext != null && this.currentContext.getId() != null) {
            this.dirtyContexts.put(this.currentContext.getContainerId(), this.currentContext.getId(), this.currentContext);
        }
        if (this.inTxCache != null) {
            this.inTxCache.flush();
        }
    }

    public final void setInTxCache(Flushable inTxCache) {
        this.inTxCache = inTxCache;
    }

    public final Flushable getInTxCache() {
        return this.inTxCache;
    }

    public void setManagedConnectionInfo(ConnectionReleaser key, Object info) {
        if (this.managedConnections == null) {
            this.managedConnections = new HashMap();
        }
        this.managedConnections.put(key, info);
    }

    public Object getManagedConnectionInfo(ConnectionReleaser key) {
        if (this.managedConnections == null) {
            return null;
        }
        return this.managedConnections.get(key);
    }
}

