/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.ConnectionReleaser;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.context.AbstractTransactionContext;

abstract class InheritableTransactionContext
extends AbstractTransactionContext {
    private final ExtendedTransactionManager txnManager;
    private Transaction transaction;
    private boolean threadAssociated = false;

    protected InheritableTransactionContext(ExtendedTransactionManager txnManager) {
        this.txnManager = txnManager;
    }

    protected InheritableTransactionContext(ExtendedTransactionManager txnManager, Transaction transaction) {
        this.txnManager = txnManager;
        this.transaction = transaction;
    }

    void begin(long transactionTimeoutMilliseconds) throws SystemException, NotSupportedException {
        if (this.transaction != null) {
            throw new SystemException("Context is already associated with a transaction");
        }
        this.transaction = this.txnManager.begin(transactionTimeoutMilliseconds);
        this.threadAssociated = true;
    }

    boolean isThreadAssociated() {
        return this.threadAssociated;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isInheritable() {
        return true;
    }

    public boolean isActive() {
        if (this.transaction == null) {
            return false;
        }
        try {
            int status = this.transaction.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        return this.transaction.enlistResource(xaResource);
    }

    public boolean delistResource(XAResource xaResource, int flag) throws SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        boolean success = this.transaction.delistResource(xaResource, flag);
        if (!success) {
            this.transaction.setRollbackOnly();
        }
        return success;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        this.transaction.registerSynchronization(synchronization);
    }

    public boolean getRollbackOnly() throws SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        int status = this.transaction.getStatus();
        return status == 1 || status == 4 || status == 9;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        this.transaction.setRollbackOnly();
    }

    public void suspend() throws SystemException {
        Transaction suspendedTransaction = this.txnManager.suspend();
        if (this.transaction != suspendedTransaction) {
            throw new SystemException("Suspend did not return our transaction: expectedTx=" + this.transaction + ", suspendedTx=" + suspendedTransaction);
        }
        this.threadAssociated = false;
    }

    public void resume() throws SystemException, InvalidTransactionException {
        this.txnManager.resume(this.transaction);
        this.threadAssociated = true;
    }

    public boolean commit() throws HeuristicMixedException, HeuristicRollbackException, SystemException, RollbackException {
        return this.complete();
    }

    public void rollback() throws SystemException {
        this.setRollbackOnly();
        try {
            this.complete();
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw (SystemException)new SystemException("After commit of container transaction failed").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean complete() throws HeuristicMixedException, HeuristicRollbackException, SystemException, RollbackException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        boolean wasCommitted = false;
        try {
            if (this.isRolledback()) {
                boolean bl = false;
                return bl;
            }
            this.flushState();
            if (this.isRolledback()) {
                boolean bl = false;
                return bl;
            }
            this.beforeCommit();
            if (this.isRolledback()) {
                boolean bl = false;
                return bl;
            }
            Transaction currentTransaction = this.txnManager.getTransaction();
            if (currentTransaction != this.transaction) {
                throw new SystemException("An unknown transaction is currently associated with the thread: expectedTx=" + this.transaction + ", currentTx=" + currentTransaction);
            }
            this.txnManager.commit();
            wasCommitted = true;
            return wasCommitted;
        }
        catch (Throwable t) {
            this.rollbackAndThrow("Unable to commit container transaction", t);
            return wasCommitted;
        }
        finally {
            this.transaction = null;
            try {
                this.afterCommit(wasCommitted);
            }
            catch (Throwable e) {
                this.rollbackAndThrow("After commit of container transaction failed", e);
            }
            finally {
                this.unassociateAll();
                this.connectorAfterCommit();
                this.threadAssociated = false;
            }
        }
    }

    private void beforeCommit() throws Throwable {
        ArrayList toFlush = this.getAssociatedContexts();
        Iterator i = toFlush.iterator();
        while (i.hasNext()) {
            InstanceContext context = (InstanceContext)i.next();
            if (context.isDead()) continue;
            context.beforeCommit();
        }
    }

    private void afterCommit(boolean status) throws Throwable {
        Throwable firstThrowable = null;
        ArrayList toFlush = this.getAssociatedContexts();
        Iterator i = toFlush.iterator();
        while (i.hasNext()) {
            InstanceContext context = (InstanceContext)i.next();
            if (context.isDead()) continue;
            try {
                context.afterCommit(status);
            }
            catch (Throwable e) {
                if (firstThrowable != null) continue;
                firstThrowable = e;
            }
        }
        if (firstThrowable instanceof Error) {
            throw (Error)firstThrowable;
        }
        if (firstThrowable instanceof Exception) {
            throw (Exception)firstThrowable;
        }
        if (firstThrowable != null) {
            throw (SystemException)new SystemException().initCause(firstThrowable);
        }
    }

    private void connectorAfterCommit() {
        if (this.managedConnections != null) {
            Iterator entries = this.managedConnections.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                ConnectionReleaser key = (ConnectionReleaser)entry.getKey();
                key.afterCompletion(entry.getValue());
            }
            this.managedConnections.clear();
        }
    }

    private boolean isRolledback() throws SystemException {
        int status;
        try {
            status = this.transaction.getStatus();
        }
        catch (SystemException e) {
            this.transaction.rollback();
            throw e;
        }
        if (status == 1) {
            Transaction currentTransaction = this.txnManager.getTransaction();
            if (currentTransaction != this.transaction) {
                throw new SystemException("An unknown transaction is currently associated with the thread: expectedTx=" + this.transaction + ", currentTx=" + currentTransaction);
            }
            this.txnManager.rollback();
            return true;
        }
        return status == 4 || status == 9;
    }

    private void rollbackAndThrow(String message, Throwable throwable) throws HeuristicMixedException, HeuristicRollbackException, SystemException, RollbackException {
        try {
            if (this.txnManager.getStatus() != 6) {
                this.txnManager.rollback();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unable to roll back transaction", t);
        }
        try {
            int status = this.transaction.getStatus();
            if (status != 4 && status != 9) {
                this.transaction.rollback();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unable to roll back transaction", t);
        }
        if (throwable instanceof HeuristicMixedException) {
            throw (HeuristicMixedException)throwable;
        }
        if (throwable instanceof HeuristicRollbackException) {
            throw (HeuristicRollbackException)throwable;
        }
        if (throwable instanceof RollbackException) {
            throw (RollbackException)throwable;
        }
        if (throwable instanceof SystemException) {
            throw (SystemException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw (SystemException)new SystemException(message).initCause(throwable);
    }
}

