/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.DataSource;
import org.tranql.connector.jdbc.ManagedJDBCConnection;

public abstract class AbstractLocalDataSourceMCF
implements UserPasswordManagedConnectionFactory {
    protected final javax.sql.DataSource dataSource;
    private final ExceptionSorter exceptionSorter;
    private final boolean commitBeforeAutocommit;

    protected AbstractLocalDataSourceMCF(javax.sql.DataSource xaDataSource, ExceptionSorter exceptionSorter, boolean commitBeforeAutocommit) {
        this.dataSource = xaDataSource;
        this.exceptionSorter = exceptionSorter;
        this.commitBeforeAutocommit = commitBeforeAutocommit;
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new DataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        Connection jdbcConnection = this.getPhysicalConnection(subject, credentialExtractor);
        return new ManagedJDBCConnection(this, jdbcConnection, credentialExtractor, this.exceptionSorter, this.commitBeforeAutocommit);
    }

    protected Connection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            return this.dataSource.getConnection(credentialExtractor.getUserName(), credentialExtractor.getPassword());
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.dataSource, e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ManagedConnectionHandle mc;
            Object o = i.next();
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.dataSource.getLogWriter();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), e);
        }
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        try {
            this.dataSource.setLogWriter(log);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), e);
        }
    }

    public Integer getLoginTimeout() {
        int timeout;
        try {
            timeout = this.dataSource.getLoginTimeout();
        }
        catch (SQLException e) {
            timeout = 0;
        }
        return new Integer(timeout);
    }

    public void setLoginTimeout(Integer timeout) throws ResourceException {
        try {
            this.dataSource.setLoginTimeout(timeout);
        }
        catch (SQLException e) {
            throw new InvalidPropertyException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractLocalDataSourceMCF) {
            AbstractLocalDataSourceMCF other = (AbstractLocalDataSourceMCF)obj;
            return this.dataSource.equals(other.dataSource);
        }
        return false;
    }

    public int hashCode() {
        return this.dataSource.hashCode();
    }

    public String toString() {
        return "AbstractXADataSourceMCF[" + this.dataSource + "]";
    }
}

