/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.tranql.connector.AbstractManagedConnection;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.JDBCDriverMCF;

public class ManagedXAConnection
extends AbstractManagedConnection {
    private final CredentialExtractor credentialExtractor;
    private final AbstractManagedConnection.LocalTransactionImpl localTx;
    private final AbstractManagedConnection.LocalTransactionImpl localClientTx;
    private final XAConnection xaConnection;
    private final XAResource xaResource;

    public ManagedXAConnection(ManagedConnectionFactory mcf, XAConnection xaConnection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) throws SQLException {
        this(mcf, xaConnection, xaConnection.getXAResource(), xaConnection.getConnection(), credentialExtractor, exceptionSorter);
    }

    public ManagedXAConnection(ManagedConnectionFactory mcf, XAConnection xaConnection, XAResource xaResource, Connection connection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) throws SQLException {
        super(mcf, connection, exceptionSorter);
        this.xaConnection = xaConnection;
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
                SQLException e = event.getSQLException();
                ManagedXAConnection.this.unfilteredConnectionError(e);
            }
        });
        this.xaResource = xaResource;
        this.credentialExtractor = credentialExtractor;
        this.localTx = new AbstractManagedConnection.LocalTransactionImpl(true);
        this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl(false);
    }

    public boolean matches(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException {
        return this.credentialExtractor.matches(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)mcf);
    }

    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to disable autoCommit", e);
        }
        super.localTransactionStart(isSPI);
    }

    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            if (this.mcf instanceof JDBCDriverMCF && ((JDBCDriverMCF)this.mcf).isCommitBeforeAutocommit() != null && ((JDBCDriverMCF)this.mcf).isCommitBeforeAutocommit().booleanValue()) {
                c.commit();
            }
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            block5: {
                try {
                    c.rollback();
                }
                catch (SQLException e1) {
                    if (this.log == null) break block5;
                    e.printStackTrace(this.log);
                }
            }
            throw new LocalTransactionException("Unable to commit", e);
        }
        super.localTransactionCommit(isSPI);
    }

    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.rollback();
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to rollback", e);
        }
        super.localTransactionRollback(isSPI);
        try {
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", e);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xaResource;
    }

    public void cleanup() throws ResourceException {
        super.cleanup();
        Connection c = (Connection)this.physicalConnection;
        try {
            if (!c.getAutoCommit()) {
                c.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ResourceException("Could not reset autocommit when returning to pool", e);
        }
    }

    protected void closePhysicalConnection() throws ResourceException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", e);
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }
}

