/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.JSR154Filter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletOut;
import org.mortbay.jetty.servlet.ServletWriter;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringMap;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;
import org.mortbay.util.WriterOutputStream;

public class Dispatcher
implements RequestDispatcher {
    static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$Dispatcher == null ? (class$org$mortbay$jetty$servlet$Dispatcher = Dispatcher.class$("org.mortbay.jetty.servlet.Dispatcher")) : class$org$mortbay$jetty$servlet$Dispatcher));
    public static final String __INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String __INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String __FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String __FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String __FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String __FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final StringMap __managedAttributes = new StringMap();
    ServletHandler _servletHandler;
    ServletHolder _holder = null;
    String _pathSpec;
    String _uriInContext;
    String _pathInContext;
    String _query;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$Dispatcher;

    Dispatcher(ServletHandler servletHandler, String uriInContext, String pathInContext, String query, Map.Entry entry) throws IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dispatcher for " + servletHandler + "," + uriInContext + "," + query));
        }
        this._servletHandler = servletHandler;
        this._uriInContext = uriInContext;
        this._pathInContext = pathInContext;
        this._query = query;
        this._pathSpec = (String)entry.getKey();
        this._holder = (ServletHolder)entry.getValue();
    }

    Dispatcher(ServletHandler servletHandler, String name) throws IllegalStateException {
        this._servletHandler = servletHandler;
        this._holder = this._servletHandler.getServletHolder(name);
        if (this._holder == null) {
            throw new IllegalStateException("No named servlet handler in context");
        }
    }

    public boolean isNamed() {
        return this._pathInContext == null;
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 4);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 2);
    }

    void error(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(ServletRequest servletRequest, ServletResponse servletResponse, int filterType) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpConnection httpConnection = this._servletHandler.getHttpContext().getHttpConnection();
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)httpConnection.getRequest().getWrapper();
        DispatcherRequest request = new DispatcherRequest(httpServletRequest, servletHttpRequest, filterType);
        DispatcherResponse response = new DispatcherResponse(request, httpServletResponse);
        if (filterType == 2) {
            servletResponse.resetBuffer();
        }
        String query = this._query;
        MultiMap parameters = null;
        if (query != null) {
            parameters = new MultiMap();
            UrlEncoded.decodeTo(query, parameters, request.getCharacterEncoding());
            request.addParameters(parameters);
        }
        Object old_scope = null;
        try {
            if (request.crossContext()) {
                old_scope = this._servletHandler.getHttpContext().enterContextScope(httpConnection.getRequest(), httpConnection.getResponse());
            }
            if (this.isNamed()) {
                if (this._servletHandler instanceof WebApplicationHandler) {
                    JSR154Filter filter = ((WebApplicationHandler)this._servletHandler).getJsr154Filter();
                    if (filter != null && filter.isUnwrappedDispatchSupported()) {
                        filter.setDispatch(request, response);
                        this._servletHandler.dispatch(null, httpServletRequest, httpServletResponse, this._holder);
                    } else {
                        this._servletHandler.dispatch(null, (HttpServletRequest)request, (HttpServletResponse)response, this._holder);
                    }
                } else {
                    this._servletHandler.dispatch(null, (HttpServletRequest)request, (HttpServletResponse)response, this._holder);
                }
            } else {
                String oldQ = httpServletRequest.getQueryString();
                if (oldQ != null && oldQ.length() > 0) {
                    query = query == null ? oldQ : query + "&" + oldQ;
                }
                request.setPaths(this._servletHandler.getHttpContext().getContextPath(), PathMap.pathMatch(this._pathSpec, this._pathInContext), PathMap.pathInfo(this._pathSpec, this._pathInContext), query);
                if (this._servletHandler instanceof WebApplicationHandler) {
                    JSR154Filter filter = ((WebApplicationHandler)this._servletHandler).getJsr154Filter();
                    if (filter != null && filter.isUnwrappedDispatchSupported()) {
                        filter.setDispatch(request, response);
                        this._servletHandler.dispatch(this._pathInContext, httpServletRequest, httpServletResponse, this._holder);
                    } else {
                        this._servletHandler.dispatch(this._pathInContext, (HttpServletRequest)request, (HttpServletResponse)response, this._holder);
                    }
                } else {
                    this._servletHandler.dispatch(this._pathInContext, (HttpServletRequest)request, (HttpServletResponse)response, this._holder);
                }
                if (filterType != 4) {
                    response.close();
                } else if (response.isFlushNeeded()) {
                    response.flushBuffer();
                }
            }
        }
        finally {
            if (request.crossContext()) {
                this._servletHandler.getHttpContext().leaveContextScope(httpConnection.getRequest(), httpConnection.getResponse(), old_scope);
            }
        }
    }

    public String toString() {
        return "Dispatcher[" + this._pathSpec + "," + this._holder + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        __managedAttributes.put(__INCLUDE_REQUEST_URI, (Object)__INCLUDE_REQUEST_URI);
        __managedAttributes.put(__INCLUDE_CONTEXT_PATH, (Object)__INCLUDE_CONTEXT_PATH);
        __managedAttributes.put(__INCLUDE_SERVLET_PATH, (Object)__INCLUDE_SERVLET_PATH);
        __managedAttributes.put(__INCLUDE_PATH_INFO, (Object)__INCLUDE_PATH_INFO);
        __managedAttributes.put(__INCLUDE_QUERY_STRING, (Object)__INCLUDE_QUERY_STRING);
        __managedAttributes.put(__FORWARD_REQUEST_URI, (Object)__FORWARD_REQUEST_URI);
        __managedAttributes.put(__FORWARD_CONTEXT_PATH, (Object)__FORWARD_CONTEXT_PATH);
        __managedAttributes.put(__FORWARD_SERVLET_PATH, (Object)__FORWARD_SERVLET_PATH);
        __managedAttributes.put(__FORWARD_PATH_INFO, (Object)__FORWARD_PATH_INFO);
        __managedAttributes.put(__FORWARD_QUERY_STRING, (Object)__FORWARD_QUERY_STRING);
    }

    private class DontCloseServletOut
    extends ServletOut {
        DontCloseServletOut(ServletOutputStream output) {
            super((OutputStream)output);
        }

        public void close() throws IOException {
        }
    }

    private class DontCloseWriter
    extends PrintWriter {
        DontCloseWriter(PrintWriter writer) {
            super(writer);
        }

        public void close() {
        }
    }

    class DispatcherResponse
    extends HttpServletResponseWrapper {
        DispatcherRequest _request;
        private ServletOutputStream _out = null;
        private PrintWriter _writer = null;
        private boolean _flushNeeded = false;
        private boolean _include;

        DispatcherResponse(DispatcherRequest request, HttpServletResponse response) {
            super(response);
            this._request = request;
            this._include = this._request._filterType == 4;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._writer != null) {
                throw new IllegalStateException("getWriter called");
            }
            if (this._out == null) {
                try {
                    this._out = super.getOutputStream();
                }
                catch (IllegalStateException e) {
                    LogSupport.ignore(log, e);
                    this._flushNeeded = true;
                    this._out = new ServletOut(new WriterOutputStream(super.getWriter()));
                }
            }
            if (this._include) {
                this._out = new DontCloseServletOut(this._out);
            }
            return this._out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._out != null) {
                throw new IllegalStateException("getOutputStream called");
            }
            if (this._writer == null) {
                try {
                    this._writer = super.getWriter();
                }
                catch (IllegalStateException e) {
                    LogSupport.ignore(log, e);
                    this._flushNeeded = true;
                    this._writer = new ServletWriter((OutputStream)super.getOutputStream(), this.getCharacterEncoding());
                }
            }
            if (this._include) {
                this._writer = new DontCloseWriter(this._writer);
            }
            return this._writer;
        }

        boolean isFlushNeeded() {
            return this._flushNeeded;
        }

        public void flushBuffer() throws IOException {
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.flush();
            }
            super.flushBuffer();
        }

        public void close() throws IOException {
            if (this._writer != null) {
                this._writer.close();
            }
            if (this._out != null) {
                this._out.close();
            }
        }

        public void setLocale(Locale locale) {
            if (!this._include) {
                super.setLocale(locale);
            }
        }

        public void sendError(int status, String message) throws IOException {
            if (this._request._filterType != 8 && !this._include) {
                super.sendError(status, message);
            }
        }

        public void sendError(int status) throws IOException {
            if (this._request._filterType != 8 && !this._include) {
                super.sendError(status);
            }
        }

        public void sendRedirect(String url) throws IOException {
            if (!this._include) {
                if (!url.startsWith("http:/") && !url.startsWith("https:/")) {
                    StringBuffer buf = this._request.getRootURL();
                    if (url.startsWith("/")) {
                        buf.append(URI.canonicalPath(url));
                    } else {
                        buf.append(URI.canonicalPath(URI.addPaths(URI.parentPath(this._request.getRequestURI()), url)));
                    }
                    url = buf.toString();
                }
                super.sendRedirect(url);
            }
        }

        public void setDateHeader(String name, long value) {
            if (!this._include) {
                super.setDateHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!this._include) {
                super.setHeader(name, value);
            }
        }

        public void setIntHeader(String name, int value) {
            if (!this._include) {
                super.setIntHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (!this._include) {
                super.addHeader(name, value);
            }
        }

        public void addDateHeader(String name, long value) {
            if (!this._include) {
                super.addDateHeader(name, value);
            }
        }

        public void addIntHeader(String name, int value) {
            if (!this._include) {
                super.addIntHeader(name, value);
            }
        }

        public void setStatus(int status) {
            if (this._request._filterType != 8 && !this._include) {
                super.setStatus(status);
            }
        }

        public void setStatus(int status, String message) {
            if (this._request._filterType != 8 && !this._include) {
                super.setStatus(status, message);
            }
        }

        public void setContentLength(int len) {
            if (!this._include) {
                super.setContentLength(len);
            }
        }

        public void setContentType(String contentType) {
            if (!this._include) {
                super.setContentType(contentType);
            }
        }
    }

    class DispatcherRequest
    extends HttpServletRequestWrapper {
        int _filterType;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;
        MultiMap _parameters;
        HashMap _attributes;
        boolean _xContext;
        HttpSession _xSession;
        String _requestedSessionId;
        ServletHttpRequest _servletHttpRequest;

        DispatcherRequest(HttpServletRequest httpServletRequest, ServletHttpRequest servletHttpRequest, int filterType) {
            super(httpServletRequest);
            this._servletHttpRequest = servletHttpRequest;
            this._filterType = filterType;
            boolean bl = this._xContext = servletHttpRequest.getServletHandler() != Dispatcher.this._servletHandler;
            if (this._xContext) {
                String session_id;
                HttpSession session = httpServletRequest.getSession(false);
                String string = session_id = session == null ? httpServletRequest.getRequestedSessionId() : session.getId();
                if (session_id != null) {
                    this._xSession = Dispatcher.this._servletHandler.getHttpSession(session_id);
                    if (this._xSession != null) {
                        ((SessionManager.Session)this._xSession).access();
                    }
                }
            }
        }

        boolean crossContext() {
            return this._xContext;
        }

        void setPaths(String cp, String sp, String pi, String qs) {
            this._contextPath = cp.length() == 1 && cp.charAt(0) == '/' ? "" : cp;
            this._servletPath = sp;
            this._pathInfo = pi;
            this._query = qs;
        }

        int getFilterType() {
            return this._filterType;
        }

        String getPathInContext() {
            if (Dispatcher.this._pathInContext != null) {
                return Dispatcher.this._pathInContext;
            }
            return URI.addPaths(this.getServletPath(), this.getPathInfo());
        }

        public String getRequestURI() {
            if (this._filterType == 4 || Dispatcher.this.isNamed()) {
                return super.getRequestURI();
            }
            return URI.addPaths(this._contextPath, Dispatcher.this._uriInContext);
        }

        public StringBuffer getRequestURL() {
            if (this._filterType == 4 || Dispatcher.this.isNamed()) {
                return super.getRequestURL();
            }
            StringBuffer buf = this.getRootURL();
            if (this._contextPath.length() > 0) {
                buf.append(this._contextPath);
            }
            buf.append(Dispatcher.this._uriInContext);
            return buf;
        }

        public String getPathTranslated() {
            String info = this.getPathInfo();
            if (info == null) {
                return null;
            }
            return this.getRealPath(info);
        }

        StringBuffer getRootURL() {
            StringBuffer buf = super.getRequestURL();
            int d = 3;
            int i = 0;
            while (i < buf.length()) {
                if (buf.charAt(i) == '/' && --d == 0) {
                    buf.setLength(i);
                    break;
                }
                ++i;
            }
            return buf;
        }

        public String getContextPath() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getContextPath() : this._contextPath;
        }

        public String getServletPath() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getServletPath() : this._servletPath;
        }

        public String getPathInfo() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getPathInfo() : this._pathInfo;
        }

        public String getQueryString() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getQueryString() : this._query;
        }

        void addParameters(MultiMap parameters) {
            this._parameters = parameters;
        }

        public Enumeration getParameterNames() {
            if (this._parameters == null) {
                return super.getParameterNames();
            }
            HashSet set = new HashSet(this._parameters.keySet());
            Enumeration e = super.getParameterNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        public String getParameter(String name) {
            if (this._parameters == null) {
                return super.getParameter(name);
            }
            String value = this._parameters.getString(name);
            if (value != null) {
                return value;
            }
            return super.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            List v0 = this._parameters == null ? null : this._parameters.getValues(name);
            String[] v1 = super.getParameterValues(name);
            if (v0 == null && v1 == null) {
                return null;
            }
            String[] a = new String[(v0 == null ? 0 : v0.size()) + (v1 == null ? 0 : v1.length)];
            if (v0 == null || v0.size() == 0) {
                return v1;
            }
            if (v1 == null || v1.length == 0) {
                return v0.toArray(a);
            }
            int i = 0;
            while (i < v0.size()) {
                a[i] = (String)v0.get(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < v1.length) {
                a[v0.size() + i2] = v1[i2];
                ++i2;
            }
            return a;
        }

        public Map getParameterMap() {
            if (this._parameters == null) {
                return super.getParameterMap();
            }
            Map m0 = super.getParameterMap();
            if (m0 == null || m0.size() == 0) {
                return this._parameters.toStringArrayMap();
            }
            Enumeration p = this.getParameterNames();
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            while (p.hasMoreElements()) {
                String name = (String)p.nextElement();
                m.put(name, this.getParameterValues(name));
            }
            return m;
        }

        public void setAttribute(String name, Object value) {
            if (__managedAttributes.containsKey(name)) {
                if (this._attributes == null) {
                    this._attributes = new HashMap(3);
                }
                this._attributes.put(name, value);
            } else {
                super.setAttribute(name, value);
            }
        }

        public Object getAttribute(String name) {
            if (this._attributes != null && this._attributes.containsKey(name)) {
                return this._attributes.get(name);
            }
            if (this._filterType == 4 && !Dispatcher.this.isNamed()) {
                if (name.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (name.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return URI.addPaths(this._contextPath, Dispatcher.this._uriInContext);
                }
                if (name.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (name.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (name.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return Dispatcher.this._query;
                }
            } else {
                if (name.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return null;
                }
                if (name.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return null;
                }
                if (name.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return null;
                }
                if (name.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return null;
                }
                if (name.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return null;
                }
            }
            if (this._filterType != 4 && !Dispatcher.this.isNamed()) {
                if (name.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    return this._servletHttpRequest.getPathInfo();
                }
                if (name.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    return this._servletHttpRequest.getRequestURI();
                }
                if (name.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    return this._servletHttpRequest.getServletPath();
                }
                if (name.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    return this._servletHttpRequest.getContextPath();
                }
                if (name.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    return this._servletHttpRequest.getQueryString();
                }
            }
            return super.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            HashSet<Object> set = new HashSet<Object>();
            Enumeration e = super.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            if (this._filterType == 4 && !Dispatcher.this.isNamed()) {
                set.add(Dispatcher.__INCLUDE_PATH_INFO);
                set.add(Dispatcher.__INCLUDE_REQUEST_URI);
                set.add(Dispatcher.__INCLUDE_SERVLET_PATH);
                set.add(Dispatcher.__INCLUDE_CONTEXT_PATH);
                set.add(Dispatcher.__INCLUDE_QUERY_STRING);
            } else {
                set.remove(Dispatcher.__INCLUDE_PATH_INFO);
                set.remove(Dispatcher.__INCLUDE_REQUEST_URI);
                set.remove(Dispatcher.__INCLUDE_SERVLET_PATH);
                set.remove(Dispatcher.__INCLUDE_CONTEXT_PATH);
                set.remove(Dispatcher.__INCLUDE_QUERY_STRING);
            }
            if (this._filterType != 4 && !Dispatcher.this.isNamed()) {
                set.add(Dispatcher.__FORWARD_PATH_INFO);
                set.add(Dispatcher.__FORWARD_REQUEST_URI);
                set.add(Dispatcher.__FORWARD_SERVLET_PATH);
                set.add(Dispatcher.__FORWARD_CONTEXT_PATH);
                set.add(Dispatcher.__FORWARD_QUERY_STRING);
            }
            if (this._attributes != null) {
                set.addAll(this._attributes.keySet());
            }
            return Collections.enumeration(set);
        }

        public HttpSession getSession(boolean create) {
            if (this._xContext) {
                if (this._xSession == null) {
                    log.debug((Object)"Ctx dispatch session");
                    if (this.getAttribute("org.mortbay.jetty.servlet.Dispatcher.shared_session") != null) {
                        this._xSession = super.getSession(create);
                    } else {
                        if (this._requestedSessionId == null) {
                            this._requestedSessionId = super.getSession(true).getId();
                        }
                        this._xSession = Dispatcher.this._servletHandler.getHttpSession(this._requestedSessionId);
                        if (create && this._xSession == null) {
                            this._xSession = Dispatcher.this._servletHandler.newHttpSession((HttpServletRequest)this);
                        }
                    }
                }
                return this._xSession;
            }
            return super.getSession(create);
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public String getRequestedSessionId() {
            if (this._requestedSessionId != null) {
                return this._requestedSessionId;
            }
            return super.getRequestedSessionId();
        }

        public String getRealPath(String path) {
            return Dispatcher.this._servletHandler.getServletContext().getRealPath(path);
        }

        public RequestDispatcher getRequestDispatcher(String url) {
            if (url == null) {
                return null;
            }
            if (!url.startsWith("/")) {
                String relTo = URI.addPaths(this.getServletPath(), this.getPathInfo());
                int slash = relTo.lastIndexOf("/");
                relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
                url = URI.addPaths(relTo, url);
            }
            return Dispatcher.this._servletHandler.getServletContext().getRequestDispatcher(url);
        }

        public String getMethod() {
            if (this._filterType == 8) {
                return "GET";
            }
            return super.getMethod();
        }
    }
}

