/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.mortbay.http.ContextLoader;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLog;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.ErrorPageHandler;
import org.mortbay.util.CachedResource;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Log;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class HttpContext
implements LifeCycle,
Serializable {
    public static final String __fileClassPathAttr = "org.mortbay.http.HttpContext.FileClassPathAttribute";
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private String _contextPath;
    private List _vhosts = new ArrayList(2);
    private List _hosts = new ArrayList(2);
    private List _handlers = new ArrayList(3);
    private Map _attributes = new HashMap(3);
    private boolean _redirectNullPath = true;
    private int _maxCachedFileSize = 102400;
    private int _maxCacheSize = 0x100000;
    private boolean _statsOn = false;
    private PermissionCollection _permissions;
    private boolean _classLoaderJava2Compliant;
    private String _contextName;
    private String _classPath;
    private Map _initParams = new HashMap(11);
    private Map _errorPages;
    private UserRealm _userRealm;
    private String _realmName;
    private PathMap _constraintMap = new PathMap();
    private SecurityConstraint.Authenticator _authenticator;
    private RequestLog _requestLog;
    private Resource _resourceBase;
    private Map _mimeMap;
    private Map _encodingMap;
    private String[] _welcomes = new String[]{"welcome.html", "index.html", "index.htm", "index.jsp"};
    private transient boolean _started;
    private transient ClassLoader _parent;
    private transient ClassLoader _loader;
    private transient HttpServer _httpServer;
    private transient File _tmpDir;
    private transient Map _cache = new HashMap();
    private transient int _cacheSize;
    private transient CachedMetaData _mostRecentlyUsed;
    private transient CachedMetaData _leastRecentlyUsed;
    private transient HttpHandler[] _handlersArray;
    private transient String[] _vhostsArray;
    transient Object _statsLock = new Object[0];
    transient long _statsStartedAt;
    transient int _requests;
    transient int _requestsActive;
    transient int _requestsActiveMax;
    transient int _responses1xx;
    transient int _responses2xx;
    transient int _responses3xx;
    transient int _responses4xx;
    transient int _responses5xx;

    public HttpContext() {
        this.setAttribute("org.mortbay.http.ErrorHandler", new ErrorPageHandler());
    }

    public HttpContext(HttpServer httpServer, String contextPathSpec) {
        this();
        this.setHttpServer(httpServer);
        this.setContextPath(contextPathSpec);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._statsLock = new Object[0];
        this._cache = new HashMap();
        this.getHandlers();
        int i = 0;
        while (i < this._handlersArray.length) {
            this._handlersArray[i].initialize(this);
            ++i;
        }
    }

    public HttpConnection getHttpConnection() {
        return HttpConnection.getHttpConnection();
    }

    void setHttpServer(HttpServer httpServer) {
        this._httpServer = httpServer;
        this._contextName = null;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public static String canonicalContextPathSpec(String contextPathSpec) {
        if (contextPathSpec == null || contextPathSpec.indexOf(44) >= 0 || contextPathSpec.startsWith("*")) {
            throw new IllegalArgumentException("Illegal context spec:" + contextPathSpec);
        }
        if (!contextPathSpec.startsWith("/")) {
            contextPathSpec = '/' + contextPathSpec;
        }
        if (contextPathSpec.length() > 1) {
            if (contextPathSpec.endsWith("/")) {
                contextPathSpec = contextPathSpec + "*";
            } else if (!contextPathSpec.endsWith("/*")) {
                contextPathSpec = contextPathSpec + "/*";
            }
        }
        return contextPathSpec;
    }

    public void setContextPath(String contextPathSpec) {
        if (this._httpServer != null) {
            this._httpServer.removeMappings(this);
        }
        this._contextPath = (contextPathSpec = HttpContext.canonicalContextPathSpec(contextPathSpec)).length() > 1 ? contextPathSpec.substring(0, contextPathSpec.length() - 2) : "/";
        this._contextName = null;
        if (this._httpServer != null) {
            this._httpServer.addMappings(this);
        }
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void addVirtualHost(String hostname) {
        if (!this._vhosts.contains(hostname)) {
            this._vhosts.add(hostname);
            this._contextName = null;
            if (this._httpServer != null) {
                if (this._vhosts.size() == 1) {
                    this._httpServer.removeMapping(null, this);
                }
                this._httpServer.addMapping(hostname, this);
            }
            this._vhostsArray = null;
        }
    }

    public void removeVirtualHost(String hostname) {
        if (this._vhosts.remove(hostname)) {
            this._contextName = null;
            if (this._httpServer != null) {
                this._httpServer.removeMapping(hostname, this);
                if (this._vhosts.size() == 0) {
                    this._httpServer.addMapping(null, this);
                }
            }
            this._vhostsArray = null;
        }
    }

    public void setVirtualHosts(String[] hosts) {
        ArrayList old = new ArrayList(this._vhosts);
        int i = 0;
        while (i < hosts.length) {
            boolean existing = old.remove(hosts[i]);
            if (!existing) {
                this.addVirtualHost(hosts[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < old.size()) {
            this.removeVirtualHost((String)old.get(i2));
            ++i2;
        }
    }

    public void setHosts(String[] hosts) throws UnknownHostException {
        if (hosts == null || hosts.length == 0) {
            this._hosts = null;
        } else {
            this._hosts = new ArrayList();
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i] != null) {
                    this._hosts.add(InetAddress.getByName(hosts[i]));
                }
                ++i;
            }
        }
    }

    public String[] getHosts() {
        if (this._hosts == null || this._hosts.size() == 0) {
            return null;
        }
        String[] hosts = new String[this._hosts.size()];
        int i = 0;
        while (i < hosts.length) {
            InetAddress a = (InetAddress)this._hosts.get(i);
            if (a != null) {
                hosts[i] = a.getHostName();
            }
            ++i;
        }
        return hosts;
    }

    public String[] getVirtualHosts() {
        if (this._vhostsArray != null) {
            return this._vhostsArray;
        }
        if (this._vhosts == null) {
            this._vhostsArray = new String[0];
        } else {
            this._vhostsArray = new String[this._vhosts.size()];
            this._vhostsArray = this._vhosts.toArray(this._vhostsArray);
        }
        return this._vhostsArray;
    }

    public void setHandlers(HttpHandler[] handlers) {
        ArrayList old = new ArrayList(this._handlers);
        int i = 0;
        while (i < handlers.length) {
            boolean existing = old.remove(handlers[i]);
            if (!existing) {
                this.addHandler(handlers[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < old.size()) {
            this.removeHandler((HttpHandler)old.get(i2));
            ++i2;
        }
    }

    public HttpHandler[] getHandlers() {
        if (this._handlersArray != null) {
            return this._handlersArray;
        }
        if (this._handlers == null) {
            this._handlersArray = new HttpHandler[0];
        } else {
            this._handlersArray = new HttpHandler[this._handlers.size()];
            this._handlersArray = this._handlers.toArray(this._handlersArray);
        }
        return this._handlersArray;
    }

    public synchronized void addHandler(int i, HttpHandler handler) {
        this._handlers.add(i, handler);
        this._handlersArray = null;
        HttpContext context = handler.getHttpContext();
        if (context == null) {
            handler.initialize(this);
        } else if (context != this) {
            throw new IllegalArgumentException("Handler already initialized in another HttpContext");
        }
    }

    public synchronized void addHandler(HttpHandler handler) {
        this.addHandler(this._handlers.size(), handler);
    }

    public int getHandlerIndex(HttpHandler handler) {
        int h = 0;
        while (h < this._handlers.size()) {
            if (handler == this._handlers.get(h)) {
                return h;
            }
            ++h;
        }
        return -1;
    }

    public synchronized HttpHandler getHandler(Class handlerClass) {
        int h = 0;
        while (h < this._handlers.size()) {
            HttpHandler handler = (HttpHandler)this._handlers.get(h);
            if (handlerClass.isInstance(handler)) {
                return handler;
            }
            ++h;
        }
        return null;
    }

    public synchronized HttpHandler removeHandler(int i) {
        HttpHandler handler = this._handlersArray[i];
        if (handler.isStarted()) {
            try {
                handler.stop();
            }
            catch (InterruptedException e) {
                Code.warning(e);
            }
        }
        this._handlers.remove(i);
        this._handlersArray = null;
        return handler;
    }

    public synchronized void removeHandler(HttpHandler handler) {
        if (handler.isStarted()) {
            try {
                handler.stop();
            }
            catch (InterruptedException e) {
                Code.warning(e);
            }
        }
        this._handlers.remove(handler);
        this._handlersArray = null;
    }

    public void setInitParameter(String param, String value) {
        this._initParams.put(param, value);
    }

    public String getInitParameter(String param) {
        return (String)this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public synchronized void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map getAttributes() {
        return this._attributes;
    }

    public void setAttributes(Map attributes) {
        this._attributes = attributes;
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public synchronized void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public String getResourceBase() {
        if (this._resourceBase == null) {
            return null;
        }
        return this._resourceBase.toString();
    }

    public void setResourceBase(String resourceBase) {
        try {
            this._resourceBase = Resource.newResource(resourceBase);
            Code.debug((Object)"resourceBase=", this._resourceBase, (Object)" for ", this);
        }
        catch (IOException e) {
            Code.debug(e);
            throw new IllegalArgumentException(resourceBase + ":" + e.toString());
        }
    }

    public Resource getBaseResource() {
        return this._resourceBase;
    }

    public void setBaseResource(Resource base) {
        this._resourceBase = base;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this._cache.clear();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this._cache.clear();
    }

    public void flushCache() {
        this._cache.clear();
        System.gc();
    }

    public String[] getWelcomeFiles() {
        return this._welcomes;
    }

    public void setWelcomeFiles(String[] welcomes) {
        this._welcomes = welcomes == null ? new String[0] : welcomes;
    }

    public void addWelcomeFile(String welcomeFile) {
        if (welcomeFile.startsWith("/") || welcomeFile.startsWith(File.separator) || welcomeFile.endsWith("/") || welcomeFile.endsWith(File.separator)) {
            Code.warning("Invalid welcome file: " + welcomeFile);
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this._welcomes));
        list.add(welcomeFile);
        this._welcomes = list.toArray(this._welcomes);
    }

    public void removeWelcomeFile(String welcomeFile) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this._welcomes));
        list.remove(welcomeFile);
        this._welcomes = list.toArray(this._welcomes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String pathInContext) throws IOException {
        if (this._resourceBase == null) {
            return null;
        }
        Resource resource = null;
        Map map = this._cache;
        synchronized (map) {
            CachedResource cached = (CachedResource)this._cache.get(pathInContext);
            if (cached != null) {
                CachedMetaData cmd;
                if (Code.verbose()) {
                    Code.debug((Object)"CACHE HIT: ", (Object)cached);
                }
                if ((cmd = (CachedMetaData)cached.getAssociate()) != null && cmd.isValid()) {
                    return cached;
                }
            }
            resource = this._resourceBase.addPath(this._resourceBase.encode(pathInContext));
            if (Code.verbose()) {
                Code.debug((Object)"CACHE MISS: ", (Object)resource);
            }
            if (resource == null) {
                return null;
            }
            if (resource.getAlias() != null) {
                Code.warning("Alias request of '" + resource.getAlias() + "' for '" + resource + "'");
                return null;
            }
            long len = resource.length();
            if (resource.exists()) {
                if (!resource.isDirectory() && pathInContext.endsWith("/")) {
                    return null;
                }
                if (resource.isDirectory()) {
                    len = resource.list() != null ? (long)(resource.list().length * 100) : 0L;
                }
                if (len > 0L && len < (long)this._maxCachedFileSize && len < (long)this._maxCacheSize) {
                    int needed = this._maxCacheSize - (int)len;
                    while (this._cacheSize > needed) {
                        this._leastRecentlyUsed.invalidate();
                    }
                    cached = resource.cache();
                    if (Code.verbose()) {
                        Code.debug((Object)"CACHED: ", (Object)resource);
                    }
                    new CachedMetaData(cached, pathInContext);
                    return cached;
                }
            }
        }
        new ResourceMetaData(resource);
        return resource;
    }

    public String getWelcomeFile(Resource resource) throws IOException {
        if (!resource.isDirectory()) {
            return null;
        }
        int i = 0;
        while (i < this._welcomes.length) {
            Resource welcome = resource.addPath(this._welcomes[i]);
            if (welcome.exists()) {
                return this._welcomes[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        this._mimeMap = mimeMap;
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i = -1;
            while (type == null) {
                if ((i = filename.indexOf(".", i + 1)) < 0 || i >= filename.length()) break;
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (String)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (String)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (String)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (String)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void setMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(extension, type);
    }

    public String getClassPath() {
        return this._classPath;
    }

    public String getFileClassPath() throws IllegalStateException {
        Object path;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Context classloader not initialized");
        }
        LinkedList<String> paths = new LinkedList<String>();
        LinkedList<ClassLoader> loaders = new LinkedList<ClassLoader>();
        while (loader != null) {
            loaders.add(0, loader);
            loader = loader.getParent();
        }
        loader = this.getClassLoader();
        if (loader instanceof ContextLoader && !((ContextLoader)loader).isJava2Compliant()) {
            loaders.remove(loader);
            loaders.add(0, loader);
        }
        int i = 0;
        while (i < loaders.size()) {
            loader = (ClassLoader)loaders.get(i);
            Code.debug((Object)"extract paths from ", (Object)loader);
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                int j = 0;
                while (j < urls.length) {
                    try {
                        path = Resource.newResource(urls[j]);
                        File file = ((Resource)path).getFile();
                        if (file != null) {
                            paths.add(file.getAbsolutePath());
                        }
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        String jcp = System.getProperty("java.class.path");
        if (jcp != null) {
            StringTokenizer tok = new StringTokenizer(jcp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                path = tok.nextToken();
                if (paths.contains(path)) continue;
                paths.add((String)path);
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(iter.next().toString());
        }
        Code.debug((Object)"fileClassPath=", (Object)buf);
        return buf.toString();
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
        if (this.isStarted()) {
            Code.warning("classpath set while started");
        }
    }

    public void setClassPaths(Resource lib, boolean append) {
        if (this.isStarted()) {
            Code.warning("classpaths set while started");
        }
        if (lib.exists() && lib.isDirectory()) {
            StringBuffer classPath = new StringBuffer();
            if (append && this.getClassPath() != null) {
                classPath.append(this._classPath);
            }
            String[] files = lib.list();
            int f = 0;
            while (files != null && f < files.length) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (fnlc.endsWith(".jar") || fnlc.endsWith(".zip")) {
                        classPath.append(classPath.length() > 0 ? "," : "");
                        classPath.append(fn.toString());
                    }
                }
                catch (Exception ex) {
                    Code.warning(ex);
                }
                ++f;
            }
            if (classPath.length() > 0) {
                this._classPath = classPath.toString();
            }
        }
    }

    public void setClassPaths(String lib, boolean append) throws IOException {
        if (this._loader != null) {
            throw new IllegalStateException("ClassLoader already initialized");
        }
        this.setClassPaths(Resource.newResource(lib), append);
    }

    public boolean isClassLoaderJava2Compliant() {
        return this._classLoaderJava2Compliant;
    }

    public void setClassLoaderJava2Compliant(boolean compliant) {
        this._classLoaderJava2Compliant = compliant;
        if (this._loader != null && this._loader instanceof ContextLoader) {
            ((ContextLoader)this._loader).setJava2Compliant(compliant);
        }
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                Code.warning(e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public File getTempDirectory() {
        if (this._tmpDir != null) {
            return this._tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof File) {
            this._tmpDir = (File)t;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this._tmpDir = new File((String)t);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    Code.debug((Object)"Converted to File ", this._tmpDir, (Object)" for ", this);
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception e) {
                Code.warning(e);
            }
        }
        File work = null;
        try {
            work = new File(System.getProperty("jetty.home"), "work");
            if (!(work.exists() && work.canWrite() && work.isDirectory())) {
                work = null;
            }
        }
        catch (Exception e) {
            Code.ignore(e);
        }
        try {
            HttpListener httpListener = this._httpServer.getListeners()[0];
            String vhost = null;
            int h = 0;
            while (vhost == null && this._vhosts != null && h < this._vhosts.size()) {
                vhost = (String)this._vhosts.get(h);
                ++h;
            }
            String host = httpListener.getHost();
            String temp = "Jetty_" + (host == null ? "" : host) + "_" + httpListener.getPort() + "_" + (vhost == null ? "" : vhost) + this.getContextPath();
            temp = temp.replace('/', '_');
            temp = temp.replace('.', '_');
            temp = temp.replace('\\', '_');
            if (work != null) {
                this._tmpDir = new File(work, temp);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), temp);
                if (this._tmpDir.exists()) {
                    Code.warning("Delete existing temp dir " + this._tmpDir + " for " + this);
                    if (!IO.delete(this._tmpDir)) {
                        Code.warning("Failed to delete temp dir " + this._tmpDir);
                    }
                    if (this._tmpDir.exists()) {
                        String old = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(temp + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        Code.warning("Can't reuse " + old + ", using " + this._tmpDir);
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (work == null) {
                this._tmpDir.deleteOnExit();
            }
            Code.debug((Object)"Created temp dir ", this._tmpDir, (Object)" for ", this);
        }
        catch (Exception e) {
            this._tmpDir = null;
            Code.ignore(e);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                Code.debug((Object)"Created temp dir ", this._tmpDir, (Object)" for ", this);
            }
            catch (IOException e) {
                Code.fail(e);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public synchronized void setClassLoader(ClassLoader loader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._loader = loader;
    }

    public synchronized ClassLoader getClassLoader() {
        return this._loader;
    }

    public synchronized void setParentClassLoader(ClassLoader loader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._parent = loader;
    }

    public ClassLoader getParentClassLoader() {
        return this._parent;
    }

    protected void initClassLoader(boolean forceContextLoader) throws MalformedURLException, IOException {
        if (this._loader == null) {
            if (this._parent == null) {
                this._parent = Thread.currentThread().getContextClassLoader();
            }
            if (this._parent == null) {
                this._parent = this.getClass().getClassLoader();
            }
            Code.debug("Init classloader from ", this._classPath, ", ", this._parent, " for ", this);
            if (forceContextLoader || this._classPath != null || this._permissions != null) {
                ContextLoader loader = new ContextLoader(this, this._classPath, this._parent, this._permissions);
                loader.setJava2Compliant(this._classLoaderJava2Compliant);
                this._loader = loader;
            } else {
                this._loader = this._parent;
            }
        }
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (this._loader == null) {
            try {
                this.initClassLoader(false);
            }
            catch (Exception e) {
                Code.warning(e);
                return null;
            }
        }
        if (className == null) {
            return null;
        }
        return this._loader.loadClass(className);
    }

    public void setErrorPage(String error, String uriInContext) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap(5);
        }
        this._errorPages.put(error, uriInContext);
    }

    public String getErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.get(error);
    }

    public String removeErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.remove(error);
    }

    public void setRealmName(String realmName) {
        this._realmName = realmName;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealm(UserRealm realm) {
        this._userRealm = realm;
    }

    public UserRealm getRealm() {
        return this._userRealm;
    }

    public SecurityConstraint.Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(SecurityConstraint.Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void addSecurityConstraint(String pathSpec, SecurityConstraint sc) {
        ArrayList<SecurityConstraint> scs = (ArrayList<SecurityConstraint>)this._constraintMap.get(pathSpec);
        if (scs == null) {
            scs = new ArrayList<SecurityConstraint>(2);
            this._constraintMap.put(pathSpec, scs);
        }
        scs.add(sc);
        Code.debug((Object)"added ", sc, (Object)" at ", pathSpec);
    }

    public boolean isAuthConstrained() {
        Iterator i = this._constraintMap.values().iterator();
        while (i.hasNext()) {
            Iterator j = ((ArrayList)i.next()).iterator();
            while (j.hasNext()) {
                SecurityConstraint sc = (SecurityConstraint)j.next();
                if (!sc.isAuthenticate()) continue;
                return true;
            }
        }
        return false;
    }

    public void clearSecurityConstraints() {
        this._constraintMap.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        UserRealm realm = this.getRealm();
        List scss = this._constraintMap.getMatches(pathInContext);
        if (scss == null) return true;
        Code.debug((Object)"Security Constraint on ", pathInContext, (Object)" against ", scss);
        int m = 0;
        while (m < scss.size()) {
            Map.Entry entry = (Map.Entry)scss.get(m);
            if (Code.verbose()) {
                Code.debug((Object)"Check ", pathInContext, (Object)" against ", entry);
            }
            List scs = (List)entry.getValue();
            switch (SecurityConstraint.check(scs, this._authenticator, realm, pathInContext, request, response)) {
                case -1: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
            }
            ++m;
        }
        return true;
    }

    public synchronized Map getEncodingMap() {
        if (this._encodingMap == null) {
            this._encodingMap = Collections.unmodifiableMap(__encodings);
        }
        return this._encodingMap;
    }

    public void setEncodingMap(Map encodingMap) {
        this._encodingMap = encodingMap;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = (String)this._encodingMap.get(type);
        }
        return encoding;
    }

    public void setTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    public void setRedirectNullPath(boolean b) {
        this._redirectNullPath = b;
    }

    public boolean isRedirectNullPath() {
        return this._redirectNullPath;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new Permissions();
        }
        this._permissions.add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String pathInContext;
        Socket s;
        Object o;
        if (!this._started) {
            return false;
        }
        if (this._hosts != null && this._hosts.size() > 0 && (o = request.getHttpConnection().getConnection()) instanceof Socket && !this._hosts.contains((s = (Socket)o).getLocalAddress())) {
            Code.debug(s.getLocalAddress(), " not in ", this._hosts);
            return false;
        }
        if (this._statsOn) {
            o = this._statsLock;
            synchronized (o) {
                ++this._requests;
                ++this._requestsActive;
                if (this._requestsActive > this._requestsActiveMax) {
                    this._requestsActiveMax = this._requestsActive;
                }
            }
        }
        if ((pathInContext = URI.canonicalPath(request.getPath())) == null) {
            throw new HttpException(400);
        }
        if (this._contextPath.length() > 1) {
            pathInContext = pathInContext.substring(this._contextPath.length());
        }
        if (this._redirectNullPath && (pathInContext == null || pathInContext.length() == 0)) {
            StringBuffer buf = request.getRequestURL();
            buf.append("/");
            String q = request.getQuery();
            if (q != null && q.length() != 0) {
                buf.append("?" + q);
            }
            response.sendRedirect(buf.toString());
            if (Code.debug()) {
                Code.debug(this + " consumed all of path " + request.getPath() + ", redirect to " + buf.toString());
            }
            return true;
        }
        String pathParams = null;
        int semi = pathInContext.lastIndexOf(59);
        if (semi >= 0) {
            int pl = pathInContext.length() - semi;
            String ep = request.getEncodedPath();
            if (';' == ep.charAt(ep.length() - pl)) {
                pathParams = pathInContext.substring(semi + 1);
                pathInContext = pathInContext.substring(0, semi);
            }
        }
        try {
            boolean bl = this.handle(pathInContext, pathParams, request, response);
            return bl;
        }
        finally {
            UserPrincipal user = request.getUserPrincipal();
            if (this._userRealm != null) {
                this._userRealm.disassociate(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        boolean bl;
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        HttpContext lastHttpContext = response.getHttpContext();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            response.setHttpContext(this);
            HttpHandler[] handlers = this.getHandlers();
            int k = 0;
            while (true) {
                if (k >= handlers.length) {
                    bl = false;
                    break;
                }
                HttpHandler handler = handlers[k];
                if (!handler.isStarted()) {
                    Code.debug(handler, " not started in ", this);
                } else {
                    Code.debug((Object)"Handler ", (Object)handler);
                    handler.handle(pathInContext, pathParams, request, response);
                    if (request.isHandled()) {
                        Code.debug((Object)"Handled by ", (Object)handler);
                        boolean bl2 = true;
                        Object var13_13 = null;
                        thread.setContextClassLoader(lastContextLoader);
                        response.setHttpContext(lastHttpContext);
                        return bl2;
                    }
                }
                ++k;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            thread.setContextClassLoader(lastContextLoader);
            response.setHttpContext(lastHttpContext);
            throw throwable;
        }
        Object var13_14 = null;
        thread.setContextClassLoader(lastContextLoader);
        response.setHttpContext(lastHttpContext);
        return bl;
    }

    public String getHttpContextName() {
        if (this._contextName == null) {
            this._contextName = (this._vhosts.size() > 1 ? this._vhosts.toString() + ":" : "") + this._contextPath;
        }
        return this._contextName;
    }

    public String toString() {
        return "HttpContext[" + this.getHttpContextName() + "]";
    }

    public String toString(boolean detail) {
        return "HttpContext[" + this.getHttpContextName() + "]" + (detail ? "=" + this._handlers : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.statsReset();
        if (this._httpServer == null) {
            throw new IllegalStateException("No server for " + this);
        }
        this.getMimeMap();
        this.getEncodingMap();
        if (this._userRealm == null && this._authenticator != null) {
            this._userRealm = this._httpServer.getRealm(this._realmName);
            if (this._userRealm == null) {
                Code.warning("No Realm: " + this._realmName);
            }
        }
        this.initClassLoader(false);
        String attr = this.getInitParameter(__fileClassPathAttr);
        if (attr != null && attr.length() > 0) {
            this.setAttribute(attr, this.getFileClassPath());
        }
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            if (this._requestLog != null) {
                this._requestLog.start();
            }
            this.startHandlers();
            Object var5_4 = null;
            thread.setContextClassLoader(lastContextLoader);
            this._started = true;
            this.getHandlers();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(lastContextLoader);
            this._started = true;
            this.getHandlers();
            throw throwable;
        }
        Log.event("Started " + this);
    }

    protected void startHandlers() throws Exception {
        MultiException mx = new MultiException();
        Iterator handlers = this._handlers.iterator();
        while (handlers.hasNext()) {
            HttpHandler handler = (HttpHandler)handlers.next();
            if (handler.isStarted()) continue;
            try {
                handler.start();
            }
            catch (Exception e) {
                mx.add(e);
            }
        }
        mx.ifExceptionThrow();
    }

    public synchronized boolean isStarted() {
        return this._started;
    }

    public void stop(boolean graceful) throws InterruptedException {
        this._started = false;
        while (graceful && this._statsOn && this._requestsActive > 0 && this._httpServer != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        this._started = false;
        if (this._httpServer == null) {
            throw new InterruptedException("Destroy called");
        }
        HttpContext httpContext = this;
        synchronized (httpContext) {
            Thread thread = Thread.currentThread();
            ClassLoader lastContextLoader = thread.getContextClassLoader();
            try {
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                Iterator handlers = this._handlers.iterator();
                while (handlers.hasNext()) {
                    HttpHandler handler = (HttpHandler)handlers.next();
                    if (!handler.isStarted()) continue;
                    try {
                        handler.stop();
                    }
                    catch (Exception e) {
                        Code.warning(e);
                    }
                }
                if (this._requestLog != null) {
                    this._requestLog.stop();
                }
                Object var8_7 = null;
                thread.setContextClassLoader(lastContextLoader);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                thread.setContextClassLoader(lastContextLoader);
                throw throwable;
            }
            this._loader = null;
        }
        this._cache.clear();
        Log.event("Stopped " + this);
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._httpServer != null) {
            this._httpServer.removeContext(this);
        }
        this._httpServer = null;
        if (this._handlers != null) {
            this._handlers.clear();
        }
        this._handlers = null;
        this._parent = null;
        this._loader = null;
        this._resourceBase = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._initParams != null) {
            this._initParams.clear();
        }
        this._initParams = null;
        if (this._vhosts != null) {
            this._vhosts.clear();
        }
        this._vhosts = null;
        this._hosts = null;
        this._tmpDir = null;
        this.setMimeMap(null);
        this._encodingMap = null;
        if (this._errorPages != null) {
            this._errorPages.clear();
        }
        this._errorPages = null;
        this._permissions = null;
    }

    public void setRequestLog(RequestLog log) {
        this._requestLog = log;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void setStatsOn(boolean on) {
        Log.event("setStatsOn " + on + " for " + this);
        this._statsOn = on;
        this.statsReset();
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public long getStatsOnMs() {
        return this._statsOn ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        Object object = this._statsLock;
        synchronized (object) {
            if (this._statsOn) {
                this._statsStartedAt = System.currentTimeMillis();
            }
            this._requests = 0;
            this._requestsActive = 0;
            this._requestsActiveMax = 0;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
        }
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public int getResponses1xx() {
        return this._responses1xx;
    }

    public int getResponses2xx() {
        return this._responses2xx;
    }

    public int getResponses3xx() {
        return this._responses3xx;
    }

    public int getResponses4xx() {
        return this._responses4xx;
    }

    public int getResponses5xx() {
        return this._responses5xx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest request, HttpResponse response, int length) {
        if (this._statsOn) {
            Object object = this._statsLock;
            synchronized (object) {
                if (--this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                if (response != null) {
                    switch (response.getStatus() / 100) {
                        case 1: {
                            ++this._responses1xx;
                            break;
                        }
                        case 2: {
                            ++this._responses2xx;
                            break;
                        }
                        case 3: {
                            ++this._responses3xx;
                            break;
                        }
                        case 4: {
                            ++this._responses4xx;
                            break;
                        }
                        case 5: {
                            ++this._responses5xx;
                        }
                    }
                }
            }
        }
        if (this._requestLog != null && request != null && response != null) {
            this._requestLog.log(request, response, length);
        } else if (this._httpServer != null) {
            this._httpServer.log(request, response, length);
        }
    }

    public ResourceMetaData getResourceMetaData(Resource resource) {
        Object o = resource.getAssociate();
        if (o instanceof ResourceMetaData) {
            return (ResourceMetaData)o;
        }
        return new ResourceMetaData(resource);
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/http/mime");
        Enumeration<String> i = mime.getKeys();
        while (i.hasMoreElements()) {
            String ext = i.nextElement();
            __dftMimeMap.put(ext, mime.getString(ext));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/http/encoding");
        i = encoding.getKeys();
        while (i.hasMoreElements()) {
            String type = i.nextElement();
            __encodings.put(type, encoding.getString(type));
        }
    }

    private class CachedMetaData
    extends ResourceMetaData {
        String _lastModified;
        String _encoding;
        String _length;
        String _key;
        CachedResource _cached;
        CachedMetaData _prev;
        CachedMetaData _next;

        CachedMetaData(CachedResource resource, String pathInContext) {
            super(resource);
            this._cached = resource;
            this._length = super.getLength();
            this._lastModified = super.getLastModified();
            this._encoding = super.getEncoding();
            this._key = pathInContext;
            this._next = HttpContext.this._mostRecentlyUsed;
            HttpContext.this._mostRecentlyUsed = this;
            if (this._next != null) {
                this._next._prev = this;
            }
            this._prev = null;
            if (HttpContext.this._leastRecentlyUsed == null) {
                HttpContext.this._leastRecentlyUsed = this;
            }
            HttpContext.this._cache.put(this._key, resource);
            HttpContext.this._cacheSize = (int)((long)HttpContext.this._cacheSize + this._cached.length());
        }

        public String getLength() {
            return this._length;
        }

        public String getLastModified() {
            return this._lastModified;
        }

        public String getEncoding() {
            return this._encoding;
        }

        boolean isValid() throws IOException {
            if (this._cached.isUptoDate()) {
                if (HttpContext.this._mostRecentlyUsed != this) {
                    CachedMetaData tp = this._prev;
                    CachedMetaData tn = this._next;
                    this._next = HttpContext.this._mostRecentlyUsed;
                    HttpContext.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (tp != null) {
                        tp._next = tn;
                    }
                    if (tn != null) {
                        tn._prev = tp;
                    }
                    if (HttpContext.this._leastRecentlyUsed == this && tp != null) {
                        HttpContext.this._leastRecentlyUsed = tp;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        public void invalidate() {
            HttpContext.this._cache.remove(this._key);
            HttpContext.this._cacheSize = HttpContext.this._cacheSize - (int)this._cached.length();
            if (HttpContext.this._mostRecentlyUsed == this) {
                HttpContext.this._mostRecentlyUsed = this._next;
            } else {
                this._prev._next = this._next;
            }
            if (HttpContext.this._leastRecentlyUsed == this) {
                HttpContext.this._leastRecentlyUsed = this._prev;
            } else {
                this._next._prev = this._prev;
            }
            this._prev = null;
            this._next = null;
        }
    }

    public class ResourceMetaData {
        protected String _name;
        protected Resource _resource;

        ResourceMetaData(Resource resource) {
            this._resource = resource;
            this._name = this._resource.toString();
            this._resource.setAssociate(this);
        }

        public String getLength() {
            return Long.toString(this._resource.length());
        }

        public String getLastModified() {
            return HttpFields.__dateSend.format(new Date(this._resource.lastModified()));
        }

        public String getEncoding() {
            return HttpContext.this.getMimeByExtension(this._name);
        }
    }
}

