/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserPrincipal;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class HttpRequest
extends HttpMessage {
    public static final String __GET = "GET";
    public static final String __POST = "POST";
    public static final String __HEAD = "HEAD";
    public static final String __PUT = "PUT";
    public static final String __OPTIONS = "OPTIONS";
    public static final String __DELETE = "DELETE";
    public static final String __TRACE = "TRACE";
    public static final String __CONNECT = "CONNECT";
    public static final String __MOVE = "MOVE";
    public static int __maxFormContentSize = Integer.getInteger("org.mortbay.http.HttpRequest.maxFormContentSize", 200000);
    public static int __maxLineLength = 4096;
    public static final StringMap __methodCache = new StringMap(true);
    public static final StringMap __versionCache = new StringMap(true);
    private static Cookie[] __noCookies;
    private String _method = null;
    private URI _uri = null;
    private String _host;
    private String _hostPort;
    private int _port;
    private List _te;
    private MultiMap _parameters;
    private boolean _paramsExtracted;
    private boolean _handled;
    private Cookie[] _cookies;
    private String[] _lastCookies;
    private boolean _cookiesExtracted;
    private long _timeStamp;
    private String _timeStampStr;
    private UserPrincipal _userPrincipal;
    private String _authUser;
    private String _authType;

    public HttpRequest() {
    }

    public HttpRequest(HttpConnection connection) {
        super(connection);
    }

    public String getTimeStampStr() {
        if (this._timeStampStr == null && this._timeStamp > 0L) {
            this._timeStampStr = HttpFields.__dateCache.format(this._timeStamp);
        }
        return this._timeStampStr;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public HttpResponse getResponse() {
        return this.getHttpResponse();
    }

    public HttpResponse getHttpResponse() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getResponse();
    }

    public boolean isHandled() {
        if (this._handled) {
            return true;
        }
        HttpResponse response = this.getHttpResponse();
        return response != null && response.getState() != 0;
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public void readHeader(LineInput in) throws IOException {
        LineInput.LineBuffer line_buffer;
        this._state = 1;
        do {
            if ((line_buffer = in.readLineBuffer()) != null) continue;
            throw new EOFException();
        } while (line_buffer.size == 0);
        if (line_buffer.size >= __maxLineLength) {
            throw new HttpException(414);
        }
        this.decodeRequestLine(line_buffer.buffer, line_buffer.size);
        this._timeStamp = System.currentTimeMillis();
        if ("HTTP/1.1".equals(this._version)) {
            this._dotVersion = 1;
            this._version = "HTTP/1.1";
            this._header.read(in);
            this.setMimeAndEncoding(this._header.get("Content-Type"));
        } else if ("HTTP/0.9".equals(this._version)) {
            this._dotVersion = -1;
            this._version = "HTTP/0.9";
        } else {
            this._dotVersion = 0;
            this._version = "HTTP/1.0";
            this._header.read(in);
            this.setMimeAndEncoding(this._header.get("Content-Type"));
        }
        this._handled = false;
        this._state = 2;
    }

    public void writeRequestLine(Writer writer) throws IOException {
        writer.write(this._method);
        writer.write(32);
        writer.write(this._uri != null ? this._uri.toString() : "null");
        writer.write(32);
        writer.write(this._version);
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException("Not MSG_EDITABLE");
        }
        this._state = 1;
        this.writeRequestLine(writer);
        writer.write(HttpFields.__CRLF);
        this._header.write(writer);
        this._state = 3;
    }

    public String getRequestLine() {
        return this._method + " " + this._uri + " " + this._version;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._method = method;
    }

    public String getVersion() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRootURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getPort();
            url.append(scheme);
            url.append("://");
            if (this._hostPort != null) {
                url.append(this._hostPort);
            } else {
                url.append(this.getHost());
                if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                    url.append(':');
                    url.append(port);
                }
            }
            return url;
        }
    }

    public StringBuffer getRequestURL() {
        StringBuffer buf = this.getRootURL();
        buf.append(this.getPath());
        return buf;
    }

    public URI getURI() {
        return this._uri;
    }

    public String getScheme() {
        String scheme = this._uri.getScheme();
        if (scheme == null && this._connection != null) {
            scheme = this._connection.getDefaultScheme();
        }
        return scheme == null ? "http" : scheme;
    }

    public boolean isIntegral() {
        return this._connection.getListener().isIntegral(this._connection);
    }

    public boolean isConfidential() {
        return this._connection.getListener().isConfidential(this._connection);
    }

    public String getHost() {
        if (this._host != null) {
            return this._host;
        }
        this._host = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._host != null) {
            return this._host;
        }
        this._host = this._hostPort = this._header.get("Host");
        this._port = 0;
        if (this._host != null && this._host.length() > 0) {
            int colon = this._host.indexOf(58);
            if (colon >= 0) {
                if (colon < this._host.length()) {
                    try {
                        this._port = TypeUtil.parseInt(this._host, colon + 1, -1, 10);
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                this._host = this._host.substring(0, colon);
            }
            return this._host;
        }
        if (this._connection != null) {
            this._host = this._connection.getServerName();
            this._port = this._connection.getServerPort();
            if (this._host != null && !"0.0.0.0".equals(this._host)) {
                return this._host;
            }
        }
        try {
            this._host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Code.ignore(e);
        }
        return this._host;
    }

    public int getPort() {
        if (this._port > 0) {
            return this._port;
        }
        if (this._host != null) {
            return 0;
        }
        if (this._uri.isAbsolute()) {
            this._port = this._uri.getPort();
        } else if (this._connection != null) {
            this._port = this._connection.getServerPort();
        }
        return this._port;
    }

    public String getPath() {
        return this._uri.getPath();
    }

    public void setPath(String path) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        if (this._uri == null) {
            this._uri = new URI(path);
        } else {
            this._uri.setURI(path);
        }
    }

    public String getEncodedPath() {
        return this._uri.getEncodedPath();
    }

    public String getQuery() {
        return this._uri.getQuery();
    }

    public void setQuery(String q) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._uri.setQuery(q);
    }

    public String getRemoteAddr() {
        String addr = "127.0.0.1";
        HttpConnection connection = this.getHttpConnection();
        if (connection != null && (addr = connection.getRemoteAddr()) == null) {
            addr = connection.getRemoteHost();
        }
        return addr;
    }

    public String getRemoteHost() {
        String host = "127.0.0.1";
        HttpConnection connection = this.getHttpConnection();
        if (connection != null && (host = connection.getRemoteHost()) == null) {
            host = connection.getRemoteAddr();
        }
        return host;
    }

    /*
     * Unable to fully structure code
     */
    void decodeRequestLine(char[] buf, int len) throws IOException {
        s1 = -1;
        s2 = -1;
        s3 = -1;
        state = 0;
        i = 0;
        block12: while (i < len) {
            c = buf[i];
            switch (state) {
                case 0: {
                    if (c == ' ') ** GOTO lbl25
                    state = 1;
                    s1 = i;
                }
                case 1: {
                    if (c == ' ') {
                        state = 2;
                    } else {
                        s2 = i;
                        if (c >= 'a' && c <= 'z') {
                            buf[i] = (char)(c - 97 + 65);
                        } else {
                            ** GOTO lbl21
                        }
                    }
                }
                {
lbl21:
                    // 3 sources

                    ** GOTO lbl25
                }
                case 2: {
                    s3 = i;
                    if (c != ' ') break block12;
                }
lbl25:
                // 5 sources

                default: {
                    ++i;
                }
            }
        }
        e1 = -1;
        e2 = -1;
        e3 = -1;
        state = 0;
        i = len;
        block13: while (i-- > 0) {
            c = buf[i];
            switch (state) {
                case 0: {
                    if (c == ' ') ** GOTO lbl50
                    state = 1;
                    e1 = i;
                }
                case 1: {
                    if (c == ' ') {
                        state = 2;
                    } else {
                        e2 = i;
                    }
                }
                {
                    ** GOTO lbl50
                }
                case 2: {
                    e3 = i;
                    if (c != ' ') break block13;
                }
lbl50:
                // 5 sources

                default: {
                    continue block13;
                }
            }
        }
        if (s3 < 0 || e1 < 0 || e3 < s2) {
            throw new IOException("Bad Request: " + new String(buf, 0, len));
        }
        method = HttpRequest.__methodCache.getEntry(buf, s1, s2 - s1 + 1);
        this._method = method != null ? (String)method.getKey() : new String(buf, s1, s2 - s1 + 1).toUpperCase();
        if (s2 != e3 || s3 != e2) {
            version = HttpRequest.__versionCache.getEntry(buf, e2, e1 - e2 + 1);
            if (version != null) {
                this._version = (String)version.getKey();
            } else {
                i = e2;
                while (i <= e1) {
                    if (buf[i] >= 'a' && buf[i] <= 'z') {
                        buf[i] = (char)(buf[i] - 97 + 65);
                    }
                    ++i;
                }
                this._version = new String(buf, e2, e1 - e2 + 1);
            }
        } else {
            this._version = "HTTP/0.9";
            e3 = e1;
        }
        try {
            raw_uri = new String(buf, s3, e3 - s3 + 1);
            if (this._uri == null) {
                this._uri = new URI(raw_uri);
            } else {
                this._uri.setURI(raw_uri);
            }
        }
        catch (IllegalArgumentException e) {
            Code.ignore(e);
            throw new HttpException(400, new String(buf, s3, e3 - s3 + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object forceRemoveField(String name) {
        int saved_state = this._state;
        try {
            this._state = 0;
            String string = this.removeField(name);
            Object var5_4 = null;
            this._state = saved_state;
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._state = saved_state;
            throw throwable;
        }
    }

    public List getAcceptableTransferCodings() {
        if (this._dotVersion < 1) {
            return null;
        }
        if (this._te != null) {
            return this._te;
        }
        Enumeration tenum = this.getFieldValues("TE", ", \t");
        if (tenum != null) {
            List te = HttpFields.qualityList(tenum);
            int size = te.size();
            if (size > 0) {
                Object acceptable = null;
                ListIterator iter = te.listIterator();
                while (iter.hasNext()) {
                    String coding = StringUtil.asciiToLowerCase(HttpFields.valueParameters(iter.next().toString(), null));
                    if ("trailer".equalsIgnoreCase(coding)) {
                        HttpResponse response = this.getHttpResponse();
                        if (response == null) continue;
                        response.setAcceptTrailer(true);
                        continue;
                    }
                    if ("chunked".equalsIgnoreCase(coding)) continue;
                    acceptable = LazyList.add(acceptable, size, coding);
                }
                this._te = LazyList.getList(acceptable);
            } else {
                this._te = Collections.EMPTY_LIST;
            }
        } else {
            this._te = Collections.EMPTY_LIST;
        }
        return this._te;
    }

    private void extractParameters() {
        block17: {
            String content_type;
            String encoding;
            if (this._paramsExtracted) {
                return;
            }
            this._paramsExtracted = true;
            if (this._parameters == null) {
                this._parameters = new MultiMap(16);
            }
            if ((encoding = this.getCharacterEncoding()) == null) {
                encoding = StringUtil.__ISO_8859_1;
                this._uri.putParametersTo(this._parameters);
            } else {
                String query = this._uri.getQuery();
                if (query != null) {
                    try {
                        byte[] qbytes = query.getBytes(StringUtil.__ISO_8859_1);
                        UrlEncoded.decodeTo(qbytes, 0, qbytes.length, this._parameters, encoding);
                    }
                    catch (Exception e) {
                        this._uri.putParametersTo(this._parameters);
                    }
                }
            }
            if (this._state != 2 || (content_type = this.getField("Content-Type")) == null || content_type.length() <= 0) break block17;
            content_type = StringUtil.asciiToLowerCase(content_type);
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(content_type = HttpFields.valueParameters(content_type, null)) && __POST.equals(this.getMethod())) {
                int content_length = this.getIntField("Content-Length");
                if (content_length == 0) {
                    Code.debug("No form content");
                } else {
                    try {
                        ByteArrayOutputStream2 bout = new ByteArrayOutputStream2(content_length > 0 ? content_length : 4096);
                        InputStream in = this.getInputStream();
                        int max = content_length;
                        if (max < 0) {
                            max = __maxFormContentSize;
                        } else if (max > __maxFormContentSize) {
                            Code.warning("Form content truncated");
                            max = __maxFormContentSize;
                        }
                        IO.copy(in, bout, (long)max);
                        byte[] content = bout.getBuf();
                        UrlEncoded.decodeTo(content, 0, bout.getCount(), this._parameters, encoding);
                    }
                    catch (EOFException e) {
                        Code.ignore(e);
                    }
                    catch (IOException e) {
                        if (Code.debug()) {
                            Code.warning(e);
                            break block17;
                        }
                        Code.warning(e.toString());
                    }
                }
            }
        }
    }

    public MultiMap getParameters() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters;
    }

    public Set getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.keySet();
    }

    public String getParameter(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(name, 0);
    }

    public List getParameterValues(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.getValues(name);
    }

    public Map getParameterStringArrayMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.toStringArrayMap();
    }

    public Cookie[] getCookies() {
        if (this._cookies != null && this._cookiesExtracted) {
            return this._cookies;
        }
        try {
            if (!this._header.containsKey("Cookie")) {
                this._cookies = __noCookies;
                this._cookiesExtracted = true;
                this._lastCookies = null;
                return this._cookies;
            }
            if (this._lastCookies != null) {
                int last = 0;
                Enumeration enumeration = this._header.getValues("Cookie");
                while (enumeration.hasMoreElements()) {
                    String c = (String)enumeration.nextElement();
                    if (last >= this._lastCookies.length || !c.equals(this._lastCookies[last])) {
                        this._lastCookies = null;
                        break;
                    }
                    ++last;
                }
                if (this._lastCookies != null) {
                    this._cookiesExtracted = true;
                    return this._cookies;
                }
            }
            Object cookies = null;
            Object lastCookies = null;
            int version = 0;
            Cookie cookie = null;
            Enumeration enumeration = this._header.getValues("Cookie");
            while (enumeration.hasMoreElements()) {
                String hdr = enumeration.nextElement().toString();
                lastCookies = LazyList.add(lastCookies, hdr);
                QuotedStringTokenizer tok = new QuotedStringTokenizer(hdr, ",;", false, false);
                while (tok.hasMoreElements()) {
                    String c = (String)tok.nextElement();
                    if (c != null) {
                        c = c.trim();
                    }
                    try {
                        String v;
                        String n;
                        if (c.startsWith("JSESSION_ID=")) {
                            n = "JSESSION_ID";
                            v = c.substring(12);
                        } else {
                            int e = c.indexOf(61);
                            if (e > 0) {
                                n = c.substring(0, e);
                                v = c.substring(e + 1);
                            } else {
                                n = c;
                                v = "";
                            }
                        }
                        if (version > 0) {
                            v = StringUtil.unquote(v);
                        }
                        if (n.startsWith("$")) {
                            if ("$version".equalsIgnoreCase(n)) {
                                int comma = v.indexOf(44);
                                if (comma < 0) continue;
                                version = Integer.parseInt(StringUtil.unquote(v.substring(0, comma)));
                                int e = (v = v.substring(comma + 1)).indexOf(61);
                                if (e > 0) {
                                    n = v.substring(0, e);
                                    v = v.substring(e + 1);
                                    v = StringUtil.unquote(v);
                                } else {
                                    n = v;
                                    v = "";
                                }
                            } else {
                                if ("$path".equalsIgnoreCase(n) && cookie != null) {
                                    cookie.setPath(v);
                                    continue;
                                }
                                if (!"$domain".equalsIgnoreCase(n) || cookie == null) continue;
                                cookie.setDomain(v);
                                continue;
                            }
                        }
                        v = URI.decodePath(v);
                        cookie = new Cookie(n, v);
                        if (version > 0) {
                            cookie.setVersion(version);
                        }
                        cookies = LazyList.add(cookies, cookie);
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                        Code.warning("Bad Cookie received: " + e.toString());
                    }
                }
            }
            int l = LazyList.size(cookies);
            if (this._cookies == null || this._cookies.length != l) {
                this._cookies = new Cookie[l];
            }
            int i = 0;
            while (i < l) {
                this._cookies[i] = (Cookie)LazyList.get(cookies, i);
                ++i;
            }
            this._cookiesExtracted = true;
            l = LazyList.size(lastCookies);
            this._lastCookies = new String[l];
            int i2 = 0;
            while (i2 < l) {
                this._lastCookies[i2] = (String)LazyList.get(lastCookies, i2);
                ++i2;
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        return this._cookies;
    }

    public boolean isUserInRole(String role) {
        UserPrincipal principal = this.getUserPrincipal();
        if (principal != null && principal instanceof UserPrincipal) {
            return principal.isUserInRole(role);
        }
        return false;
    }

    public String getAuthType() {
        return this._authType;
    }

    public void setAuthType(String a) {
        this._authType = a;
    }

    public String getAuthUser() {
        return this._authUser;
    }

    public void setAuthUser(String user) {
        this._authUser = user;
    }

    public UserPrincipal getUserPrincipal() {
        return this._userPrincipal;
    }

    public void setUserPrincipal(UserPrincipal principal) {
        this._userPrincipal = principal;
    }

    void recycle(HttpConnection connection) {
        this._method = null;
        this._host = null;
        this._hostPort = null;
        this._port = 0;
        this._te = null;
        if (this._parameters != null) {
            this._parameters.clear();
        }
        this._paramsExtracted = false;
        this._handled = false;
        this._cookiesExtracted = false;
        this._timeStamp = 0L;
        this._timeStampStr = null;
        this._authUser = null;
        this._authType = null;
        this._userPrincipal = null;
        super.recycle(connection);
    }

    public void destroy() {
        this._parameters = null;
        this._method = null;
        this._uri = null;
        this._host = null;
        this._hostPort = null;
        this._te = null;
        this._cookies = null;
        this._lastCookies = null;
        this._timeStampStr = null;
        this._userPrincipal = null;
        this._authUser = null;
        this._authUser = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        super.destroy();
    }

    static {
        __methodCache.put(__GET, (Object)null);
        __methodCache.put(__POST, (Object)null);
        __methodCache.put(__HEAD, (Object)null);
        __methodCache.put(__PUT, (Object)null);
        __methodCache.put(__OPTIONS, (Object)null);
        __methodCache.put(__DELETE, (Object)null);
        __methodCache.put(__TRACE, (Object)null);
        __methodCache.put(__CONNECT, (Object)null);
        __methodCache.put(__MOVE, (Object)null);
        __versionCache.put("HTTP/1.1", (Object)null);
        __versionCache.put("HTTP/1.0", (Object)null);
        __versionCache.put("HTTP/0.9", (Object)null);
        __noCookies = new Cookie[0];
    }
}

