/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;

public class AJP13Connection
extends HttpConnection {
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getFilterStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut, true);
        this._listener = listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        packet = null;
        request = this.getRequest();
        response = this.getResponse();
        context = null;
        gotRequest = false;
        this._persistent = true;
        this._keepAlive = true;
        try {
            try {
                block65: {
                    try {
                        packet = null;
                        packet = this._ajpIn.nextPacket();
                        if (packet != null) ** GOTO lbl-1000
                        var6_6 = false;
                        ** GOTO lbl54
                    }
                    catch (IOException e) {
                        Code.ignore(e);
                        var7_54 = false;
                        var15_14 = null;
                        if (packet == null) return false;
                        if (!gotRequest) {
                            return false;
                        }
                        try {
                            try {
                                this.getOutputStream().close();
                                if (!this._persistent) {
                                    this._ajpOut.end();
                                }
                                this._ajpOut.close();
                                this.getOutputStream().resetStream();
                                this.getOutputStream().addObserver(this);
                                this.getInputStream().resetStream();
                                this._ajpIn.resetStream();
                                this._ajpOut.resetStream();
                            }
                            catch (Exception e) {
                                Code.debug(e);
                                this._persistent = false;
                                var18_26 = null;
                                this.statsRequestEnd();
                                if (context == null) return var7_54;
                                context.log(request, response, -1);
                                return var7_54;
                            }
                            var18_25 = null;
                        }
                        catch (Throwable var17_49) {
                            var18_27 = null;
                            this.statsRequestEnd();
                            if (context == null) throw var17_49;
                            context.log(request, response, -1);
                            throw var17_49;
                        }
lbl54:
                        // 1 sources

                        var15_12 = null;
                        if (packet == null) return false;
                        if (!gotRequest) {
                            return false;
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (packet.getDataSize() != 0) break block65;
                            var6_7 = true;
                        }
                        ** GOTO lbl312
                        this.statsRequestEnd();
                        if (context == null) return var7_54;
                        context.log(request, response, -1);
                        return var7_54;
                    }
                }
                type = packet.getByte();
                if (Code.debug()) {
                    Code.debug("AJP13 type=" + type + " size=" + packet.unconsumedData());
                }
                switch (type) {
                    case 2: {
                        request.setTimeStamp(System.currentTimeMillis());
                        request.setState(0);
                        request.setMethod(packet.getMethod());
                        request.setVersion(packet.getString());
                        request.setPath(packet.getString());
                        this._remoteAddr = packet.getString();
                        this._remoteHost = packet.getString();
                        this._serverName = packet.getString();
                        this._serverPort = packet.getInt();
                        this._isSSL = packet.getBoolean();
                        this._keepAlive = request.getDotVersion() >= 1;
                        h = packet.getInt();
                        for (i = 0; i < h; ++i) {
                            hdr = packet.getHeader();
                            val = packet.getString();
                            request.setField(hdr, val);
                            if (this._keepAlive || !hdr.equalsIgnoreCase("Connection") || !val.equalsIgnoreCase("keep-alive")) continue;
                            this._keepAlive = true;
                        }
                        attr = packet.getByte();
                        while ((255 & attr) != 255) {
                            value = packet.getString();
                            switch (attr) {
                                case 10: {
                                    request.setAttribute(value, packet.getString());
                                    break;
                                }
                                case 9: {
                                    break;
                                }
                                case 8: {
                                    request.setAttribute("javax.servlet.request.cipher_suite", value);
                                    break;
                                }
                                case 7: {
                                    cf = CertificateFactory.getInstance("X.509");
                                    certstream = new ByteArrayInputStream(value.getBytes());
                                    cert = (X509Certificate)cf.generateCertificate(certstream);
                                    certs = new X509Certificate[]{cert};
                                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                    break;
                                }
                                case 6: {
                                    request.setAttribute("org.mortbay.http.ajp.JVMRoute", value);
                                    break;
                                }
                                case 5: {
                                    request.setQuery(value);
                                    break;
                                }
                                case 4: {
                                    request.setAuthType(value);
                                    break;
                                }
                                case 3: {
                                    request.setAuthUser(value);
                                    break;
                                }
                                default: {
                                    Code.warning("Unknown attr: " + attr + "=" + value);
                                }
                            }
                            attr = packet.getByte();
                        }
                        this._listener.customizeRequest(this, request);
                        gotRequest = true;
                        this.statsRequestStart();
                        request.setState(2);
                        if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                            this._ajpIn.close();
                        }
                        response.setState(0);
                        response.setVersion("HTTP/1.1");
                        response.setDateField("Date", this._request.getTimeStamp());
                        response.setField("Server", Version.__VersionDetail);
                        Code.debug((Object)"REQUEST:\n", (Object)request);
                        context = this.service(request, response);
                        Code.debug((Object)"RESPONSE:\n", (Object)response);
                        ** break;
                    }
                }
                Code.debug("Ignored: " + packet);
                this._persistent = false;
                ** GOTO lbl350
            }
            catch (SocketException e) {
                Code.ignore(e);
                this._persistent = false;
                var15_16 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var17_51) {
                    var18_33 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_51;
                    context.log(request, response, -1);
                    throw var17_51;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_32 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var18_31 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
            catch (Exception e) {
                Code.warning(e);
                this._persistent = false;
                try {
                    if (gotRequest) {
                        this._ajpOut.close();
                    }
                }
                catch (IOException e2) {
                    Code.ignore(e2);
                }
                var15_17 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var17_52) {
                    var18_36 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_52;
                    context.log(request, response, -1);
                    throw var17_52;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_35 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var18_34 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
        }
        catch (Throwable var14_63) {
            block66: {
                var15_18 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var17_53) {
                    var18_39 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_53;
                    context.log(request, response, -1);
                    throw var17_53;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_38 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var14_63;
                    context.log(request, response, -1);
                    throw var14_63;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                break block66;
lbl-1000:
                // 1 sources

                try {}
                catch (Throwable var17_47) {
                    var18_21 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_47;
                    context.log(request, response, -1);
                    throw var17_47;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_20 = null;
                    this.statsRequestEnd();
                    if (context == null) return var6_6;
                    context.log(request, response, -1);
                    return var6_6;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var18_19 = null;
                this.statsRequestEnd();
                if (context == null) return var6_6;
                context.log(request, response, -1);
                return var6_6;
lbl312:
                // 1 sources

                var15_13 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var17_48) {
                    var18_24 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_48;
                    context.log(request, response, -1);
                    throw var17_48;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_23 = null;
                    this.statsRequestEnd();
                    if (context == null) return var6_7;
                    context.log(request, response, -1);
                    return var6_7;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var18_22 = null;
                this.statsRequestEnd();
                if (context == null) return var6_7;
                context.log(request, response, -1);
                return var6_7;
lbl350:
                // 2 sources

                var15_15 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var17_50) {
                    var18_30 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_50;
                    context.log(request, response, -1);
                    throw var17_50;
                }
                try {}
                catch (Exception e) {
                    Code.debug(e);
                    this._persistent = false;
                    var18_29 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var18_28 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
            var18_37 = null;
            this.statsRequestEnd();
            if (context == null) throw var14_63;
            context.log(request, response, -1);
            throw var14_63;
        }
    }

    protected void firstWrite() throws IOException {
        Code.debug("ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        Code.debug("ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

