/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.StringMap;
import org.mortbay.util.URI;

public class ProxyHandler
extends AbstractHttpHandler {
    protected Set _proxyHostsWhiteList;
    protected Set _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 250;
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxySchemes;
    protected HashSet _allowedConnectPorts;

    public ProxyHandler() {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Proxy-Authorization", o);
        this._DontProxyHeaders.put("Proxy-Authenticate", o);
        this._DontProxyHeaders.put("Upgrade", o);
        this._ProxySchemes = new StringMap();
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(new Integer(80));
        this._allowedConnectPorts.add(new Integer(8000));
        this._allowedConnectPorts.add(new Integer(8080));
        this._allowedConnectPorts.add(new Integer(8888));
        this._allowedConnectPorts.add(new Integer(443));
        this._allowedConnectPorts.add(new Integer(8443));
    }

    public String[] getProxyHostsWhiteList() {
        if (this._proxyHostsWhiteList == null || this._proxyHostsWhiteList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsWhiteList.size()];
        hosts = this._proxyHostsWhiteList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsWhiteList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsWhiteList = null;
        } else {
            this._proxyHostsWhiteList = new HashSet();
            for (int i = 0; i < hosts.length; ++i) {
                if (hosts[i] == null || hosts[i].trim().length() <= 0) continue;
                this._proxyHostsWhiteList.add(hosts[i]);
            }
        }
    }

    public String[] getProxyHostsBlackList() {
        if (this._proxyHostsBlackList == null || this._proxyHostsBlackList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsBlackList.size()];
        hosts = this._proxyHostsBlackList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsBlackList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsBlackList = null;
        } else {
            this._proxyHostsBlackList = new HashSet();
            for (int i = 0; i < hosts.length; ++i) {
                if (hosts[i] == null || hosts[i].trim().length() <= 0) continue;
                this._proxyHostsBlackList.add(hosts[i]);
            }
        }
    }

    public int getTunnelTimeoutMs() {
        return this._tunnelTimeoutMs;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block22: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                response.setField("Connection", "close");
                this.handleConnect(pathInContext, pathParams, request, response);
                return;
            }
            try {
                String cache_control;
                String connectionHdr;
                URL url = this.isProxied(uri);
                if (url == null) {
                    if (this.isForbidden(uri)) {
                        this.sendForbid(request, response, uri);
                    }
                    return;
                }
                Code.debug((Object)"PROXY URL=", (Object)url);
                URLConnection connection = url.openConnection();
                connection.setAllowUserInteraction(false);
                HttpURLConnection http = null;
                if (connection instanceof HttpURLConnection) {
                    http = (HttpURLConnection)connection;
                    http.setRequestMethod(request.getMethod());
                    http.setInstanceFollowRedirects(false);
                }
                if ((connectionHdr = request.getField("Connection")) != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
                    connectionHdr = null;
                }
                boolean xForwardedFor = false;
                boolean hasContent = false;
                Enumeration enumeration = request.getFieldNames();
                while (enumeration.hasMoreElements()) {
                    String hdr = (String)enumeration.nextElement();
                    if (this._DontProxyHeaders.containsKey(hdr) || connectionHdr != null && connectionHdr.indexOf(hdr) >= 0) continue;
                    if ("Content-Type".equals(hdr)) {
                        hasContent = true;
                    }
                    Enumeration vals = request.getFieldValues(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        connection.addRequestProperty(hdr, val);
                        xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                    }
                }
                connection.setRequestProperty("Via", "1.1 (jetty)");
                if (!xForwardedFor) {
                    connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
                }
                if ((cache_control = request.getField("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                    connection.setUseCaches(false);
                }
                this.customizeConnection(pathInContext, pathParams, request, connection);
                try {
                    connection.setDoInput(true);
                    InputStream in = request.getInputStream();
                    if (hasContent) {
                        connection.setDoOutput(true);
                        IO.copy(in, connection.getOutputStream());
                    }
                    connection.connect();
                }
                catch (Exception e) {
                    Code.ignore(e);
                }
                InputStream proxy_in = null;
                int code = 500;
                if (http != null) {
                    proxy_in = http.getErrorStream();
                    code = http.getResponseCode();
                    response.setStatus(code);
                    response.setReason(http.getResponseMessage());
                }
                if (proxy_in == null) {
                    try {
                        proxy_in = connection.getInputStream();
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                        proxy_in = http.getErrorStream();
                    }
                }
                response.removeField("Date");
                response.removeField("Server");
                int h = 0;
                String hdr = connection.getHeaderFieldKey(h);
                String val = connection.getHeaderField(h);
                while (hdr != null || val != null) {
                    if (hdr != null && val != null && !this._DontProxyHeaders.containsKey(hdr)) {
                        response.addField(hdr, val);
                    }
                    hdr = connection.getHeaderFieldKey(++h);
                    val = connection.getHeaderField(h);
                }
                response.setField("Via", "1.1 (jetty)");
                request.setHandled(true);
                if (proxy_in != null) {
                    IO.copy(proxy_in, response.getOutputStream());
                }
            }
            catch (Exception e) {
                Code.warning(e.toString());
                Code.ignore(e);
                if (response.isCommitted()) break block22;
                response.sendError(400);
            }
        }
    }

    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block6: {
            URI uri = request.getURI();
            try {
                Code.debug((Object)"CONNECT: ", (Object)uri);
                InetAddrPort addrPort = new InetAddrPort(uri.toString());
                if (this.isForbidden("https", addrPort.getHost(), addrPort.getPort(), false)) {
                    this.sendForbid(request, response, uri);
                    break block6;
                }
                Socket socket = new Socket(addrPort.getInetAddress(), addrPort.getPort());
                int timeoutMs = 30000;
                if (this._tunnelTimeoutMs > 0) {
                    socket.setSoTimeout(this._tunnelTimeoutMs);
                    Object maybesocket = request.getHttpConnection().getConnection();
                    try {
                        Socket s = (Socket)maybesocket;
                        timeoutMs = s.getSoTimeout();
                        s.setSoTimeout(this._tunnelTimeoutMs);
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                this.customizeConnection(pathInContext, pathParams, request, socket);
                request.getHttpConnection().setHttpTunnel(new HttpTunnel(socket, timeoutMs));
                response.setStatus(200);
                response.setContentLength(0);
                request.setHandled(true);
            }
            catch (Exception e) {
                Code.ignore(e);
                response.sendError(500);
            }
        }
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, Socket socket) throws IOException {
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, URLConnection connection) throws IOException {
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        if (this.isForbidden(uri)) {
            return null;
        }
        return new URL(uri.toString());
    }

    protected boolean isForbidden(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return this.isForbidden(scheme, host, port, true);
    }

    protected boolean isForbidden(String scheme, String host, int port, boolean openNonPrivPorts) {
        Integer p = new Integer(port);
        if (!(port <= 0 || this._allowedConnectPorts.contains(p) || openNonPrivPorts && port > 1024)) {
            return true;
        }
        if (scheme == null || !this._ProxySchemes.containsKey(scheme)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(host)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(host);
    }

    protected void sendForbid(HttpRequest request, HttpResponse response, URI uri) throws IOException {
        response.sendError(403, "Forbidden for Proxy");
    }
}

