/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.util.Code;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class WebApplicationHandler
extends ServletHandler {
    private Map _filterMap = new HashMap();
    private List _pathFilters = new ArrayList();
    private List _filters = new ArrayList();
    private MultiMap _servletFilterMap = new MultiMap();
    private boolean _acceptRanges = true;
    private transient boolean _started = false;

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public FilterHolder defineFilter(String name, String className) {
        FilterHolder holder = new FilterHolder(this, name, className);
        this._filterMap.put(holder.getName(), holder);
        this._filters.add(holder);
        return holder;
    }

    public FilterHolder getFilter(String name) {
        return (FilterHolder)this._filterMap.get(name);
    }

    public FilterHolder mapServletToFilter(String servletName, String filterName) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("Unknown filter :" + filterName);
        }
        Code.debug((Object)"Filter servlet ", servletName, (Object)" --> ", filterName);
        this._servletFilterMap.add(servletName, holder);
        holder.addServlet(servletName);
        return holder;
    }

    public List getFilters() {
        return this._filters;
    }

    public FilterHolder mapPathToFilter(String pathSpec, String filterName) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("Unknown filter :" + filterName);
        }
        Code.debug((Object)"Filter path ", pathSpec, (Object)" --> ", filterName);
        if (!holder.isMappedToPath()) {
            this._pathFilters.add(holder);
        }
        holder.addPathSpec(pathSpec);
        return holder;
    }

    public boolean isStarted() {
        return this._started && super.isStarted();
    }

    public synchronized void start() throws Exception {
        super.start();
        Code.debug((Object)"Path Filters: ", (Object)this._pathFilters);
        Code.debug((Object)"Servlet Filters: ", (Object)this._servletFilterMap);
        this._started = true;
    }

    public void initializeServlets() throws Exception {
        MultiException mex = new MultiException();
        Iterator iter = this._filters.iterator();
        while (iter.hasNext()) {
            FilterHolder holder = (FilterHolder)iter.next();
            try {
                holder.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        try {
            super.initializeServlets();
        }
        catch (Exception e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws InterruptedException {
        try {
            super.stop();
            int i = this._filters.size();
            while (i-- > 0) {
                FilterHolder holder = (FilterHolder)this._filters.get(i);
                holder.stop();
            }
        }
        finally {
            this._started = false;
        }
    }

    protected void dispatch(String pathInContext, HttpServletRequest request, HttpServletResponse response, ServletHolder servletHolder) throws ServletException, UnavailableException, IOException {
        Object o;
        FilterHolder holder;
        int requestType = 0;
        if (request instanceof Dispatcher.DispatcherRequest) {
            HttpContext context = this.getHttpContext();
            if (context != null && context instanceof ServletHttpContext && pathInContext != null && pathInContext.endsWith("j_security_check")) {
                ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
                ServletHttpResponse servletHttpResponse = (ServletHttpResponse)response;
                ServletHttpContext servletContext = (ServletHttpContext)context;
                if (!servletContext.jSecurityCheck(pathInContext, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                    return;
                }
            }
            requestType = ((Dispatcher.DispatcherRequest)request).getFilterType();
        } else {
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
            ServletHttpResponse servletHttpResponse = (ServletHttpResponse)response;
            HttpResponse httpResponse = servletHttpResponse.getHttpResponse();
            if (httpResponse.getStatus() != 200) {
                requestType = 8;
            } else {
                requestType = 1;
                if (StringUtil.startsWithIgnoreCase(pathInContext, "/web-inf") || StringUtil.startsWithIgnoreCase(pathInContext, "/meta-inf")) {
                    response.sendError(404);
                    return;
                }
                if (!this.getHttpContext().checkSecurityConstraints(pathInContext, servletHttpRequest.getHttpRequest(), httpResponse)) {
                    return;
                }
            }
        }
        Object filters = null;
        if (pathInContext != null && this._pathFilters.size() > 0) {
            for (int i = 0; i < this._pathFilters.size(); ++i) {
                holder = (FilterHolder)this._pathFilters.get(i);
                if (!holder.appliesTo(pathInContext, requestType)) continue;
                filters = LazyList.add(filters, holder);
            }
        }
        if (servletHolder != null && this._servletFilterMap.size() > 0 && (o = this._servletFilterMap.get(servletHolder.getName())) != null) {
            if (o instanceof List) {
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    FilterHolder holder2 = (FilterHolder)list.get(i);
                    if (!holder2.appliesTo(requestType)) continue;
                    filters = LazyList.add(filters, holder2);
                }
            } else {
                holder = (FilterHolder)o;
                if (holder.appliesTo(requestType)) {
                    filters = LazyList.add(filters, holder);
                }
            }
        }
        if (LazyList.size(filters) > 0) {
            Chain chain = new Chain(pathInContext, filters, servletHolder);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (servletHolder != null) {
            if (Code.verbose()) {
                Code.debug((Object)"call servlet ", (Object)servletHolder);
            }
            servletHolder.handle((ServletRequest)request, (ServletResponse)response);
        } else {
            this.notFound(request, response);
        }
    }

    private class Chain
    implements FilterChain {
        String _pathInContext;
        int _filter = 0;
        Object _filters;
        ServletHolder _servletHolder;

        Chain(String pathInContext, Object filters, ServletHolder servletHolder) {
            this._pathInContext = pathInContext;
            this._filters = filters;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (Code.verbose()) {
                Code.debug((Object)"doFilter ", this._filter);
            }
            if (this._filter < LazyList.size(this._filters)) {
                FilterHolder holder = (FilterHolder)LazyList.get(this._filters, this._filter++);
                if (Code.verbose()) {
                    Code.debug((Object)"call filter ", (Object)holder);
                }
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (Code.verbose()) {
                    Code.debug((Object)"call servlet ", (Object)this._servletHolder);
                }
                this._servletHolder.handle(request, response);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }
}

