/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.ChunkingInputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class HttpInputStream
extends FilterInputStream {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$HttpInputStream == null ? (class$org$mortbay$http$HttpInputStream = HttpInputStream.class$("org.mortbay.http.HttpInputStream")) : class$org$mortbay$http$HttpInputStream));
    private static ClosedStream __closedStream = new ClosedStream();
    private ChunkingInputStream _deChunker;
    private LineInput _realIn;
    private boolean _chunking;
    static /* synthetic */ Class class$org$mortbay$http$HttpInputStream;

    public HttpInputStream(InputStream in) {
        this(in, 4096);
    }

    public HttpInputStream(InputStream in, int bufferSize) {
        super(null);
        try {
            this._realIn = new LineInput(in, bufferSize, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)e);
            System.exit(1);
        }
        this.in = this._realIn;
    }

    public InputStream getInputStream() {
        return this._realIn;
    }

    public InputStream getFilterStream() {
        return this.in;
    }

    public void setFilterStream(InputStream filter) {
        this.in = filter;
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking() throws IllegalStateException {
        if (this._realIn.getByteLimit() >= 0) {
            throw new IllegalStateException("Has Content-Length");
        }
        if (this._deChunker == null) {
            this._deChunker = new ChunkingInputStream(this._realIn);
        }
        this.in = this._deChunker;
        this._chunking = true;
        this._deChunker._trailer = null;
    }

    public void resetStream() throws IllegalStateException {
        if (this._deChunker != null && this._deChunker._chunkSize > 0 || this._realIn.getByteLimit() > 0) {
            throw new IllegalStateException("Unread input");
        }
        if (LogSupport.isTraceEnabled(log)) {
            log.trace((Object)"resetStream()");
        }
        this.in = this._realIn;
        if (this._deChunker != null) {
            this._deChunker.resetStream();
        }
        this._chunking = false;
        this._realIn.setByteLimit(-1);
    }

    public void close() throws IOException {
        this.in = __closedStream;
    }

    public void setContentLength(int len) {
        if (this._chunking && len >= 0) {
            throw new IllegalStateException("Chunking");
        }
        this._realIn.setByteLimit(len);
    }

    public int getContentLength() {
        return this._realIn.getByteLimit();
    }

    public HttpFields getTrailer() {
        return this._deChunker._trailer;
    }

    public void destroy() {
        if (this._realIn != null) {
            this._realIn.destroy();
        }
        this._realIn = null;
        this._deChunker = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClosedStream
    extends InputStream {
        private ClosedStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

