/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class ForwardHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$handler$ForwardHandler == null ? (class$org$mortbay$http$handler$ForwardHandler = ForwardHandler.class$("org.mortbay.http.handler.ForwardHandler")) : class$org$mortbay$http$handler$ForwardHandler));
    PathMap _forward = new PathMap();
    String _root;
    boolean _handleQueries = false;
    static /* synthetic */ Class class$org$mortbay$http$handler$ForwardHandler;

    public ForwardHandler() {
    }

    public ForwardHandler(String rootForward) {
        this._root = rootForward;
    }

    public void addForward(String pathSpecInContext, String newPath) {
        this._forward.put(pathSpecInContext, newPath);
    }

    public void setRootForward(String newPath) {
        this._root = newPath;
    }

    public void setHandleQueries(boolean b) {
        this._handleQueries = b;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (LogSupport.isTraceEnabled(log)) {
            log.trace((Object)("Look for " + pathInContext + " in " + this._forward));
        }
        String newPath = null;
        String query = null;
        if (this._root != null && ("/".equals(pathInContext) || pathInContext.startsWith("/;"))) {
            newPath = this._root;
        } else {
            Map.Entry entry = this._forward.getMatch(pathInContext);
            if (entry != null) {
                int hook;
                String match = (String)entry.getValue();
                if (this._handleQueries && (hook = match.indexOf(63)) != -1) {
                    query = match.substring(hook + 1);
                    match = match.substring(0, hook);
                }
                String info = PathMap.pathInfo((String)entry.getKey(), pathInContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Forward: match:\"" + match + "\" info:" + info + "\" query:" + query));
                }
                String string = newPath = info == null ? match : URI.addPaths(match, info);
            }
        }
        if (newPath != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Forward from " + pathInContext + " to " + newPath));
            }
            int last = request.setState(0);
            String context = this.getHttpContext().getContextPath();
            if (context.length() == 1) {
                request.setPath(newPath);
            } else {
                request.setPath(URI.addPaths(context, newPath));
            }
            if (this._handleQueries && query != null) {
                UrlEncoded.decodeTo(query, request.getParameters());
            }
            request.setState(last);
            this.getHttpContext().getHttpServer().service(request, response);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

