/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.JarResource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;

public class WebApplicationContext
extends ServletHttpContext
implements Externalizable {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext));
    private String _defaultsDescriptor = "org/mortbay/jetty/servlet/webdefault.xml";
    private String _war;
    private boolean _extract;
    private boolean _ignorewebjetty;
    private boolean _distributable;
    private Configuration _configuration;
    private transient String _name;
    private transient Map _resourceAliases;
    private transient Resource _webApp;
    private transient Resource _webInf;
    private transient WebApplicationHandler _webAppHandler;
    private transient Object _contextListeners;
    private transient Object _contextAttributeListeners;
    private transient Map _errorPages;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationContext;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationHandler;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHandler;

    public WebApplicationContext() {
    }

    public WebApplicationContext(String webApp) {
        this._war = webApp;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getContextPath());
        out.writeObject(this.getVirtualHosts());
        HttpHandler[] handlers = this.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i] instanceof WebApplicationHandler) break;
            out.writeObject(handlers[i]);
            ++i;
        }
        out.writeObject(this.getAttributes());
        out.writeBoolean(this.isRedirectNullPath());
        out.writeInt(this.getMaxCachedFileSize());
        out.writeInt(this.getMaxCacheSize());
        out.writeBoolean(this.getStatsOn());
        out.writeObject(this.getPermissions());
        out.writeBoolean(this.isClassLoaderJava2Compliant());
        out.writeObject(this._defaultsDescriptor);
        out.writeObject(this._war);
        out.writeBoolean(this._extract);
        out.writeBoolean(this._ignorewebjetty);
        out.writeBoolean(this._distributable);
        out.writeObject(this._configuration);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setContextPath((String)in.readObject());
        this.setVirtualHosts((String[])in.readObject());
        Object o = in.readObject();
        while (o instanceof HttpHandler) {
            this.addHandler((HttpHandler)o);
            o = in.readObject();
        }
        this.setAttributes((Map)o);
        this.setRedirectNullPath(in.readBoolean());
        this.setMaxCachedFileSize(in.readInt());
        this.setMaxCacheSize(in.readInt());
        this.setStatsOn(in.readBoolean());
        this.setPermissions((PermissionCollection)in.readObject());
        this.setClassLoaderJava2Compliant(in.readBoolean());
        this._defaultsDescriptor = (String)in.readObject();
        this._war = (String)in.readObject();
        this._extract = in.readBoolean();
        this._ignorewebjetty = in.readBoolean();
        this._distributable = in.readBoolean();
        this._configuration = (Configuration)in.readObject();
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setWAR(String war) {
        this._war = war;
    }

    public String getWAR() {
        return this._war;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        if (this._webAppHandler == null) {
            this.getServletHandler();
        }
        return this._webAppHandler;
    }

    private void resolveWebApp() throws IOException {
        if (this._webApp == null && this._war != null && this._war.length() > 0) {
            Resource jarWebApp;
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.getAlias() != null) {
                log.info((Object)(this._webApp + " anti-aliased to " + this._webApp.getAlias()));
                this._webApp = Resource.newResource(this._webApp.getAlias());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
            }
            if (this._webApp.exists() && !this._webApp.isDirectory() && !this._webApp.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + this._webApp + "!/")).exists() && jarWebApp.isDirectory()) {
                this._webApp = jarWebApp;
                this._war = this._webApp.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (this._webApp.exists() && (!this._webApp.isDirectory() || this._extract && this._webApp.getFile() == null || this._extract && this._webApp.getFile() != null && !this._webApp.getFile().isDirectory())) {
                File tempDir = new File(this.getTempDirectory(), "webapp");
                if (tempDir.exists()) {
                    tempDir.delete();
                }
                tempDir.mkdir();
                tempDir.deleteOnExit();
                log.info((Object)("Extract " + this._war + " to " + tempDir));
                JarResource.extract(this._webApp, tempDir, true);
                this._webApp = Resource.newResource(tempDir.getCanonicalPath());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (!this._webApp.exists() || !this._webApp.isDirectory()) {
                log.warn((Object)("Web application not found " + this._war));
                throw new FileNotFoundException(this._war);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("webapp=" + this._webApp));
            }
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            } else {
                Resource work = this._webInf.addPath("work");
                if (work.exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
                    this.setAttribute("javax.servlet.context.tempdir", work.getFile());
                }
            }
            super.setBaseResource(this._webApp);
        }
    }

    public Resource getWebInf() throws IOException {
        if (this._webInf == null) {
            this.resolveWebApp();
        }
        return this._webInf;
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._webAppHandler == null) {
            this._webAppHandler = (WebApplicationHandler)this.getHandler(class$org$mortbay$jetty$servlet$WebApplicationHandler == null ? (class$org$mortbay$jetty$servlet$WebApplicationHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationHandler")) : class$org$mortbay$jetty$servlet$WebApplicationHandler);
            if (this._webAppHandler == null) {
                if (this.getHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler) != null) {
                    throw new IllegalStateException("Cannot have ServletHandler in WebApplicationContext");
                }
                this._webAppHandler = new WebApplicationHandler();
                this.addHandler(this._webAppHandler);
            }
        }
        return this._webAppHandler;
    }

    public void setPermissions(PermissionCollection permissions) {
        if (!this._ignorewebjetty) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
        super.setPermissions(permissions);
    }

    public boolean isIgnoreWebJetty() {
        return this._ignorewebjetty;
    }

    public void setIgnoreWebJetty(boolean b) {
        this._ignorewebjetty = b;
        if (b && this.getPermissions() != null) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.setWelcomeFiles(null);
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        MultiException mex = null;
        try {
            try {
                ServletHolder jspHolder;
                this.resolveWebApp();
                this.getServletHandler();
                Configuration config = this._configuration;
                if (config == null) {
                    config = (Configuration)Loader.loadClass(class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext, "org.mortbay.jetty.servlet.XMLConfiguration").getConstructors()[0].newInstance(this);
                }
                config.configureClassPath();
                this.initClassLoader(true);
                thread.setContextClassLoader(this.getClassLoader());
                this.initialize();
                config.configureDefaults();
                Map.Entry entry = this._webAppHandler.getHolderEntry("test.jsp");
                if (entry != null && (jspHolder = (ServletHolder)entry.getValue()) != null && jspHolder.getInitParameter("classpath") == null) {
                    String fileClassPath = this.getFileClassPath();
                    jspHolder.setInitParameter("classpath", fileClassPath);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Set classpath=" + fileClassPath + " for " + jspHolder));
                    }
                }
                config.configureWebApp();
                this._webAppHandler.setAutoInitializeServlets(false);
                super.start();
                mex = new MultiException();
                if (super.isStarted() && this._contextListeners != null && this._webAppHandler != null) {
                    ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                    int i = 0;
                    while (i < LazyList.size(this._contextListeners)) {
                        try {
                            ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized(event);
                        }
                        catch (Exception ex) {
                            mex.add(ex);
                        }
                        ++i;
                    }
                }
                if (this._webAppHandler != null && this._webAppHandler.isStarted()) {
                    try {
                        this._webAppHandler.initializeServlets();
                    }
                    catch (Exception ex) {
                        mex.add(ex);
                    }
                }
                Object var10_12 = null;
                thread.setContextClassLoader(lastContextLoader);
            }
            catch (Exception e) {
                log.warn((Object)("Configuration error on " + this._war), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            thread.setContextClassLoader(lastContextLoader);
            throw throwable;
        }
        if (mex != null) {
            mex.ifExceptionThrow();
        }
    }

    public void stop() throws InterruptedException {
        if (this._contextListeners != null && this._webAppHandler != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            int i = LazyList.size(this._contextListeners);
            while (i-- > 0) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextDestroyed(event);
            }
        }
        this._contextListeners = null;
        this._contextAttributeListeners = null;
        super.stop();
        this.clearSecurityConstraints();
        if (this._webAppHandler != null) {
            this.removeHandler(this._webAppHandler);
        }
        this._webAppHandler = null;
        if (this._errorPages != null) {
            this._errorPages.clear();
        }
        this._errorPages = null;
        this._webApp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        if (!this.isStarted()) {
            return;
        }
        try {
            super.handle(pathInContext, pathParams, httpRequest, httpResponse);
        }
        finally {
            if (!httpRequest.isHandled()) {
                httpResponse.sendError(404);
            }
            httpRequest.setHandled(true);
            if (!httpResponse.isCommitted()) {
                httpResponse.commit();
            }
        }
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        boolean known = false;
        if (listener instanceof ServletContextListener) {
            known = true;
            this._contextListeners = LazyList.add(this._contextListeners, listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            known = true;
            this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
        }
        if (!known) {
            throw new IllegalArgumentException("Unknown " + listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        this._contextListeners = LazyList.remove(this._contextListeners, listener);
        this._contextAttributeListeners = LazyList.remove(this._contextAttributeListeners, listener);
    }

    public synchronized void setAttribute(String name, Object value) {
        Object old = super.getAttribute(name);
        super.setAttribute(name, value);
        if (this._contextAttributeListeners != null && this._webAppHandler != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old != null ? old : value);
            int i = 0;
            while (i < LazyList.size(this._contextAttributeListeners)) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                if (old == null) {
                    l.attributeAdded(event);
                } else if (value == null) {
                    l.attributeRemoved(event);
                } else {
                    l.attributeReplaced(event);
                }
                ++i;
            }
        }
    }

    public synchronized void removeAttribute(String name) {
        Object old = super.getAttribute(name);
        super.removeAttribute(name);
        if (old != null && this._contextAttributeListeners != null && this._webAppHandler != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old);
            int i = 0;
            while (i < LazyList.size(this._contextAttributeListeners)) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                l.attributeRemoved(event);
                ++i;
            }
        }
    }

    public String getDisplayName() {
        return this._name;
    }

    public void setDisplayName(String name) {
        this._name = name;
    }

    public void setDefaultsDescriptor(String defaults) {
        this._defaultsDescriptor = defaults;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setExtractWAR(boolean extract) {
        this._extract = extract;
    }

    public boolean getExtractWAR() {
        return this._extract;
    }

    protected void initialize() throws Exception {
    }

    protected UserRealm getUserRealm(String name) {
        return this.getHttpServer().getRealm(name);
    }

    public String toString() {
        return "WebApplicationContext[" + this.getHttpContextName() + "," + (this._name == null ? this._war : this._name) + "]";
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public Resource getResource(String uriInContext) throws IOException {
        IOException ioe = null;
        Resource resource = null;
        try {
            resource = super.getResource(uriInContext);
            if (resource != null && resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        String aliasedUri = this.getResourceAlias(uriInContext);
        if (aliasedUri != null) {
            return super.getResource(aliasedUri);
        }
        if (ioe != null) {
            throw ioe;
        }
        return resource;
    }

    public void setErrorPage(String error, String uriInContext) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(error, uriInContext);
    }

    public String getErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.get(error);
    }

    public String removeErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.remove(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Configuration
    implements Serializable {
        private WebApplicationContext _context;

        public Configuration(WebApplicationContext context) {
            this._context = context;
        }

        public WebApplicationContext getWebApplicationContext() {
            return this._context;
        }

        public WebApplicationHandler getWebApplicationHandler() {
            return this._context.getWebApplicationHandler();
        }

        public void configureClassPath() throws Exception {
            Resource webInf = this._context.getWebInf();
            if (webInf != null && webInf.isDirectory()) {
                Resource classes = webInf.addPath("classes/");
                if (classes.exists()) {
                    this._context.setClassPath(classes.toString());
                } else {
                    this._context.setClassPath(null);
                }
                Resource lib = webInf.addPath("lib/");
                this._context.addClassPaths(lib);
            }
        }

        public void configureDefaults() throws Exception {
        }

        public void configureWebApp() throws Exception {
        }
    }
}

