/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Pool;

public class ThreadPool
implements LifeCycle,
Serializable {
    static Log log = LogFactory.getLog((Class)(class$org$mortbay$util$ThreadPool == null ? (class$org$mortbay$util$ThreadPool = ThreadPool.class$("org.mortbay.util.ThreadPool")) : class$org$mortbay$util$ThreadPool));
    public static final String __DAEMON = "org.mortbay.util.ThreadPool.daemon";
    public static final String __PRIORITY = "org.mortbay.util.ThreadPool.priority";
    private String _name;
    private Pool _pool = new Pool();
    private Object _join = "";
    private transient boolean _started;
    static /* synthetic */ Class class$org$mortbay$util$ThreadPool;
    static /* synthetic */ Class class$org$mortbay$util$ThreadPool$PoolThread;
    static /* synthetic */ Class class$org$mortbay$util$Pool;

    public ThreadPool() {
        this._pool.setPoolClass(class$org$mortbay$util$ThreadPool$PoolThread == null ? (class$org$mortbay$util$ThreadPool$PoolThread = ThreadPool.class$("org.mortbay.util.ThreadPool$PoolThread")) : class$org$mortbay$util$ThreadPool$PoolThread);
        this._name = this.getClass().getName();
        int dot = this._name.lastIndexOf(46);
        if (dot >= 0) {
            this._name = this._name.substring(dot + 1);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPoolName() {
        return this._pool.getPoolName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolName(String name) {
        Class clazz = class$org$mortbay$util$Pool == null ? (class$org$mortbay$util$Pool = ThreadPool.class$("org.mortbay.util.Pool")) : class$org$mortbay$util$Pool;
        synchronized (clazz) {
            if (this.isStarted()) {
                if (name == null && this._pool.getPoolName() != null || name != null && !name.equals(this._pool.getPoolName())) {
                    throw new IllegalStateException("started");
                }
                return;
            }
            if (name == null) {
                if (this._pool.getPoolName() != null) {
                    this._pool = new Pool();
                }
            } else {
                Pool pool = Pool.getPool(name);
                if (pool == null) {
                    this._pool.setPoolName(name);
                } else {
                    this._pool = pool;
                }
            }
        }
    }

    public boolean isDaemon() {
        return this._pool.getAttribute(__DAEMON) != null;
    }

    public void setDaemon(boolean daemon) {
        this._pool.setAttribute(__DAEMON, daemon ? "true" : null);
    }

    public boolean isStarted() {
        return this._started;
    }

    public int getThreads() {
        return this._pool.size();
    }

    public int getIdleThreads() {
        return this._pool.available();
    }

    public int getMinThreads() {
        return this._pool.getMinSize();
    }

    public void setMinThreads(int minThreads) {
        this._pool.setMinSize(minThreads);
    }

    public int getMaxThreads() {
        return this._pool.getMaxSize();
    }

    public void setMaxThreads(int maxThreads) {
        this._pool.setMaxSize(maxThreads);
    }

    public int getMaxIdleTimeMs() {
        return this._pool.getMaxIdleTimeMs();
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._pool.setMaxIdleTimeMs(maxIdleTimeMs);
    }

    public int getThreadsPriority() {
        int priority = 5;
        Object o = this._pool.getAttribute(__PRIORITY);
        if (o != null) {
            priority = (Integer)o;
        }
        return priority;
    }

    public void setThreadsPriority(int priority) {
        this._pool.setAttribute(__PRIORITY, new Integer(priority));
    }

    public void setMaxStopTimeMs(int ms) {
        log.warn((Object)"setMaxStopTimeMs is deprecated. No longer required.");
    }

    public void start() throws Exception {
        this._started = true;
        this._pool.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        this._started = false;
        this._pool.stop();
        Object object = this._join;
        synchronized (object) {
            this._join.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        while (this.isStarted() && this._pool != null) {
            Object object = this._join;
            synchronized (object) {
                try {
                    if (this.isStarted() && this._pool != null) {
                        this._join.wait(30000L);
                    }
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
        }
    }

    public void shrink() throws InterruptedException {
        this._pool.shrink();
    }

    public void run(Object job) throws InterruptedException {
        if (job == null) {
            return;
        }
        try {
            PoolThread thread = (PoolThread)this._pool.get(this.getMaxIdleTimeMs());
            if (thread != null) {
                thread.run(this, job);
            } else {
                log.warn((Object)("No thread for " + job));
                this.stopJob(null, job);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    protected void handle(Object job) throws InterruptedException {
        if (job != null && job instanceof Runnable) {
            ((Runnable)job).run();
        } else {
            log.warn((Object)("Invalid job: " + job));
        }
    }

    protected void stopJob(Thread thread, Object job) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PoolThread
    extends Thread
    implements Pool.PondLife {
        Pool _pool;
        ThreadPool _jobPool;
        Object _job;
        ThreadPool _runPool;
        Object _run;
        int _id;
        String _name;

        public void enterPool(Pool pool, int id) {
            this._pool = pool;
            this._id = id;
            this._name = this._pool.getPoolName() == null ? "PoolThread-" + id : this._pool.getPoolName() + "-" + id;
            this.setName(this._name);
            this.setDaemon(pool.getAttribute(ThreadPool.__DAEMON) != null);
            Object o = pool.getAttribute(ThreadPool.__PRIORITY);
            if (o != null) {
                this.setPriority((Integer)o);
            }
            this.start();
        }

        public int getID() {
            return this._id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poolClosing() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._run == null) {
                    this.notify();
                } else {
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void leavePool() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._jobPool == null && this._runPool == null) {
                    this.notify();
                }
                if (this._job != null && this._jobPool != null) {
                    this._jobPool.stopJob(this, this._job);
                    this._job = null;
                    this._jobPool = null;
                }
                if (this._run != null && this._runPool != null) {
                    this._runPool.stopJob(this, this._run);
                    this._run = null;
                    this._runPool = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ThreadPool pool, Object job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._jobPool = pool;
                this._job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._run = null;
            this._runPool = null;
            while (this._pool != null && this._pool.isStarted()) {
                PoolThread poolThread;
                try {
                    poolThread = this;
                    synchronized (poolThread) {
                        if (this._run == null && this._pool != null && this._pool.isStarted() && this._job == null) {
                            this.wait(this._pool.getMaxIdleTimeMs());
                        }
                        if (this._job != null) {
                            this._run = this._job;
                            this._job = null;
                            this._runPool = this._jobPool;
                            this._jobPool = null;
                        }
                    }
                    if (this._run != null && this._runPool != null) {
                        this._runPool.handle(this._run);
                    }
                    poolThread = this;
                }
                catch (InterruptedException e) {
                    PoolThread poolThread2;
                    try {
                        LogSupport.ignore(log, e);
                        poolThread2 = this;
                    }
                    catch (Throwable throwable) {
                        PoolThread poolThread3 = this;
                        synchronized (poolThread3) {
                            boolean got = this._run != null;
                            this._run = null;
                            this._runPool = null;
                            try {
                                if (got && this._pool != null) {
                                    this._pool.put(this);
                                }
                            }
                            catch (InterruptedException e2) {
                                LogSupport.ignore(log, e2);
                            }
                        }
                        throw throwable;
                    }
                    synchronized (poolThread2) {
                        boolean got = this._run != null;
                        this._run = null;
                        this._runPool = null;
                        try {
                            if (got && this._pool != null) {
                                this._pool.put(this);
                            }
                        }
                        catch (InterruptedException e3) {
                            LogSupport.ignore(log, e3);
                        }
                        continue;
                    }
                }
                synchronized (poolThread) {
                    boolean got = this._run != null;
                    this._run = null;
                    this._runPool = null;
                    try {
                        if (got && this._pool != null) {
                            this._pool.put(this);
                        }
                    }
                    catch (InterruptedException e) {
                        LogSupport.ignore(log, e);
                    }
                }
            }
        }

        public String toString() {
            return this._name;
        }
    }
}

