/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.LogSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$xml$XmlParser == null ? (class$org$mortbay$xml$XmlParser = XmlParser.class$("org.mortbay.xml.XmlParser")) : class$org$mortbay$xml$XmlParser));
    private Map _redirectMap = new HashMap();
    private SAXParser _parser;
    private Map _observerMap;
    private Stack _observers = new Stack();
    static /* synthetic */ Class class$org$mortbay$xml$XmlParser;

    public XmlParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            boolean notValidating = Boolean.getBoolean("org.mortbay.xml.XmlParser.NotValidating");
            factory.setValidating(!notValidating);
            this._parser = factory.newSAXParser();
            try {
                if (!notValidating) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", true);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Schema validation may not be supported: ", (Throwable)e);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", !notValidating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", !notValidating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", !notValidating);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    public XmlParser(boolean validating) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            this._parser = factory.newSAXParser();
            try {
                if (validating) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", validating);
                }
            }
            catch (Exception e) {
                if (validating) {
                    log.warn((Object)"Schema validation may not be supported: ", (Throwable)e);
                }
                LogSupport.ignore(log, e);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", validating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", validating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", validating);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    public synchronized void redirectEntity(String name, URL entity) {
        if (entity != null) {
            this._redirectMap.put(name, entity);
        }
    }

    public synchronized void addContentHandler(String trigger, ContentHandler observer) {
        if (this._observerMap == null) {
            this._observerMap = new HashMap();
        }
        this._observerMap.put(trigger, observer);
    }

    public synchronized Node parse(InputSource source) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader reader = this._parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsing: sid=" + source.getSystemId() + ",pid=" + source.getPublicId()));
        }
        this._parser.parse(source, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    public synchronized Node parse(String url) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse: " + url));
        }
        return this.parse(new InputSource(url));
    }

    public synchronized Node parse(File file) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse: " + file));
        }
        return this.parse(new InputSource(file.toURL().toString()));
    }

    public synchronized Node parse(InputStream in) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader reader = this._parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        this._parser.parse(new InputSource(in), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node parse(URL url) throws IOException, SAXException {
        Node n = null;
        InputStream is = url.openStream();
        try {
            n = this.parse(is);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception e) {}
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Node
    extends AbstractList {
        Node _parent;
        private ArrayList _list;
        private String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;

        Node(Node parent, String tag, Attributes attrs) {
            this._parent = parent;
            this._tag = tag;
            if (attrs != null) {
                this._attrs = new Attribute[attrs.getLength()];
                int i = 0;
                while (i < attrs.getLength()) {
                    String name = attrs.getLocalName(i);
                    if (name == null || name.equals("")) {
                        name = attrs.getQName(i);
                    }
                    this._attrs[i] = new Attribute(name, attrs.getValue(i));
                    ++i;
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String name) {
            return this.getAttribute(name, null);
        }

        public String getAttribute(String name, String dft) {
            if (this._attrs == null || name == null) {
                return dft;
            }
            int i = 0;
            while (i < this._attrs.length) {
                if (name.equals(this._attrs[i].getName())) {
                    return this._attrs[i].getValue();
                }
                ++i;
            }
            return dft;
        }

        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        public Object get(int i) {
            if (this._list != null) {
                return this._list.get(i);
            }
            return null;
        }

        public Node get(String tag) {
            if (this._list != null) {
                int i = 0;
                while (i < this._list.size()) {
                    Object o = this._list.get(i);
                    if (o instanceof Node) {
                        Node n = (Node)o;
                        if (tag.equals(n._tag)) {
                            return n;
                        }
                    }
                    ++i;
                }
            }
            return null;
        }

        public void add(int i, Object o) {
            if (this._list == null) {
                this._list = new ArrayList();
            }
            if (o instanceof String) {
                if (this._lastString) {
                    int last = this._list.size() - 1;
                    this._list.set(last, (String)this._list.get(last) + o);
                } else {
                    this._list.add(i, o);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.add(i, o);
            }
        }

        public void clear() {
            if (this._list != null) {
                this._list.clear();
            }
            this._list = null;
        }

        public String getString(String tag, boolean tags, boolean trim) {
            Node node = this.get(tag);
            if (node == null) {
                return null;
            }
            String s = node.toString(tags);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean tag) {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer();
            synchronized (stringBuffer) {
                this.toString(buf, tag);
                return buf.toString();
            }
        }

        public synchronized String toString(boolean tag, boolean trim) {
            String s = this.toString(tag);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        private synchronized void toString(StringBuffer buf, boolean tag) {
            int i;
            if (tag) {
                buf.append("<");
                buf.append(this._tag);
                if (this._attrs != null) {
                    i = 0;
                    while (i < this._attrs.length) {
                        buf.append(' ');
                        buf.append(this._attrs[i].getName());
                        buf.append("=\"");
                        buf.append(this._attrs[i].getValue());
                        buf.append("\"");
                        ++i;
                    }
                }
            }
            if (this._list != null) {
                if (tag) {
                    buf.append(">");
                }
                i = 0;
                while (i < this._list.size()) {
                    Object o = this._list.get(i);
                    if (o != null) {
                        if (o instanceof Node) {
                            ((Node)o).toString(buf, tag);
                        } else {
                            buf.append(o.toString());
                        }
                    }
                    ++i;
                }
                if (tag) {
                    buf.append("</");
                    buf.append(this._tag);
                    buf.append(">");
                }
            } else if (tag) {
                buf.append("/>");
            }
        }

        public Iterator iterator(final String tag) {
            return new Iterator(){
                int c = 0;
                Node _node;

                /*
                 * Unable to fully structure code
                 */
                public boolean hasNext() {
                    if (this._node == null) ** GOTO lbl8
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        o = Node.access$500(this).get(this.c);
                        if (o instanceof Node && tag.equals(Node.access$600(n = (Node)o))) {
                            this._node = n;
                            return true;
                        }
                        ++this.c;
lbl8:
                        // 2 sources

                        ** while (Node.access$500((Node)this) != null && this.c < Node.access$500((Node)this).size())
                    }
lbl9:
                    // 1 sources

                    return false;
                }

                public Object next() {
                    block3: {
                        try {
                            if (!this.hasNext()) break block3;
                            Node node = this._node;
                            Object var3_2 = null;
                            this._node = null;
                            ++this.c;
                            return node;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            this._node = null;
                            ++this.c;
                            throw throwable;
                        }
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }

        static /* synthetic */ ArrayList access$500(Node x0) {
            return x0._list;
        }

        static /* synthetic */ String access$600(Node x0) {
            return x0._tag;
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String n, String v) {
            this._name = n;
            this._value = v;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;

        private Handler() {
            this._context = this._top = new Node(null, null, null);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String name = uri == null || uri.equals("") ? qName : localName;
            Node node = new Node(this._context, name, attrs);
            this._context.add(node);
            this._context = node;
            ContentHandler observer = null;
            if (XmlParser.this._observerMap != null) {
                observer = (ContentHandler)XmlParser.this._observerMap.get(name);
            }
            XmlParser.this._observers.push(observer);
            int i = 0;
            while (i < XmlParser.this._observers.size()) {
                if (XmlParser.this._observers.get(i) != null) {
                    ((ContentHandler)XmlParser.this._observers.get(i)).startElement(uri, localName, qName, attrs);
                }
                ++i;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this._context = this._context._parent;
            int i = 0;
            while (i < XmlParser.this._observers.size()) {
                if (XmlParser.this._observers.get(i) != null) {
                    ((ContentHandler)XmlParser.this._observers.get(i)).endElement(uri, localName, qName);
                }
                ++i;
            }
            XmlParser.this._observers.pop();
        }

        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            int i = 0;
            while (i < XmlParser.this._observers.size()) {
                if (XmlParser.this._observers.get(i) != null) {
                    ((ContentHandler)XmlParser.this._observers.get(i)).ignorableWhitespace(buf, offset, len);
                }
                ++i;
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            this._context.add(new String(buf, offset, len));
            int i = 0;
            while (i < XmlParser.this._observers.size()) {
                if (XmlParser.this._observers.get(i) != null) {
                    ((ContentHandler)XmlParser.this._observers.get(i)).characters(buf, offset, len);
                }
                ++i;
            }
        }

        public void warning(SAXParseException ex) {
            log.debug((Object)"EXCEPTION ", (Throwable)ex);
            log.warn((Object)("WARNING@" + this.getLocationString(ex) + " : " + ex.toString()));
        }

        public void error(SAXParseException ex) throws SAXException {
            if (this._error == null) {
                this._error = ex;
            }
            log.debug((Object)"EXCEPTION ", (Throwable)ex);
            log.warn((Object)("ERROR@" + this.getLocationString(ex) + " : " + ex.toString()));
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this._error = ex;
            log.debug((Object)"EXCEPTION ", (Throwable)ex);
            log.warn((Object)("FATAL@" + this.getLocationString(ex) + " : " + ex.toString()));
            throw ex;
        }

        private String getLocationString(SAXParseException ex) {
            return ex.getSystemId() + " line:" + ex.getLineNumber() + " col:" + ex.getColumnNumber();
        }

        public InputSource resolveEntity(String pid, String sid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolveEntity(" + pid + ", " + sid + ")"));
            }
            URL entity = null;
            if (pid != null) {
                entity = (URL)XmlParser.this._redirectMap.get(pid);
            }
            if (entity == null) {
                entity = (URL)XmlParser.this._redirectMap.get(sid);
            }
            if (entity == null) {
                String dtd = sid;
                if (dtd.lastIndexOf(47) >= 0) {
                    dtd = dtd.substring(dtd.lastIndexOf(47) + 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't exact match entity in redirect map, trying " + dtd));
                }
                entity = (URL)XmlParser.this._redirectMap.get(dtd);
            }
            if (entity != null) {
                try {
                    InputStream in = entity.openStream();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirected entity " + sid + " --> " + entity));
                    }
                    InputSource is = new InputSource(in);
                    is.setSystemId(sid);
                    return is;
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
            }
            return null;
        }
    }
}

