/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.util.B64Code;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class BasicAuthenticator
implements SecurityConstraint.Authenticator {
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response, boolean check) throws IOException {
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            try {
                Code.debug((Object)"Credentials: ", (Object)credentials);
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(58);
                String username = credentials.substring(0, i);
                if (check) {
                    String password = credentials.substring(i + 1);
                    user = realm.authenticate(username, password, request);
                } else {
                    user = realm.getUserPrincipal(username);
                }
                if (user != null) {
                    request.setAuthType("BASIC");
                    request.setAuthUser(username);
                    request.setUserPrincipal(user);
                } else if (check) {
                    Code.warning("AUTH FAILURE: user " + username);
                }
            }
            catch (Exception e) {
                Code.warning("AUTH FAILURE: " + e.toString());
                Code.ignore(e);
            }
        }
        if (user == null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, HttpResponse response) throws IOException {
        response.setField("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }
}

