/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.Principal;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.util.Code;
import org.mortbay.util.Credential;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class DigestAuthenticator
implements SecurityConstraint.Authenticator {
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response, boolean check) throws IOException {
        if (realm == null) {
            response.sendError(500, "Realm Not Configured");
            return null;
        }
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            Code.debug("Credentials: " + credentials);
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
            Digest digest = new Digest(request.getMethod());
            String last = null;
            String name = null;
            block5: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        name = last;
                        last = tok;
                        break;
                    }
                    case ',': {
                        name = null;
                    }
                    case ' ': {
                        break;
                    }
                    default: {
                        last = tok;
                        if (name == null) continue block5;
                        if ("username".equalsIgnoreCase(name)) {
                            digest.username = tok;
                            if (check) continue block5;
                            break block5;
                        }
                        if ("realm".equalsIgnoreCase(name)) {
                            digest.realm = tok;
                            break;
                        }
                        if ("nonce".equalsIgnoreCase(name)) {
                            digest.nonce = tok;
                            break;
                        }
                        if ("nc".equalsIgnoreCase(name)) {
                            digest.nc = tok;
                            break;
                        }
                        if ("cnonce".equalsIgnoreCase(name)) {
                            digest.cnonce = tok;
                            break;
                        }
                        if ("qop".equalsIgnoreCase(name)) {
                            digest.qop = tok;
                            break;
                        }
                        if ("uri".equalsIgnoreCase(name)) {
                            digest.uri = tok;
                            break;
                        }
                        if (!"response".equalsIgnoreCase(name)) continue block5;
                        digest.response = tok;
                    }
                }
            }
            Principal principal = user = check ? realm.authenticate(digest.username, digest, request) : realm.getUserPrincipal(digest.username);
            if (user != null) {
                request.setAuthType("DIGEST");
                request.setAuthUser(digest.username);
                request.setUserPrincipal(user);
            } else if (check) {
                Code.warning("AUTH FAILURE: user " + digest.username);
            }
        }
        if (user == null) {
            this.sendChallenge(realm, request, response);
        }
        return user;
    }

    public String getAuthMethod() {
        return "DIGEST";
    }

    public void sendChallenge(UserRealm realm, HttpRequest request, HttpResponse response) throws IOException {
        response.setField("WWW-Authenticate", "digest realm=\"" + realm.getName() + "\" domain=\"" + "/" + "\" nonce=\"" + Long.toString(request.getTimeStamp(), 27) + "\"");
        response.sendError(401);
    }

    private static class Digest
    extends Credential {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        public boolean check(Object credentials) {
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(this.username.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.realm.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(password.getBytes(StringUtil.__ISO_8859_1));
                byte[] ha1 = md.digest();
                md.reset();
                md.update(this.method.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StringUtil.__ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString(ha1, 16).getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(TypeUtil.toString(ha2, 16).getBytes(StringUtil.__ISO_8859_1));
                byte[] digest = md.digest();
                return TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                Code.warning(e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

